/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class Ipv6Utils {
    public static String encode(String address) {
        if (address != null && !address.contains("%3A")) {
            try {
                return URLEncoder.encode(address, StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return address;
    }

    public static String decode(String address) {
        if (address != null) {
            try {
                return URLDecoder.decode(address, StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return address;
    }

    public static String bracketWrap(String address) {
        if (address == null) {
            return address;
        }
        if (address.split(":").length > 2) {
            if (address.startsWith("[")) {
                return address;
            }
            return "[" + address + "]";
        }
        return address;
    }

    public static String bracketStrip(String address) {
        String strippedAddress;
        if (address != null && (strippedAddress = address.strip()).startsWith("[") && strippedAddress.endsWith("]")) {
            address = strippedAddress.substring(1, strippedAddress.length() - 1);
        }
        return address;
    }

    public static HostPort parseHostPort(String address) {
        int index = address.lastIndexOf(58);
        if (index > 0) {
            return new HostPort(address.substring(0, index), address.substring(index + 1));
        }
        throw new IllegalArgumentException();
    }

    public static HostPort uriToOs(String address) {
        HostPort hostPort = Ipv6Utils.parseHostPort(address);
        return new HostPort(Ipv6Utils.encode(hostPort.getHost()), hostPort.getPort());
    }

    public static String decodeAndWrap(String address) {
        return Ipv6Utils.bracketWrap(Ipv6Utils.decode(address));
    }

    public static String encodedFaultIdPathToUri(String path, String faultID) {
        path = ((String)path).replaceFirst("/", ":").replace("/index.hfml", "").replace(".hfml", "") + "(" + faultID + ")";
        return Ipv6Utils.encodedPathToUri((String)path, ":");
    }

    public static String encodedPathToUri(String path, String delimiter) {
        int index = path.indexOf(delimiter);
        return Ipv6Utils.decodeAndWrap(path.substring(0, index)) + path.substring(index);
    }

    public static String stripAndEncode(String host) {
        return Ipv6Utils.encode(Ipv6Utils.bracketStrip(host));
    }

    public static class HostPort {
        private String host;
        private String port;

        public HostPort(String host, String port) {
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public String getPort() {
            return this.port;
        }

        public int hashCode() {
            return Objects.hash(this.host, this.port);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HostPort other = (HostPort)obj;
            return Objects.equals(this.host, other.host) && Objects.equals(this.port, other.port);
        }
    }
}

