/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.util;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.util.ArrayUtils;
import com.ibm.pdtools.common.component.jhost.util.PDGenerics;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public abstract class GUI {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(GUI.class);
    private static final int DEFAULT_SPAN_H = 1;
    private static final int DEFAULT_SPAN_V = 1;
    private static final int LAYOUT_HEIGHT_MARGIN = 6;
    private static final int LAYOUT_WIDTH_MARGIN = 10;

    public static DateTime time(Composite parent, Object layoutData, int style) {
        DateTime time = new DateTime(parent, style | 0x800);
        time.setLayoutData(GUI.checkLayoutData(layoutData, parent));
        time.setFont(parent.getFont());
        return time;
    }

    public static Combo combo(Composite parent, Object layoutData, int extraStyles, String toolTip, boolean enabled) {
        Objects.requireNonNull(parent, "Must specify a non-null parent.");
        Objects.requireNonNull(layoutData, "Must specify a non-null layoutData.");
        Objects.requireNonNull(toolTip, "Must specify a non-null tooltip.");
        Combo c = GUI.combo(parent, layoutData, extraStyles);
        c.setToolTipText(toolTip);
        c.setEnabled(enabled);
        return c;
    }

    public static Combo combo(Composite parent, Object layoutData, int extraStyles) {
        Combo combo2 = new Combo(parent, extraStyles);
        combo2.setLayoutData(GUI.checkLayoutData(layoutData, parent));
        combo2.setFont(parent.getFont());
        return combo2;
    }

    public static Composite composite(Composite parent, Layout layout, Object layoutData) {
        if (parent == null) {
            throw new IllegalArgumentException("Must provide a non-null parent Composite.");
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayout(GUI.checkLayout(layout));
        composite.setLayoutData(GUI.checkLayoutData(layoutData, parent));
        composite.setFont(parent.getFont());
        return composite;
    }

    public static ScrolledComposite scrolledComposite(Composite parent, int extraStyles) {
        int scrollSpeedMultiplier = 3;
        final ScrolledComposite scrolledComposite = new ScrolledComposite(parent, extraStyles);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.addListener(26, new Listener(){

            public void handleEvent(Event e) {
                scrolledComposite.setFocus();
            }
        });
        int scrollIncrementSize = scrolledComposite.getVerticalBar().getIncrement() * scrollSpeedMultiplier;
        scrolledComposite.getVerticalBar().setIncrement(scrollIncrementSize);
        return scrolledComposite;
    }

    public static Group group(Composite parent, String text2, Layout layout, Object layoutData) {
        Group group = new Group(parent, 4);
        group.setLayout(GUI.checkLayout(layout));
        group.setLayoutData(GUI.checkLayoutData(layoutData, parent));
        group.setFont(parent.getFont());
        group.setText(GUI.checkString(text2));
        return group;
    }

    public static Group group(Composite parent, String text2, Layout layout, Object layoutData, int style) {
        Group group = new Group(parent, style);
        group.setLayout(GUI.checkLayout(layout));
        group.setLayoutData(GUI.checkLayoutData(layoutData, parent));
        group.setFont(parent.getFont());
        group.setText(GUI.checkString(text2));
        return group;
    }

    public static Label label(Composite parent, String text2, Object layoutData, int style) {
        Label label2 = new Label(parent, style);
        label2.setLayoutData(GUI.checkLayoutData(layoutData, parent));
        label2.setFont(parent.getFont());
        label2.setText(GUI.checkString(text2));
        return label2;
    }

    public static Table table(Composite parent, Object layoutData, int style) {
        Table table = new Table(parent, style);
        table.setLayoutData(GUI.checkLayoutData(layoutData, parent));
        table.setFont(parent.getFont());
        return table;
    }

    public static Text text(Composite parent, Object layoutData, int extraStyles) {
        Text text2 = new Text(parent, 0x800 | extraStyles);
        text2.setLayoutData(GUI.checkLayoutData(layoutData, parent));
        text2.setFont(parent.getFont());
        return text2;
    }

    public static Button button(Composite parent, String text2, Object layoutData, int style) {
        Button button2 = new Button(parent, style);
        button2.setText(text2);
        button2.setLayoutData(GUI.checkLayoutData(layoutData, parent));
        button2.setFont(parent.getFont());
        return button2;
    }

    private static Layout checkLayout(Layout layout) {
        return layout == null ? grid.l.standard() : layout;
    }

    private static Object checkLayoutData(Object layoutData, Composite parent) {
        Layout layout = parent.getLayout();
        if (layoutData != null) {
            return layoutData;
        }
        if (layout instanceof GridLayout || layout instanceof StackLayout) {
            return grid.d.standard();
        }
        if (layout instanceof FormLayout) {
            return new FormData();
        }
        logger.warn("No default layout data for layout of type " + layout.getClass().getName());
        return null;
    }

    private static String checkString(String text2) {
        return text2 == null ? "" : text2;
    }

    private static int getAvgCharSize(Control control) {
        Font f = control.getFont();
        GC gc = new GC((Drawable)control);
        gc.setFont(f);
        FontMetrics metrics = gc.getFontMetrics();
        gc.dispose();
        return metrics.getAverageCharWidth();
    }

    public static void setTextWidthHint(Text txt, int numChars) {
        GridData gd = null;
        Object layoutData = txt.getLayoutData();
        gd = layoutData instanceof GridData ? (GridData)layoutData : new GridData();
        int avgCharSize = GUI.getAvgCharSize((Control)txt);
        gd.widthHint = numChars * avgCharSize + avgCharSize + 5;
        txt.setLayoutData((Object)gd);
    }

    public static abstract class button {
        public static Button push(Composite parent, String text2, Object layoutData) {
            return GUI.button(parent, text2, layoutData, 8);
        }

        public static Button push(Composite parent, String text2, Object layoutData, String tooltip) {
            Button button2 = GUI.button(parent, text2, layoutData, 8);
            button2.setToolTipText(tooltip);
            return button2;
        }

        public static Button push(Composite parent, Image image, String tooltip, Object layoutData) {
            return button.push(parent, image, tooltip, layoutData, true, 64);
        }

        public static Button push(Composite parent, Image image, String tooltip, Object layoutData, boolean extraStyle, int extraStyles) {
            Button button2 = null;
            button2 = extraStyle ? GUI.button(parent, "", layoutData, 8 | extraStyles) : GUI.button(parent, "", layoutData, 8);
            if (image != null) {
                button2.setImage(image);
            }
            if (tooltip != null) {
                button2.setToolTipText(tooltip);
            }
            return button2;
        }

        public static Button checkbox(Composite parent, String text2, Object layoutData) {
            return GUI.button(parent, text2, layoutData, 32);
        }

        public static Button radio(Composite parent, String text2, Object layoutData) {
            return GUI.button(parent, text2, layoutData, 16);
        }

        public static GridLayout getLayout(int numberOfButtons) {
            return grid.l.customMargins(numberOfButtons, false, 10, 15);
        }

        public static GridData getLayoutData() {
            return new GridData(0x1000008, 0x1000008, true, false);
        }
    }

    public static abstract class combo {
        public static Combo editable(Composite parent, Object layoutData) {
            return GUI.combo(parent, layoutData, 0);
        }

        public static Combo readOnly(Composite parent, Object layoutData, Object[] items) {
            Combo combo2 = GUI.combo(parent, layoutData, 8);
            if (items instanceof String[]) {
                combo2.setItems((String[])items);
            } else {
                combo2.setItems(ArrayUtils.getToStringArray((Object[])items));
            }
            return combo2;
        }

        public static abstract class viewer {
            public static <T> void setSelection(ComboViewer cv, T selection) {
                Objects.requireNonNull(cv, "Must provide a non-null comboViewer.");
                Objects.requireNonNull(selection, "Must provide a non-null selection.");
                cv.setSelection((ISelection)new StructuredSelection(selection));
            }

            public static <T> ComboViewer create(Combo c, T input) {
                return viewer.create(c, (IBaseLabelProvider)new LabelProvider(), (IContentProvider)new ArrayContentProvider(), input);
            }

            private static <T> ComboViewer create(Combo c, IBaseLabelProvider labelProvider, IContentProvider contentProvider, T input) {
                Objects.requireNonNull(c, "Must provide a non-null combo.");
                Objects.requireNonNull(labelProvider, "Must provide a non-null labelProvider.");
                Objects.requireNonNull(contentProvider, "Must provide a non-null contentProvider.");
                Objects.requireNonNull(input, "Must provide a non-null input.");
                ComboViewer cv = new ComboViewer(c);
                cv.setLabelProvider(labelProvider);
                cv.setContentProvider(contentProvider);
                cv.setInput(input);
                return cv;
            }

            public static <T> T getSelection(ComboViewer cv, Class<T> itemClazz, T defaultValue) {
                Object item;
                Objects.requireNonNull(cv, "Must provide a non-null ComboViewer.");
                Objects.requireNonNull(itemClazz, "Must provide a non-null itemClazz.");
                Objects.requireNonNull(defaultValue, "Must provide a non-null defaultValue.");
                ISelection selection = cv.getSelection();
                if (selection instanceof IStructuredSelection && !selection.isEmpty() && (item = PDGenerics.castIfInstanceOf((Object)((IStructuredSelection)selection).getFirstElement(), itemClazz)) != null) {
                    return (T)item;
                }
                return defaultValue;
            }

            public static <ITEM_T> Collection<ITEM_T> getSelection(ComboViewer cv, Class<ITEM_T> itemClazz) {
                Objects.requireNonNull(cv, "Must provide a non-null ComboViewer.");
                Objects.requireNonNull(itemClazz, "Must provide a non-null itemClazz.");
                ArrayList<Object> selectedItems = new ArrayList<Object>();
                ISelection selection = cv.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Iterator iterator = ((IStructuredSelection)selection).iterator();
                    while (iterator.hasNext()) {
                        Object item = PDGenerics.castIfInstanceOf(iterator.next(), itemClazz);
                        if (item == null) continue;
                        selectedItems.add(item);
                    }
                }
                return selectedItems;
            }
        }
    }

    public static abstract class datetime {
        public static DateTime time(Composite parent, Object layoutData) {
            return GUI.time(parent, layoutData, 128);
        }

        public static DateTime date(Composite parent, Object layoutData) {
            return GUI.time(parent, layoutData, 32);
        }

        public static DateTime calendar(Composite parent, Object layoutData) {
            return GUI.time(parent, layoutData, 1024);
        }

        public static void set(DateTime control, Calendar time) {
            if (time == null) {
                return;
            }
            control.setYear(time.get(1));
            control.setMonth(time.get(2));
            control.setDay(time.get(5));
            control.setHours(time.get(11));
            control.setMinutes(time.get(12));
            control.setSeconds(time.get(13));
        }

        public static Calendar get(DateTime control) {
            Objects.requireNonNull(control, "Must provide a non-null control");
            Calendar time = Calendar.getInstance();
            time.set(control.getYear(), control.getMonth(), control.getDay(), control.getHours(), control.getMinutes(), control.getSeconds());
            return time;
        }
    }

    public static abstract class form {
        public static FormLayout layout() {
            FormLayout formLayout = new FormLayout();
            formLayout.marginWidth = 10;
            formLayout.marginHeight = 6;
            return formLayout;
        }
    }

    public static abstract class grid {
        private static final int DEFAULT_ALIGNMENT_H = 4;
        private static final int DEFAULT_ALIGNMENT_V = 0x1000000;
        private static final boolean DEFAULT_GRAB_H_SPACE = true;
        private static final boolean DEFAULT_GRAB_V_SPACE = false;

        public static Control padding(Composite parent, int spanH) {
            return GUI.label(parent, "", d.horiz(4, false, spanH), 0);
        }

        public static abstract class d {
            public static GridData standard() {
                return new GridData(4, 0x1000000, true, false, 1, 1);
            }

            public static GridData horiz(int alignmentH, boolean grabHSpace, int spanH) {
                return new GridData(alignmentH, 0x1000000, grabHSpace, false, spanH, 1);
            }

            public static GridData vert(int alignmentV, boolean grabVSpace, int spanV) {
                return new GridData(4, alignmentV, true, grabVSpace, 1, spanV);
            }

            public static GridData left1() {
                return d.horiz(16384, false, 1);
            }

            public static GridData left1Top() {
                return new GridData(16384, 128, false, false, 1, 1);
            }

            public static GridData fillH(int spanH) {
                return d.horiz(4, true, spanH);
            }

            public static GridData fillH(int spanH, int minWidth) {
                GridData horiz = d.horiz(4, true, spanH);
                horiz.minimumWidth = minWidth;
                return horiz;
            }

            public static GridData fillAll() {
                return new GridData(4, 4, true, true);
            }
        }

        public static abstract class l {
            private static final int DEFAULT_COLUMNS = 2;
            private static final boolean DEFAULT_TO_EQUAL_WIDTH_COLUMNS = false;
            private static final int DEFAULT_HORIZONTAL_SPACING = new GridLayout().horizontalSpacing;

            public static GridLayout standard() {
                return l.customMargins(2, false, 10, 6);
            }

            public static GridLayout margins(int numColumns, boolean equalWidthColumns) {
                return l.customMargins(numColumns, equalWidthColumns, 10, 6);
            }

            public static GridLayout noMargins(int numColumns, boolean equalWidthColumns) {
                return l.customMargins(numColumns, equalWidthColumns, 0, 0);
            }

            public static GridLayout customMargins(int numColumns, boolean equalWidthColumns, int widthMargin, int heightMargin, int horizontalSpacing) {
                GridLayout gridLayout = new GridLayout(numColumns, equalWidthColumns);
                gridLayout.marginWidth = widthMargin;
                gridLayout.marginHeight = heightMargin;
                gridLayout.horizontalSpacing = horizontalSpacing;
                return gridLayout;
            }

            public static GridLayout customMargins(int numColumns, boolean equalWidthColumns, int widthMargin, int heightMargin) {
                return l.customMargins(numColumns, equalWidthColumns, widthMargin, heightMargin, DEFAULT_HORIZONTAL_SPACING);
            }

            public static GridLayout margins(int numColumns, boolean equalWidthColumns, int horizontalSpacing) {
                return l.customMargins(numColumns, equalWidthColumns, 10, 6, horizontalSpacing);
            }

            public static GridLayout noMargins(int numColumns, boolean equalWidthColumns, int horizontalSpacing) {
                return l.customMargins(numColumns, equalWidthColumns, 0, 0, horizontalSpacing);
            }
        }
    }

    public static abstract class label {
        public static Label left(Composite parent, String text2, Object layoutData) {
            return GUI.label(parent, text2, layoutData, 16384);
        }

        public static Label separatorH(Composite parent, Object layoutData) {
            return GUI.label(parent, "", layoutData, 258);
        }
    }

    public static abstract class text {
        public static Text area(Composite parent, Object layoutData) {
            return GUI.text(parent, layoutData, 770);
        }

        public static Text areaReadOnly(Composite parent, Object layoutData) {
            return GUI.text(parent, layoutData, 778);
        }

        public static Text field(Composite parent, Object layoutData) {
            return GUI.text(parent, layoutData, 4);
        }

        public static Text fieldReadOnly(Composite parent, Object layoutData) {
            Text text2 = GUI.text(parent, layoutData, 12);
            text2.setEditable(false);
            return text2;
        }
    }
}

