/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.util;

import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.DialogUtils;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.IResourceUtils;
import com.ibm.pdtools.common.component.core.util.PDFileSystemUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class DialogWithText
extends MessageDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(DialogWithText.class);
    private String longMessage = null;
    private Text textArea = null;
    private String[] additionalButtonLabels = new String[0];
    private ITextDialogRunnable[] additionalActions = new ITextDialogRunnable[0];

    protected DialogWithText(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String longMessage, String[] additionalButtonLabels, ITextDialogRunnable[] additionalActions) {
        super(parentShell, Objects.requireNonNull(dialogTitle, "Must provide non-null dialogTitle.").trim(), dialogTitleImage, Objects.requireNonNull(dialogMessage, "Must provide non-null dialogMessage.").trim(), dialogImageType, dialogButtonLabels, defaultIndex);
        DialogWithText.checkAdditionalLabelsActionsNonNull(additionalButtonLabels, additionalActions);
        logger.trace(MessageFormat.format("title: {0}\nmessage:{1}\nlongMessage:{2}", dialogTitle, this.message, longMessage));
        this.longMessage = longMessage;
        this.additionalButtonLabels = additionalButtonLabels;
        this.additionalActions = additionalActions;
    }

    protected Control createCustomArea(Composite parent) {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 480;
        gridData.minimumHeight = 100;
        this.textArea = GUI.text(parent, gridData, 2826);
        this.textArea.setFont(JFaceResources.getTextFont());
        this.textArea.setBackground(parent.getDisplay().getSystemColor(1));
        this.textArea.setText(this.longMessage);
        return parent;
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        initialSize.x = Math.min(initialSize.x, 800);
        return initialSize;
    }

    public static boolean open(int kind, Shell parent, String title, String message, String longMessage, int style, String[] additionalButtonLabels, ITextDialogRunnable[] actions) {
        Objects.requireNonNull(title, "Must specify a non-null title.");
        if (longMessage == null) {
            longMessage = "";
        }
        if (!(longMessage = longMessage.trim()).isEmpty()) {
            actions = DialogWithText.insertExtraButtons(actions);
            additionalButtonLabels = DialogWithText.insertExtraLabels(additionalButtonLabels);
        }
        DialogWithText dialog = new DialogWithText(parent, title, null, message, kind, DialogWithText.getButtonLabels(kind, additionalButtonLabels), 0, longMessage, additionalButtonLabels, actions);
        dialog.setShellStyle(dialog.getShellStyle() | style | 0x4F0);
        int open = dialog.open();
        return open == 0;
    }

    public static void openError(Shell parent, String title, String message, String longMessage) {
        DialogWithText.open(1, parent, title, message, longMessage, 0);
    }

    public static void openInformation(Shell parent, String title, String message, String longMessage) {
        DialogWithText.open(2, parent, title, message, longMessage, 0);
    }

    public static boolean openQuestion(Shell parent, String title, String message, String longMessage) {
        return DialogWithText.open(3, parent, title, message, longMessage, 0);
    }

    public static boolean openConfirmation(Shell parent, String title, String message, String longMessage) {
        return DialogWithText.open(5, parent, title, message, longMessage, 0);
    }

    public static void openWarning(Shell parent, String title, String message, String longMessage) {
        DialogWithText.open(4, parent, title, message, longMessage, 0);
    }

    private static String[] getButtonLabels(int kind, String[] additionalButtons) {
        String[] dialogButtonLabels;
        Objects.requireNonNull(additionalButtons);
        switch (kind) {
            case 1: 
            case 2: 
            case 4: {
                dialogButtonLabels = new String[1 + additionalButtons.length];
                dialogButtonLabels[0] = JFaceResources.getString((String)"ok");
                int i = 0;
                while (i < additionalButtons.length) {
                    dialogButtonLabels[i + 1] = additionalButtons[i];
                    ++i;
                }
                break;
            }
            case 5: {
                dialogButtonLabels = new String[2 + additionalButtons.length];
                dialogButtonLabels[0] = JFaceResources.getString((String)"ok");
                dialogButtonLabels[1] = JFaceResources.getString((String)"cancel");
                int i = 0;
                while (i < additionalButtons.length) {
                    dialogButtonLabels[i + 1] = additionalButtons[i];
                    ++i;
                }
                break;
            }
            case 3: {
                dialogButtonLabels = new String[2 + additionalButtons.length];
                dialogButtonLabels[0] = JFaceResources.getString((String)"yes");
                dialogButtonLabels[1] = JFaceResources.getString((String)"no");
                int i = 0;
                while (i < additionalButtons.length) {
                    dialogButtonLabels[i + 2] = additionalButtons[i];
                    ++i;
                }
                break;
            }
            case 6: {
                dialogButtonLabels = new String[3 + additionalButtons.length];
                dialogButtonLabels[0] = JFaceResources.getString((String)"yes");
                dialogButtonLabels[1] = JFaceResources.getString((String)"no");
                dialogButtonLabels[2] = JFaceResources.getString((String)"cancel");
                int i = 0;
                while (i < additionalButtons.length) {
                    dialogButtonLabels[i + 1] = additionalButtons[i];
                    ++i;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal value for kind in MessageDialog.open()");
            }
        }
        return dialogButtonLabels;
    }

    @Deprecated
    private static ITextDialogRunnable[] insertExtraButtons(ITextDialogRunnable[] buttons) {
        ITextDialogRunnable[] newActions = new ITextDialogRunnable[buttons.length + 1];
        System.arraycopy(buttons, 0, newActions, 0, buttons.length);
        newActions[newActions.length - 1] = new DisplayEditorRunnable();
        return newActions;
    }

    @Deprecated
    private static String[] insertExtraLabels(String[] labels) {
        String[] newLabels = new String[labels.length + 1];
        System.arraycopy(labels, 0, newLabels, 0, labels.length);
        newLabels[newLabels.length - 1] = Messages.PDDialogWithText_EDITOR_DISPLAY;
        return newLabels;
    }

    @Deprecated
    private static void checkAdditionalLabelsActionsNonNull(String[] additionalButtonLabels, ITextDialogRunnable[] actions) {
        Objects.requireNonNull(additionalButtonLabels, "Must specify non-null additionalLabels.");
        Objects.requireNonNull(actions, "Must specify non-null actions.");
        if (additionalButtonLabels.length != actions.length || additionalButtonLabels.length > 1000 || actions.length > 1000) {
            throw new IllegalArgumentException(additionalButtonLabels.length + " " + actions.length);
        }
        int i = 0;
        while (i < additionalButtonLabels.length) {
            if (additionalButtonLabels[i] == null) {
                throw new IllegalArgumentException(i + ": An additional button label is null.");
            }
            ++i;
        }
    }

    @Deprecated
    public static boolean open(int kind, Shell parent, String title, String message, String longMessage, int style) {
        return DialogWithText.open(kind, parent, title, message, longMessage, style, new String[0], new ITextDialogRunnable[0]);
    }

    @Deprecated
    protected void buttonPressed(int buttonId) {
        if (this.additionalButtonLabels == null || this.additionalButtonLabels.length == 0) {
            super.buttonPressed(buttonId);
            return;
        }
        int actionIndex = this.getAdditionalButtonActionIndex(buttonId);
        if (actionIndex != -1) {
            try {
                this.additionalActions[actionIndex].run(this);
            }
            catch (Exception e) {
                DialogUtils.openErrorThreadSafe(Messages.Error, MessageFormat.format(Messages.PDDialogWithText_USER_ACTION_ERR_MSG, this.additionalButtonLabels[actionIndex]));
                return;
            }
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private int getAdditionalButtonActionIndex(int buttonID) {
        String buttonText = this.getButton(buttonID).getText();
        int i = 0;
        while (i < this.additionalButtonLabels.length) {
            if (this.additionalButtonLabels[i].equals(buttonText)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Deprecated
    private static class DisplayEditorRunnable
    implements ITextDialogRunnable {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private DisplayEditorRunnable() {
        }

        @Override
        public void run(final DialogWithText context) {
            new Job(Messages.PDDialogWithText_DISPLAYING_IN_EDITOR){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        final IFile tmpFile = PDFileSystemUtil.getTempFile("PDTools", monitor, false);
                        if (IResourceUtils.createIFile(tmpFile, context.longMessage, StandardCharsets.UTF_8, true, monitor, false)) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        String editorID = "org.eclipse.ui.DefaultTextEditor";
                                        IEditorDescriptor descriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(tmpFile.getName());
                                        if (descriptor != null) {
                                            editorID = descriptor.getId();
                                        }
                                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(tmpFile), editorID);
                                    }
                                    catch (Exception e) {
                                        logger.error("An error occurred while opening an editor. See log.", e);
                                    }
                                }
                            });
                            return Status.OK_STATUS;
                        }
                        return new Status(4, "com.ibm.pdtools.common.component.core", Messages.PDDialogWithText_FAILED_DISPLAY_TEXT, (Throwable)new IOException(Messages.DialogWithText_TempFileCouldNotBeCreated));
                    }
                    catch (CoreException e) {
                        logger.error("Failed to display text from FMDialogWithText in editor", e);
                        return new Status(4, "com.ibm.pdtools.common.component.core", Messages.PDDialogWithText_FAILED_DISPLAY_TEXT, (Throwable)e);
                    }
                }
            }.schedule();
        }
    }

    @Deprecated
    public static interface ITextDialogRunnable {
        public void run(DialogWithText var1);
    }
}

