/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.util;

import com.ibm.pdtools.common.component.core.PDTCCcore;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.util.ArrayUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Stack;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ComboValueSaver
implements DisposeListener,
KeyListener,
ModifyListener,
PaintListener {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String VS_ID = ComboValueSaver.class.getCanonicalName();
    private static final PDLogger logger = PDLogger.get(ComboValueSaver.class);
    private static String SHELL_RESIZER_KEY = ComboValueSaver.class.getCanonicalName() + "_RESIZER";
    private static int MIN_DIALOG_SIZE = 450;
    public static final int VISIBLE_ITEM_COUNT = 25;
    protected IPDHost ipdHost = null;
    private final Combo combo;
    private final String id;
    private boolean doRestore = true;
    private boolean modifyIsNotSetText = false;

    public static ComboValueSaver getInstance(Combo control) {
        Objects.requireNonNull(control, "Must specify a non-null control.");
        Object data = control.getData(VS_ID);
        if (data instanceof ComboValueSaver) {
            return (ComboValueSaver)data;
        }
        return null;
    }

    public static ComboValueSaver getInstanceWithId(Combo control, String id) {
        Objects.requireNonNull(control, "Must specify a non-null control.");
        Object data = control.getData(id);
        if (data instanceof ComboValueSaver) {
            return (ComboValueSaver)data;
        }
        return null;
    }

    public static void setComboExpansion(Shell shell, String id, boolean allowExpansion) {
        Objects.requireNonNull(shell, "Must provide a non-null shell.");
        if (allowExpansion) {
            Object listener = shell.getData(SHELL_RESIZER_KEY);
            if (listener instanceof Listener) {
                shell.removeListener(11, (Listener)listener);
            }
        } else if (shell.getData(SHELL_RESIZER_KEY) == null) {
            Listener listener = ComboValueSaver.doCreateShellResizer(shell, id);
            shell.addListener(11, listener);
            shell.setData(SHELL_RESIZER_KEY, (Object)listener);
        }
    }

    private static Listener doCreateShellResizer(final Shell shell, final String id) {
        return new Listener(){

            /*
             * Unable to fully structure code
             */
            public void handleEvent(Event event) {
                shell.removeListener(11, (Listener)this);
                if (shell.getMaximized() || shell.getMinimized() || (shell.getStyle() & 16) == 0) {
                    return;
                }
                toCheck = new Stack<Object>();
                toCheck.add(shell);
                widthMax = 0;
                comboWidthMax = 0;
                while (!toCheck.isEmpty()) {
                    block8: {
                        current = (Control)toCheck.pop();
                        if (current instanceof Composite) {
                            toCheck.addAll(Arrays.asList(((Composite)current).getChildren()));
                        }
                        preferredWidth = -1;
                        try {
                            preferredWidth = current.computeSize((int)-1, (int)-1).x;
                            break block8;
                        }
                        catch (ClassCastException e) {
                            if (!PDLogger.isTraceEnabled()) break block8;
                            traceback = new ArrayList<Object>();
                            traceback.add(current);
                            ** while (((Control)traceback.get((int)(traceback.size() - 1))).getParent() != null)
                        }
lbl-1000:
                        // 1 sources

                        {
                            traceback.add(((Control)traceback.get(traceback.size() - 1)).getParent());
                            ComboValueSaver.logger.trace(((Control)traceback.get(traceback.size() - 1)).getData());
                            continue;
                        }
lbl28:
                        // 1 sources

                        ComboValueSaver.logger.trace(new Object[]{id, " Control traceback (problem in children of first): " + String.valueOf(traceback), e});
                    }
                    if (!(current instanceof Combo || current instanceof Group || current instanceof Shell || current.getClass() == Composite.class)) {
                        widthMax = Math.max(widthMax, preferredWidth);
                    }
                    if (!(current instanceof Combo)) continue;
                    comboWidthMax = Math.max(comboWidthMax, preferredWidth);
                }
                if (comboWidthMax < widthMax) {
                    return;
                }
                oldSize = shell.getSize();
                newWidth = Math.max(oldSize.x - (comboWidthMax - widthMax), ComboValueSaver.MIN_DIALOG_SIZE);
                shell.setSize(new Point(newWidth, oldSize.y));
                newSize = shell.getSize();
                location = shell.getLocation();
                shell.setLocation(location.x + (oldSize.x - newSize.x) / 2, location.y);
            }
        };
    }

    public ComboValueSaver(Combo combo2, String id) {
        this(combo2, id, false);
    }

    public ComboValueSaver(Combo combo2, String id, IPDHost host) {
        this(combo2, id, false);
        this.ipdHost = host;
    }

    public ComboValueSaver(Combo combo2, String id, boolean useCustomId) {
        this.combo = Objects.requireNonNull(combo2);
        this.id = Objects.requireNonNull(id);
        combo2.setVisibleItemCount(25);
        combo2.addDisposeListener((DisposeListener)this);
        combo2.setData(useCustomId ? id : VS_ID, (Object)this);
        if (combo2.getData(VS_ID) == null) {
            combo2.setData(VS_ID, (Object)this);
        }
        if ((combo2.getStyle() & 8) == 0) {
            this.setCustomItems(null, false, false);
            combo2.addKeyListener((KeyListener)this);
            combo2.addModifyListener((ModifyListener)this);
            ComboValueSaver.setComboExpansion(combo2.getShell(), id, false);
        } else {
            combo2.addPaintListener((PaintListener)this);
        }
    }

    public void removeValueSaverContentsFromCombo() {
        this.combo.setItems(new String[0]);
    }

    public void setAssociatedComboContents() {
        PDTCCcore instance = PDTCCcore.getDefault();
        if (instance == null) {
            throw new IllegalStateException("Could not get default instance of PDToolsCommonServerClient");
        }
        this.combo.setItems(instance.getDialogValues(this.id));
    }

    public String getId() {
        return this.id;
    }

    public void setDoRestore(boolean doRestore) {
        this.doRestore = doRestore;
    }

    public void paintControl(PaintEvent paintevent) {
        if (this.doRestore) {
            String saved = PDTCCcore.getDefault().getDialogSettings().get(this.id);
            if (saved == null) {
                this.doRestore = false;
                return;
            }
            String[] items = this.combo.getItems();
            if (items.length > 0) {
                if (saved != null) {
                    int i = 0;
                    while (i < items.length) {
                        if (items[i].equals(saved)) {
                            int indexToSelect = i;
                            paintevent.display.asyncExec(() -> this.combo.select(indexToSelect));
                            break;
                        }
                        ++i;
                    }
                    this.onRestore();
                }
                this.doRestore = false;
            }
        }
    }

    public void onRestore() {
    }

    public void setCustomItems(String[] customitems, boolean resort, boolean keepDup) {
        PDTCCcore instance = PDTCCcore.getDefault();
        if (instance == null) {
            throw new IllegalStateException("Could not get default instance of PDToolsCommonServerClient");
        }
        Object[] items = instance.getDialogValues(this.id);
        if (customitems != null) {
            ArrayList<String> dialogItems = new ArrayList<String>(Arrays.asList(items));
            if (!keepDup) {
                dialogItems.removeAll(Arrays.asList(customitems));
            }
            items = ArrayUtils.getToStringArray((Object[])ArrayUtils.concat((Object[])customitems, (Object[])dialogItems.toArray()));
            if (resort) {
                Arrays.sort(items);
            }
        }
        this.modifyIsNotSetText = true;
        this.combo.setItems((String[])items);
        this.modifyIsNotSetText = false;
    }

    public void setCustomItems(String[] customitems, boolean top) {
        String[] items = PDTCCcore.getDefault().getDialogValues(this.id);
        if (customitems != null) {
            ArrayList<String> customItemsList = new ArrayList<String>(Arrays.asList(customitems));
            customItemsList.removeAll(Arrays.asList(items));
            ArrayList<String> dialogItems = new ArrayList<String>(Arrays.asList(items));
            items = top ? ArrayUtils.getToStringArray((Object[])ArrayUtils.concat((Object[])customItemsList.toArray(), (Object[])dialogItems.toArray())) : ArrayUtils.getToStringArray((Object[])ArrayUtils.concat((Object[])dialogItems.toArray(), (Object[])customItemsList.toArray()));
        }
        this.modifyIsNotSetText = true;
        this.combo.setItems(items);
        this.modifyIsNotSetText = false;
    }

    public void forceSaveCurrentValue() {
        PDTCCcore.getDefault().renewDialogValue(this.id, this.combo.getText(), true);
    }

    public void keyReleased(KeyEvent keyevent) {
        this.modifyIsNotSetText = false;
    }

    public void keyPressed(KeyEvent keyevent) {
        this.modifyIsNotSetText = true;
        int selectionIndex = this.combo.getSelectionIndex();
        if (this.combo.getListVisible() && keyevent.keyCode == 127 && selectionIndex >= 0) {
            String item = this.combo.getItem(selectionIndex);
            this.combo.remove(selectionIndex);
            PDTCCcore.getDefault().removeDialogValue(this.id, item);
            keyevent.doit = false;
        }
    }

    protected boolean shouldSave(String value) {
        return value != null && value.length() > 0;
    }

    public void widgetDisposed(DisposeEvent disposeevent) {
        String value = this.combo.getText();
        if (this.shouldSave(value)) {
            if ((this.combo.getStyle() & 8) == 0) {
                PDTCCcore.getDefault().renewDialogValue(this.id, value, false);
            } else {
                PDTCCcore.getDefault().getDialogSettings().put(this.id, value);
            }
        }
    }

    public void modifyText(ModifyEvent modifyevent) {
        if (this.modifyIsNotSetText) {
            return;
        }
        this.modifyIsNotSetText = true;
        String text2 = this.combo.getText();
        Object[] items = this.combo.getItems();
        if (!Arrays.asList(items).contains(text2) && text2.length() > 0) {
            Object[] concatted = ArrayUtils.concat((Object[])new String[]{text2}, (Object[])items);
            this.combo.setItems(ArrayUtils.getToStringArray((Object[])concatted));
            this.combo.select(0);
        }
        this.modifyIsNotSetText = false;
    }

    public static ComboValueSaver assignTo(Combo combo2, String id) {
        Objects.requireNonNull(combo2, "Must specify a non-null combo");
        Objects.requireNonNull(id, "Must specify a non-null id.");
        return new ComboValueSaver(combo2, id);
    }
}

