/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.model;

import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.PDHost;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;

public class PDLocalHost
extends PDHost {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final PDLogger logger = PDLogger.get(PDLocalHost.class);
    private static final Object RESULT_READY = new Object();
    private static PDLocalHost localHost = null;

    public PDLocalHost() {
        super(Messages.HostType_LocalHost, Messages.HostType_LocalHost, 0);
        this.setHostType(HostType.LOCAL_HOST);
    }

    public boolean isLocalHost() {
        return true;
    }

    public void resultReady() {
        this.getEventDispatcher().fireInfoReadyEvent(RESULT_READY);
    }

    @Deprecated
    public Result<StringBuffer> executeOnNonLocalHost(String componentName, String command, IProgressMonitor monitor) throws InterruptedException {
        return super.executeOnHost(componentName, command, monitor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Deprecated
    public Result<StringBuffer> executeOnHost(String componentName, String command, IProgressMonitor monitor) throws InterruptedException {
        Result result = new Result();
        try {
            Process aProcess = Runtime.getRuntime().exec(command);
            aProcess.waitFor();
            boolean isError = false;
            Throwable throwable = null;
            Object var9_9 = null;
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(aProcess.getInputStream(), StandardCharsets.UTF_8));
                try {
                    try (BufferedReader bufferedReaderErr = new BufferedReader(new InputStreamReader(aProcess.getInputStream(), StandardCharsets.UTF_8));){
                        String aResultLine = bufferedReader.readLine();
                        if (aResultLine == null) {
                            isError = true;
                            aResultLine = bufferedReaderErr.readLine();
                        }
                        result.setOutput((Object)new StringBuffer());
                        while (aResultLine != null) {
                            result.setOutput((Object)((StringBuffer)result.getOutput()).append(aResultLine).append('\n'));
                            String string = aResultLine = isError ? bufferedReaderErr.readLine() : bufferedReader.readLine();
                        }
                        result.setRC(0);
                    }
                    if (bufferedReader == null) return result;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (bufferedReader == null) throw throwable;
                    bufferedReader.close();
                    throw throwable;
                }
                bufferedReader.close();
                return result;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            result.setOutput((Object)new StringBuffer(e.toString()));
            result.setRC(8);
        }
        return result;
    }

    @Deprecated
    public String getLocalHostRoot() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
    }

    @Override
    public String getPDLabel() {
        return this.getHostName();
    }

    @Override
    public String getPDImageName() {
        return "IMG_OBJ_FOLDER";
    }

    @Override
    public String getPDPluginId() {
        return "com.ibm.pdtools.common.component.ui";
    }

    public static PDLocalHost getInstance() {
        if (localHost == null) {
            localHost = new PDLocalHost();
        }
        return localHost;
    }
}

