/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.model;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class BasicModelObject
implements Cloneable,
IHostProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(BasicModelObject.class);
    private List<IModelChangeListener> listeners = new ArrayList<IModelChangeListener>();
    private BasicModelObject eventDelegate;
    protected IPDHost provider;

    public BasicModelObject(IPDHost host) {
        this.provider = host;
    }

    public void setEventDelegate(BasicModelObject eventDelegate) {
        Objects.requireNonNull(eventDelegate, "Must provide a non-null eventDelegate");
        if (this.eventDelegate != null) {
            throw new IllegalArgumentException(eventDelegate.toString());
        }
        this.eventDelegate = eventDelegate;
    }

    public void setHostProvider(IPDHost newProvider) {
        this.provider = newProvider;
    }

    public IPDHost getSystem() {
        return this.provider;
    }

    public IPDHost getHostProvider() {
        return this.provider;
    }

    public void addListener(IModelChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public boolean removeListener(IModelChangeListener listener) {
        return this.listeners.remove(listener);
    }

    public void fireModelChangeEvent() {
        if (this.eventDelegate != null) {
            this.eventDelegate.fireModelChangeEvent();
        }
        for (IModelChangeListener listener : this.listeners) {
            listener.onModelUpdated();
        }
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return 1;
    }

    protected <T> T getCloneOf(T o) {
        if (o == null) {
            return null;
        }
        try {
            Method method = o.getClass().getMethod("clone", new Class[0]);
            Object result = method.invoke(o, new Object[0]);
            return (T)result;
        }
        catch (Exception e) {
            logger.debug("Unable to clone object: " + String.valueOf(o), e);
            return null;
        }
    }

    public static interface IModelChangeListener {
        public void onModelUpdated();
    }
}

