/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.logging;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import com.ibm.pdtools.common.component.jhost.logging.ThrowableRenderer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;

public class PlatformLogListener
implements ILogListener {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final PDLogger platformLogger;

    public PlatformLogListener(PDLogger platformLogger) {
        this.platformLogger = Objects.requireNonNull(platformLogger, "Must provide a non-null platformLogger");
    }

    public void logging(IStatus status, String plugin) {
        if (status != null && !"com.ibm.pdtools.common.component.core.logger".equals(status.getPlugin())) {
            PDLoggerJhost.Level level = PDLoggerJhost.Level.DEBUG;
            switch (status.getSeverity()) {
                case 8: {
                    level = PDLoggerJhost.Level.ERROR;
                    break;
                }
                case 4: {
                    level = PDLoggerJhost.Level.ERROR;
                    break;
                }
                case 2: {
                    level = PDLoggerJhost.Level.WARN;
                    break;
                }
                case 1: {
                    level = PDLoggerJhost.Level.INFO;
                    break;
                }
            }
            StringBuilder msg = new StringBuilder();
            msg.append(this.platformLogger.getName());
            msg.append(": ");
            this.loadStatusText(msg, status, plugin, 0);
            if (ThrowableRenderer.getInterestingClasses() != null && ThrowableRenderer.getInterestingClasses().matcher(msg.toString()).matches()) {
                this.platformLogger.log(level, false, new Object[]{msg});
            }
        }
    }

    private void loadStatusText(StringBuilder msg, IStatus status, String plugin, int recursionLevel) {
        StringBuilder tabsSb = new StringBuilder();
        int i = 0;
        while (i < recursionLevel) {
            tabsSb.append("\t");
            ++i;
        }
        msg.append(tabsSb.toString());
        if (recursionLevel > 0) {
            switch (status.getSeverity()) {
                case 0: {
                    msg.append("OK ");
                    break;
                }
                case 1: {
                    msg.append("INFO ");
                    break;
                }
                case 2: {
                    msg.append("WARNING ");
                    break;
                }
                case 4: {
                    msg.append("ERROR ");
                    break;
                }
                case 8: {
                    msg.append("CANCEL ");
                    break;
                }
                default: {
                    msg.append("UNKNOWN ");
                }
            }
        }
        if (status.isMultiStatus()) {
            msg.append("multi-status ");
        } else {
            msg.append("status ");
        }
        if (status.getPlugin().equals(plugin)) {
            msg.append("raised & logged in ");
            msg.append(plugin);
            msg.append(": ");
            msg.append(status.getMessage());
        } else {
            msg.append("raised in ");
            msg.append(status.getPlugin());
            if (status.getMessage() != null && status.getMessage().length() > 0) {
                msg.append(": ");
                msg.append(status.getMessage());
            }
        }
        if (status.getException() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter p = new PrintWriter(sw);
            p.println();
            ThrowableRenderer.doRender((PrintWriter)p, (Throwable)status.getException());
            p.flush();
            msg.append(sw.getBuffer().toString().replaceAll("\\n", "\n" + tabsSb.toString()));
        }
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus childStatus = iStatusArray[n2];
                msg.append("\n");
                this.loadStatusText(msg, childStatus, plugin, recursionLevel + 1);
                ++n2;
            }
        }
    }
}

