/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.logging;

import com.ibm.pdtools.common.component.core.PDTCCcore;
import com.ibm.pdtools.common.component.core.logging.PlatformLogListener;
import com.ibm.pdtools.common.component.core.util.CollectionUtils;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class PDLogger
extends PDLoggerJhost {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String LOG_FILE_LINK = "pdtools.log.txt";
    private static Object configurationLock = new Object();
    private static boolean logListenerAdded = false;

    public static PDLogger get(Class<?> clazz) {
        return new PDLogger(Objects.requireNonNull(clazz, "Must specify a non-null class.").getName());
    }

    public static PDLogger get(Object o) {
        return new PDLogger(Objects.requireNonNull(o, "Must specify a non-null object.").getClass().getName());
    }

    protected static PDLogger get(String name) {
        return new PDLogger(name);
    }

    public PDLogger(String name) {
        super(name);
    }

    @Deprecated
    protected String getLogDir() {
        if (Platform.isRunning()) {
            return ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().getAbsolutePath() + File.separator + ".metadata";
        }
        return super.getLogDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logToEclipse(PDLoggerJhost.Level level, String msg, Throwable t) {
        if (t == null && PDLogger.isTraceEnabled()) {
            t = new Throwable();
            t.setStackTrace(PDLogger.filter((StackTraceElement[])PDLogger.filteredTraceArray((StackTraceElement[])t.getStackTrace()), (String[])new String[]{PDLogger.class.getSimpleName(), PDLoggerJhost.class.getSimpleName()}));
        }
        if (Platform.isRunning()) {
            PDTCCcore instance = PDTCCcore.getDefault();
            if (instance == null) {
                System.err.println("Could not get " + PDTCCcore.class.getSimpleName() + " instance! logging will not be possible.");
                new Throwable().printStackTrace();
                return;
            }
            ILog log = instance.getLog();
            if (level == PDLoggerJhost.Level.FATAL) {
                log.log((IStatus)new Status(4, "com.ibm.pdtools.common.component.core.logger", "FATAL: " + msg, t));
            } else if (level == PDLoggerJhost.Level.ERROR) {
                log.log((IStatus)new Status(4, "com.ibm.pdtools.common.component.core.logger", msg, t));
            } else if (level == PDLoggerJhost.Level.WARN) {
                log.log((IStatus)new Status(2, "com.ibm.pdtools.common.component.core.logger", msg, t));
            } else if (level == PDLoggerJhost.Level.INFO) {
                log.log((IStatus)new Status(1, "com.ibm.pdtools.common.component.core.logger", msg, t));
            } else if (level == PDLoggerJhost.Level.DEBUG) {
                if (PDTCCcore.getDefault().getPreferenceStore().getBoolean("ipv.debug")) {
                    log.log((IStatus)new Status(0, "com.ibm.pdtools.common.component.core.logger", msg, t));
                }
            } else if (level == PDLoggerJhost.Level.TRACE && PDTCCcore.getDefault().getPreferenceStore().getBoolean("ipv.debug")) {
                log.log((IStatus)new Status(0, "com.ibm.pdtools.common.component.core.logger", msg, t));
            }
        } else {
            System.err.println("Eclipse platform is not running, so log entries will not appear in the platform log.");
            System.err.println(MessageFormat.format("level={0} msg={1} throwable={2}", level == null ? "level=null" : level, msg == null ? "msg=null" : msg, t == null ? "throwable=null" : t));
        }
        Object object = configurationLock;
        synchronized (object) {
            if (Platform.isRunning() && this.getName() != "PLATFORM_LOGGER" && !logListenerAdded) {
                PDLogger platformLogger = PDLogger.get("PLATFORM_LOGGER");
                Platform.addLogListener((ILogListener)new PlatformLogListener(platformLogger));
                logListenerAdded = true;
                this.log(PDLoggerJhost.Level.TRACE, false, new Object[]{"Application Delivery Foundation for z/OS log file " + String.valueOf(this.getLogFile()), " . (created by ", PDLogger.filteredTrace((StackTraceElement[])Thread.currentThread().getStackTrace())});
            }
        }
    }

    public void log(IStatus status) {
        if (status == null) {
            PDLogger.get(((Object)((Object)this)).getClass()).printCurrentStackTrace(PDLoggerJhost.Level.WARN, "Given a 'null' status to log; Hint: review the caller of this method to determine why a 'null' status was passed.");
        } else {
            ArrayList<Object> itemsOfInterest = new ArrayList<Object>();
            if (status.getPlugin() != null) {
                itemsOfInterest.add(status.getPlugin());
            }
            if (status.getMessage() != null) {
                itemsOfInterest.add(status.getMessage());
            }
            itemsOfInterest.add("code=" + status.getCode());
            if (status.getException() != null) {
                itemsOfInterest.add(status.getException());
            }
            this.log(this.mapSeverityToLogLevel(status.getSeverity()), true, new Object[]{itemsOfInterest});
            if (status.isMultiStatus()) {
                IStatus[] iStatusArray = status.getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus child = iStatusArray[n2];
                    if (!Thread.currentThread().isInterrupted() && !status.equals(child)) {
                        this.log(child);
                    }
                    ++n2;
                }
            }
        }
    }

    private PDLoggerJhost.Level mapSeverityToLogLevel(int severity) {
        switch (severity) {
            case 2: {
                return PDLoggerJhost.Level.WARN;
            }
            case 1: {
                return PDLoggerJhost.Level.INFO;
            }
            case 4: {
                return PDLoggerJhost.Level.ERROR;
            }
            case 0: 
            case 8: {
                return PDLoggerJhost.Level.TRACE;
            }
        }
        PDLogger.get(((Object)((Object)this)).getClass()).warn(MessageFormat.format("Unhandled IStatus severity detected! severity={0} : Please check org.eclipse.core.runtime.IStatus for ''new'' severities.", severity));
        return PDLoggerJhost.Level.INFO;
    }

    public void logBundleInfo(Bundle b) {
        StringBuilder sb = new StringBuilder("--------- Bundle Info: ----------\n");
        sb.append("name=").append(b.getSymbolicName()).append("\n state=").append(b.getState()).append("\n version=").append(b.getVersion()).append("\n location=").append(b.getLocation()).append("\n lastModified=").append(b.getLastModified()).append("\n headers=").append(CollectionUtils.valueOf(b.getHeaders()).entrySet()).append("--------- Bundle Info: ----------\n");
        this.trace(sb);
    }

    public void logEnvironmentVariables() {
        this.logMap(PDLoggerJhost.Level.TRACE, true, "-------- Java Environment variables: -------\n", System.getenv().entrySet());
    }

    public void logProperties() {
        this.logMap(PDLoggerJhost.Level.TRACE, true, "-------- Java Properties: -------\n", System.getProperties().entrySet());
    }

    private <T> void logMap(PDLoggerJhost.Level level, boolean toEclipseLog, String headerFooter, Set<Map.Entry<T, T>> entries) {
        StringBuilder sb = CollectionUtils.mapToString(headerFooter, entries);
        this.log(level, toEclipseLog, new Object[]{sb});
    }

    public static PDLogger getBundleInfoLog(String name) {
        return new PDLogger("bundleinfo." + name);
    }

    public static PDLogger getJavaEnvVarsLog(String name) {
        return new PDLogger("envvars." + name);
    }
}

