/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.api;

import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.api.PDAPI;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.DialogUtils;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Platform;

public class PDAPIFactory {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "(C) Copyright IBM Corp. 2014. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(PDAPIFactory.class);
    private static final String lookupPlugin = "com.ibm.pdtools.common.component.lookup";
    private static final String lookupAPIName = "LookupAPI";
    private static PDAPI lookupAPI = null;

    public static PDAPI getLookupAPI() {
        if (lookupAPI == null) {
            lookupAPI = PDAPIFactory.getAPI(lookupPlugin, lookupAPIName);
        }
        return lookupAPI;
    }

    public static PDAPI getAPI(String pluginName, String className) {
        Class implementationClass = null;
        try {
            implementationClass = Platform.getBundle((String)pluginName).loadClass(pluginName + ".api." + className);
        }
        catch (NullPointerException e) {
            String message = MessageFormat.format(Messages.PDAPIFactory_ImplementationUnavailable, pluginName, Messages.PDAPIFactory_PluginNotFound);
            logger.warn(message);
            DialogUtils.openErrorThreadSafe(MessageFormat.format(Messages.PDAPIFactory_ImplementationUnavailableTitle, className), message);
            return null;
        }
        catch (Exception e) {
            String message = MessageFormat.format(Messages.PDAPIFactory_ImplementationUnavailable, pluginName, e.getMessage());
            logger.warn(message);
            DialogUtils.openErrorThreadSafe(MessageFormat.format(Messages.PDAPIFactory_ImplementationUnavailableTitle, className), message);
            return null;
        }
        try {
            return (PDAPI)implementationClass.newInstance();
        }
        catch (Exception e) {
            logger.error(e);
            DialogUtils.openErrorThreadSafe(MessageFormat.format(Messages.PDAPIFactory_ImplementationUnavailableTitle, className), e.getMessage());
            return null;
        }
    }
}

