/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.jhost.editor.formatted;

import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;

public class FMEditSessionPropertiesJhost {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLoggerJhost logger = PDLoggerJhost.get(FMEditSessionPropertiesJhost.class);
    private boolean isKSDS;
    private int keyLen;
    private int keyOffset;
    private boolean allRecdsLoaded;
    private int maxRECL = 80;
    private int minRECL = 80;
    private int numRecords;
    private boolean noAppend;
    private boolean fixedLen;
    private boolean noMove;
    private boolean noRecLenChange;
    private boolean noUpdate;
    private boolean noInsertDelete;
    private boolean isQSAM;
    private boolean isRRDS;
    private boolean isStream;
    private boolean isPseudoDelEnabled = false;
    private boolean isRefreshAvailable;
    private int currentStartPosition = 1;

    public FMEditSessionPropertiesJhost clone() {
        FMEditSessionPropertiesJhost properties = new FMEditSessionPropertiesJhost();
        this.setProperties(properties);
        return properties;
    }

    public FMEditSessionPropertiesJhost setProperties(FMEditSessionPropertiesJhost properties) {
        properties.isKSDS = this.isKSDS;
        properties.keyLen = this.keyLen;
        properties.keyOffset = this.keyOffset;
        properties.allRecdsLoaded = this.allRecdsLoaded;
        properties.maxRECL = this.maxRECL;
        properties.minRECL = this.minRECL;
        properties.numRecords = this.numRecords;
        properties.noAppend = this.noAppend;
        properties.fixedLen = this.fixedLen;
        properties.noMove = this.noMove;
        properties.noRecLenChange = this.noRecLenChange;
        properties.noUpdate = this.noUpdate;
        properties.noInsertDelete = this.noInsertDelete;
        properties.isQSAM = this.isQSAM;
        properties.isRRDS = this.isRRDS;
        properties.isStream = this.isStream;
        properties.isPseudoDelEnabled = this.isPseudoDelEnabled;
        properties.isRefreshAvailable = this.isRefreshAvailable;
        properties.currentStartPosition = this.currentStartPosition;
        return properties;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allRecdsLoaded ? 1231 : 1237);
        result = 31 * result + this.currentStartPosition;
        result = 31 * result + (this.fixedLen ? 1231 : 1237);
        result = 31 * result + (this.isKSDS ? 1231 : 1237);
        result = 31 * result + (this.isPseudoDelEnabled ? 1231 : 1237);
        result = 31 * result + (this.isQSAM ? 1231 : 1237);
        result = 31 * result + (this.isRRDS ? 1231 : 1237);
        result = 31 * result + (this.isStream ? 1231 : 1237);
        result = 31 * result + (this.isRefreshAvailable ? 1231 : 1237);
        result = 31 * result + this.keyLen;
        result = 31 * result + this.keyOffset;
        result = 31 * result + this.maxRECL;
        result = 31 * result + this.minRECL;
        result = 31 * result + (this.noAppend ? 1231 : 1237);
        result = 31 * result + (this.noInsertDelete ? 1231 : 1237);
        result = 31 * result + (this.noMove ? 1231 : 1237);
        result = 31 * result + (this.noRecLenChange ? 1231 : 1237);
        result = 31 * result + (this.noUpdate ? 1231 : 1237);
        result = 31 * result + this.numRecords;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FMEditSessionPropertiesJhost)) {
            return false;
        }
        FMEditSessionPropertiesJhost other = (FMEditSessionPropertiesJhost)obj;
        if (this.allRecdsLoaded != other.allRecdsLoaded) {
            return false;
        }
        if (this.currentStartPosition != other.currentStartPosition) {
            return false;
        }
        if (this.fixedLen != other.fixedLen) {
            return false;
        }
        if (this.isKSDS != other.isKSDS) {
            return false;
        }
        if (this.isPseudoDelEnabled != other.isPseudoDelEnabled) {
            return false;
        }
        if (this.isQSAM != other.isQSAM) {
            return false;
        }
        if (this.isRRDS != other.isRRDS) {
            return false;
        }
        if (this.isStream != other.isStream) {
            return false;
        }
        if (this.isRefreshAvailable != other.isRefreshAvailable) {
            return false;
        }
        if (this.keyLen != other.keyLen) {
            return false;
        }
        if (this.keyOffset != other.keyOffset) {
            return false;
        }
        if (this.maxRECL != other.maxRECL) {
            return false;
        }
        if (this.minRECL != other.minRECL) {
            return false;
        }
        if (this.noAppend != other.noAppend) {
            return false;
        }
        if (this.noInsertDelete != other.noInsertDelete) {
            return false;
        }
        if (this.noMove != other.noMove) {
            return false;
        }
        if (this.noRecLenChange != other.noRecLenChange) {
            return false;
        }
        if (this.noUpdate != other.noUpdate) {
            return false;
        }
        return this.numRecords == other.numRecords;
    }

    public boolean isFixedLen() {
        return this.fixedLen;
    }

    public void setFixedLen(boolean fixedLen) {
        this.fixedLen = fixedLen;
    }

    public void setAllRecdsLoaded(boolean allRecdsLoaded) {
        this.allRecdsLoaded = allRecdsLoaded;
    }

    public boolean isAllRecdsLoaded() {
        return this.allRecdsLoaded;
    }

    public boolean noInsertDelete() {
        return this.noInsertDelete;
    }

    public void setNoInsertDelete(boolean insertDelete) {
        this.noInsertDelete = insertDelete;
    }

    public boolean isKSDS() {
        return this.isKSDS;
    }

    public void setKSDS(boolean isKSDS) {
        this.isKSDS = isKSDS;
    }

    public boolean isQSAM() {
        return this.isQSAM;
    }

    public boolean isStream() {
        return this.isStream;
    }

    public void setStream(boolean isStream) {
        this.isStream = isStream;
    }

    public void setQSAM(boolean isQSAM) {
        this.isQSAM = isQSAM;
    }

    public boolean isRRDS() {
        return this.isRRDS;
    }

    public void setRRDS(boolean isRRDS) {
        this.isRRDS = isRRDS;
    }

    public int getKeyLen() {
        return this.keyLen;
    }

    public int getKeyOffset() {
        return this.keyOffset;
    }

    public int getMaxRECL() {
        if (this.maxRECL == 0) {
            return Integer.MAX_VALUE;
        }
        return this.maxRECL;
    }

    public void setMaxRECL(int maxRECL) {
        this.maxRECL = maxRECL;
    }

    public int getMinRECL() {
        return this.minRECL;
    }

    public void setMinRECL(int minRECL) {
        this.minRECL = minRECL;
    }

    public boolean isNoAppend() {
        return this.noAppend;
    }

    public void setNoAppend(boolean noAppend) {
        this.noAppend = noAppend;
    }

    public boolean noMove() {
        return this.noMove;
    }

    public void setNoMove(boolean noMove) {
        this.noMove = noMove;
    }

    public boolean noRecLenChange() {
        return this.noRecLenChange;
    }

    public void setNoRecLenChange(boolean noRecLenChange) {
        this.noRecLenChange = noRecLenChange;
    }

    public boolean noUpdate() {
        return this.noUpdate;
    }

    public void setNoUpdate(boolean noUpdate) {
        this.noUpdate = noUpdate;
    }

    public int getNumRecords() {
        return this.numRecords;
    }

    public void setNumRecords(int numRecords) {
        this.numRecords = numRecords;
    }

    public boolean isRefreshCommandAvailable() {
        return this.isRefreshAvailable;
    }

    public void setRefreshCommandAvailable(boolean available) {
        this.isRefreshAvailable = available;
    }

    public void updateTotalNumRecords(int changedCount, boolean add) {
        if (this.numRecords == -2) {
            return;
        }
        this.numRecords = add ? (this.numRecords += changedCount) : (this.numRecords -= changedCount);
    }

    public void setToZero() {
        this.numRecords = 0;
    }

    public void setKeyLen(int keyLen) {
        this.keyLen = keyLen;
    }

    public void setKeyOffset(int keyOffset) {
        this.keyOffset = keyOffset;
    }

    public int getCurrentStartPosition() {
        return this.currentStartPosition;
    }

    public void setCurrentStartPosition(int pos) {
        this.currentStartPosition = pos;
    }

    public boolean isInplaceEdit() {
        return this.isNoAppend() || this.noInsertDelete();
    }

    public void setPseudoDelEnabled(boolean enabled) {
        this.isPseudoDelEnabled = enabled;
    }

    public boolean isPseudoDelEnabled() {
        return this.isPseudoDelEnabled;
    }

    public void dumpEditSessionProperties(IZRL aResource, IZRL aTemplate) {
        StringBuilder sb = new StringBuilder();
        sb.append("########## Beginning of Edit Session Properties ##########\n");
        sb.append("z/OS resource: " + aResource.getFormattedName() + "\n");
        sb.append("Template: " + (aTemplate == null ? "no template" : aTemplate.getFormattedName()) + "\n");
        sb.append("isKSDS? " + this.isKSDS + "\n");
        sb.append("keyLen: " + this.keyLen + "\n");
        sb.append("keyOffset: " + this.keyOffset + "\n");
        sb.append("allRecordsLoaded? " + this.allRecdsLoaded + "\n");
        sb.append("maxRECL: " + this.maxRECL + "\n");
        sb.append("minRECL: " + this.minRECL + "\n");
        sb.append("totalRecords: " + this.numRecords + "\n");
        sb.append("noAppend? " + this.noAppend + "\n");
        sb.append("fixedLen? " + this.fixedLen + "\n");
        sb.append("noMove? " + this.noMove + "\n");
        sb.append("noRecLenChange? " + this.noRecLenChange + "\n");
        sb.append("noUpdate? " + this.noUpdate + "\n");
        sb.append("noInsertDelete? " + this.noInsertDelete + "\n");
        sb.append("isQSAM? " + this.isQSAM + "\n");
        sb.append("isRRDS? " + this.isRRDS + "\n");
        sb.append("isStream? " + this.isStream + "\n");
        sb.append("isInplaceEdit? " + this.isInplaceEdit() + "\n");
        sb.append("isPseudoDelEnabled? " + this.isPseudoDelEnabled + "\n");
        sb.append("startPosition: " + this.currentStartPosition + "\n");
        sb.append("########## End of Edit Session Properties ##########\n");
        logger.debug((Object)sb.toString());
    }
}

