/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.jhost.core.version;

import com.ibm.etools.fm.jhost.core.version.FMHostVersion;
import com.ibm.etools.fm.jhost.core.version.LevelledFeature;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.text.MessageFormat;
import java.util.Objects;

public class ServerTooOldException
extends RuntimeException {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final long serialVersionUID = 1L;
    private final IPDHost host;
    private final LevelledFeature feature;

    public ServerTooOldException(IPDHost host, LevelledFeature feature) {
        Objects.requireNonNull(host, "Please provide a non-null host.");
        Objects.requireNonNull(feature, "Please provide a non-null feature.");
        this.host = host;
        this.feature = feature;
    }

    @Override
    public String getMessage() {
        String idealAparLevel;
        String minAparLevel = this.feature == null ? "Feature not specified" : this.feature.getMinLevel(this.host.getHostType()).getAparLevel(this.host.getHostType());
        if (minAparLevel.equals(idealAparLevel = FMHostVersion.getLatestVersion(this.host.getHostType()).getAparLevel(this.host.getHostType()))) {
            return MessageFormat.format("File Manager Server extension is too old; please ask your System Administrator to apply the PTF for APAR {0}", minAparLevel);
        }
        return MessageFormat.format("File Manager Server extension is too old; please ask your System Administrator to apply the PTF for at least APAR {0}, or ideally APAR {1}", minAparLevel, idealAparLevel);
    }
}

