/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.jhost.core.version;

import com.ibm.etools.fm.jhost.core.version.FMFeature;
import com.ibm.etools.fm.jhost.core.version.FMHostVersion;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class LevelledFeature
implements FMFeature {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final Map<HostType, FMHostVersion> minLevels;
    private String aparNo = new String();

    public LevelledFeature() {
        this.minLevels = Collections.emptyMap();
    }

    private LevelledFeature(LevelledFeature existingFeature, HostType hostType, FMHostVersion minLevel) {
        Objects.requireNonNull(minLevel, "Please specify a non-null FMHostVersion minLevel");
        if (existingFeature.minLevels.containsKey(hostType)) {
            throw new IllegalArgumentException(minLevel.toString());
        }
        HashMap<HostType, FMHostVersion> minLevels = new HashMap<HostType, FMHostVersion>(existingFeature.minLevels);
        minLevels.put(hostType, minLevel);
        this.minLevels = Collections.unmodifiableMap(minLevels);
    }

    private LevelledFeature(LevelledFeature existingFeature, HostType hostType, FMHostVersion minLevel, String aparNo) {
        this(existingFeature, hostType, minLevel);
        this.aparNo = aparNo;
    }

    public LevelledFeature allow(HostType hostType, FMHostVersion minLevel) {
        return new LevelledFeature(this, hostType, minLevel);
    }

    public LevelledFeature allow(HostType hostType, FMHostVersion minLevel, String aparNo) {
        return new LevelledFeature(this, hostType, minLevel, aparNo);
    }

    public LevelledFeature allow(FMHostVersion minLevel) {
        LevelledFeature feature = this;
        HostType[] hostTypeArray = HostType.values();
        int n = hostTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            HostType hostType = hostTypeArray[n2];
            feature = feature.allow(hostType, minLevel);
            ++n2;
        }
        return feature;
    }

    @Override
    public boolean isSupportedBy(HostType hostType, FMHostVersion version) {
        if (version == null) {
            return false;
        }
        if (hostType == null) {
            return false;
        }
        FMHostVersion minVersion = this.minLevels.get(hostType);
        if (minVersion == null) {
            return false;
        }
        return version.isFunctionalSuperSetOf(minVersion);
    }

    public FMHostVersion getMinLevel(HostType hostType) {
        return this.minLevels.get(hostType);
    }

    public String toString() {
        return this.minLevels.toString();
    }

    public String getAparNo() {
        return this.aparNo;
    }
}

