/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.jhost.core.version;

import com.ibm.pdtools.common.component.jhost.comms.HostType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum FMHostVersion {
    V2_0(2, 0){

        @Override
        public String getAparLevel(HostType hostType) {
            return "none";
        }
    }
    ,
    V2_1(2, 1){

        @Override
        public String getAparLevel(HostType hostType) {
            if (hostType == HostType.ZOS) {
                return "unknown";
            }
            return "none";
        }
    }
    ,
    V2_2(2, 2){

        @Override
        public String getAparLevel(HostType hostType) {
            if (hostType == HostType.ZOS) {
                return "PM69989";
            }
            return "none";
        }
    }
    ,
    V2_3(2, 3){

        @Override
        public String getAparLevel(HostType hostType) {
            if (hostType == HostType.ZOS) {
                return "PM77389";
            }
            return "none";
        }
    }
    ,
    V2_4(2, 4){

        @Override
        public String getAparLevel(HostType hostType) {
            if (hostType == HostType.ZOS) {
                return "PM80526";
            }
            return "none";
        }
    }
    ,
    V2_5(2, 5){

        @Override
        public String getAparLevel(HostType hostType) {
            return "PM86601";
        }
    }
    ,
    V2_6(2, 6){

        @Override
        public String getAparLevel(HostType hostType) {
            return "FMV13 GA";
        }
    }
    ,
    V2_7(2, 7){

        @Override
        public String getAparLevel(HostType hostType) {
            return "FMV14 GA";
        }
    }
    ,
    NEWEST(2, 99){

        @Override
        public String getAparLevel(HostType hostType) {
            return "unknown";
        }
    };

    private final int majorProtocolVersion;
    private final int minorProtocolVersion;
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public static FMHostVersion getLatestVersion(HostType hostType) {
        return V2_7;
    }

    public static FMHostVersion parseFromProtocolLevels(int major, int minor) {
        FMHostVersion[] values;
        FMHostVersion[] fMHostVersionArray = values = FMHostVersion.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            FMHostVersion fmHostVersion = fMHostVersionArray[n2];
            if (fmHostVersion.getMajor() == major && fmHostVersion.getMinor() == minor) {
                return fmHostVersion;
            }
            ++n2;
        }
        if (NEWEST.getMajor() == major) {
            return NEWEST;
        }
        return null;
    }

    private FMHostVersion(int majorProtocolVersion, int minorProtocolVersion) {
        if (majorProtocolVersion < 0 || majorProtocolVersion > 99) {
            throw new IllegalArgumentException(Integer.toString(majorProtocolVersion));
        }
        if (minorProtocolVersion < 0 || minorProtocolVersion > 99) {
            throw new IllegalArgumentException(Integer.toString(minorProtocolVersion));
        }
        this.majorProtocolVersion = majorProtocolVersion;
        this.minorProtocolVersion = minorProtocolVersion;
    }

    private FMHostVersion() {
        this.majorProtocolVersion = -1;
        this.minorProtocolVersion = -1;
    }

    public String getReleaseVersion(HostType type) {
        switch (type) {
            case LOCAL_HOST: {
                return "v1";
            }
        }
        return "v14.1";
    }

    public abstract String getAparLevel(HostType var1);

    public int getMajor() {
        return this.majorProtocolVersion;
    }

    public int getMinor() {
        return this.minorProtocolVersion;
    }

    public String toString() {
        return this.name() + "(" + this.majorProtocolVersion + "," + this.minorProtocolVersion + ")";
    }

    public boolean isFunctionalSuperSetOf(FMHostVersion version) {
        return this.compareTo(version) >= 0;
    }
}

