/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.jhost.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class XmlTag {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final String name;
    private final List<XmlTag> children = new ArrayList<XmlTag>();
    private final Map<String, String> attributes = new HashMap<String, String>();

    protected static String getReplacement(char c) {
        switch (c) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
            case '\r': {
                return "#x0D";
            }
            case '\n': {
                return "#x0A";
            }
            case '\t': {
                return "#x09";
            }
        }
        return null;
    }

    public XmlTag(String name) {
        Objects.requireNonNull(name, "Must specify a non-null name.");
        if (name.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.name = name;
    }

    public String getTagName() {
        return this.name;
    }

    public XmlTag createChild(String name) {
        XmlTag child = new XmlTag(name);
        this.children.add(child);
        return child;
    }

    public XmlTag addChild(XmlTag child) {
        this.children.add(Objects.requireNonNull(child, "Must provide a non-null child"));
        return this;
    }

    public List<XmlTag> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public XmlTag setAttribute(String name, String value) {
        Objects.requireNonNull(name, "Must provide a non-null name");
        if (name.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, value);
        }
        return this;
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public String toString() {
        return this.serialize();
    }

    public String serialize() {
        StringBuilder sb = new StringBuilder();
        this.serializeTo(sb);
        return sb.toString();
    }

    private void serializeTo(StringBuilder sb) {
        sb.append("<");
        sb.append(this.name);
        boolean firstAttr = true;
        for (Map.Entry<String, String> attr : this.attributes.entrySet()) {
            if (firstAttr) {
                sb.append(" ");
            }
            sb.append(attr.getKey());
            sb.append("=\"");
            String attribVal = attr.getValue();
            int i = 0;
            while (i < attribVal.length()) {
                char c = attribVal.charAt(i);
                String replacement = XmlTag.getReplacement(c);
                if (replacement != null) {
                    sb.append('&');
                    sb.append(replacement);
                    sb.append(';');
                } else if (c == '\t' || c == '\n' || c == '\r' || c >= ' ') {
                    sb.append(c);
                }
                ++i;
            }
            sb.append("\"");
        }
        if (this.children.isEmpty()) {
            sb.append("/>");
            return;
        }
        sb.append(">");
        for (XmlTag child : this.children) {
            child.serializeTo(sb);
        }
        sb.append("</");
        sb.append(this.name);
        sb.append(">");
    }
}

