/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.jhost.core.socket.io;

import com.ibm.etools.fm.jhost.core.Messages;
import com.ibm.etools.fm.jhost.core.socket.io.CommonConnectionFMJhost;
import com.ibm.etools.fm.jhost.core.socket.response.GetImsKeyPosResponsePacket;
import com.ibm.etools.fm.jhost.core.socket.response.GetRecX2ResponsePacket;
import com.ibm.etools.fm.jhost.core.socket.response.GetTempleXResponsePacket;
import com.ibm.etools.fm.jhost.core.socket.response.NewRecXResponsePacket;
import com.ibm.etools.fm.jhost.core.socket.response.PutRecX2TemplateResponsePacket;
import com.ibm.etools.fm.jhost.core.socket.response.PutRecXEditorResponsePacket;
import com.ibm.etools.fm.jhost.core.socket.response.PutRecXEditorResponsePacketForIms;
import com.ibm.etools.fm.jhost.core.socket.response.PutRecXTemplateResponsePacket;
import com.ibm.etools.fm.jhost.core.socket.response.SetImsKeyPosResponsePacket;
import com.ibm.etools.fm.jhost.core.socket.response.UpdateRecXResponsePacket;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.comms.PDContext;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import com.ibm.pdtools.common.component.jhost.socket.response.GetRecResponsePacket;
import com.ibm.pdtools.common.component.jhost.socket.response.GetRecXResponsePacket;
import com.ibm.pdtools.common.component.jhost.socket.response.SimpleResponsePacket;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;

public class ZosConnectionJhost
extends CommonConnectionFMJhost {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2025. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLoggerJhost logger = PDLoggerJhost.get(ZosConnectionJhost.class);

    public ZosConnectionJhost(IPDHost pdHost, IPDConnectEndpoint endpoint, PDContext pdContext, IHowIsGoing monitor) throws CommunicationException, InterruptedException {
        super(pdHost, endpoint, pdContext != null ? pdContext.getAuthDetails() : null, monitor);
        if (pdHost.getHostType() != HostType.ZOS) {
            throw new IllegalArgumentException("Only supports zOS host type");
        }
    }

    public Result<StringBuffer> readToMappingTemplate(IZRL toTemplate, String toFullLocalFilePath, IHowIsGoing monitor) throws InterruptedException {
        logger.debug((Object)("Reading the contents of TO template: " + toTemplate.getFormattedName()));
        Result result = new Result();
        try {
            result.addSubResult(this.setXMLErrorsWrapped(false, monitor));
            if (!result.isSuccessfulWithoutWarnings()) {
                return result;
            }
            Throwable throwable = null;
            Object var6_9 = null;
            try (BufferedWriter toWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(toFullLocalFilePath), StandardCharsets.UTF_8));){
                String request = "GETREC".toUpperCase().trim();
                this.writePacket(37, request, null, monitor);
                SimpleResponsePacket reqResp = new SimpleResponsePacket(this.socketIO, monitor);
                if (reqResp.getMsgCount() > 0) {
                    result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
                }
                if (reqResp.getReturnCode() > 4) {
                    result.setRC(reqResp.getReturnCode());
                    return result;
                }
                this.socketIO.readUnsignedInt(monitor);
                int dataLength = this.socketIO.readUnsignedInt(monitor);
                byte[] xmlBuffer = new byte[dataLength];
                this.socketIO.readBytes(xmlBuffer, 0, xmlBuffer.length, monitor);
                String s = new String(xmlBuffer, 0, xmlBuffer.length, this.pdHost.getHostType().getCommunicationEncoding());
                toWriter.write(s);
                if (reqResp.isiRepMoreData()) {
                    this.performGETRECX(monitor, (Result<StringBuffer>)result, toWriter);
                    return result;
                }
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            String errMsg = MessageFormat.format(Messages.TM_MAPPING_READ_TO_TEMPLATE_EXC, toTemplate.getFormattedName());
            result.add(errMsg);
            result.add((Throwable)e);
            return result;
        }
    }

    public Result<StringBuffer> sendGenMapCommand(IHowIsGoing monitor) {
        logger.trace((Object)"Re-generating field mapping information.");
        Result result = new Result();
        try {
            result.addSubResult(this.setXMLErrorsWrapped(false, monitor));
            if (!result.isSuccessfulWithoutWarnings()) {
                return result;
            }
            String request = "GENMAP".toUpperCase().trim();
            this.writePacket(39, request, null, monitor);
            SimpleResponsePacket reqResp = new SimpleResponsePacket(this.socketIO, monitor);
            if (reqResp.getMsgCount() > 0) {
                result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
            }
            result.setRC(reqResp.getReturnCode());
            return result;
        }
        catch (Exception e) {
            String errMsg = Messages.TM_REGEN_ERROR;
            result.add(errMsg);
            result.add((Throwable)e);
            return result;
        }
    }

    public StringBuffer updateTOTemplate(StringBuffer updateInputXml, IHowIsGoing monitor, Result<StringBuffer> result) throws InterruptedException {
        block5: {
            logger.trace((Object)("Updating TO template. new XML template contents: " + String.valueOf(updateInputXml)));
            byte[] putRecBytes = "PUTREC".getBytes(this.pdHost.getHostType().getCommunicationEncoding());
            byte[] updateInputXmlBytes = updateInputXml.toString().getBytes(this.pdHost.getHostType().getCommunicationEncoding());
            int packetLen = updateInputXmlBytes.length + putRecBytes.length + 16 + 2;
            ByteBuffer buf = ByteBuffer.allocate(packetLen);
            buf.putInt(packetLen);
            buf.putInt(38);
            buf.putInt(updateInputXmlBytes.length);
            buf.put(putRecBytes);
            buf.put(new byte[2]);
            buf.putInt(1);
            buf.put(updateInputXmlBytes);
            this.socketIO.writeBytes(buf.array(), 0, buf.position(), monitor);
            PutRecX2TemplateResponsePacket reqResp = new PutRecX2TemplateResponsePacket(this.socketIO, monitor);
            if (reqResp.getMsgCount() > 0) {
                result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
            }
            if (reqResp.getReturnCode() <= 4) break block5;
            result.setRC(reqResp.getReturnCode());
            return null;
        }
        try {
            return this.getTemplateXML2Data(monitor, result);
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            String errMsg = Messages.Connection_UPDATE_TEMPLATE_ERR;
            logger.error((Object)errMsg, (Throwable)e);
            result.add(errMsg);
            result.add((Throwable)e);
            return null;
        }
    }

    protected boolean performGETRECX(IHowIsGoing monitor, Result<StringBuffer> result, Writer writer) throws IOException, CommunicationException, InterruptedException {
        String request = "GETRECX";
        this.writePacket(32, request, null, monitor);
        GetRecXResponsePacket getRecResp = new GetRecXResponsePacket(this.socketIO, monitor);
        if (getRecResp.getMsgCount() > 0) {
            result.add(Arrays.asList(getRecResp.getMessages(this.pdHost.getCodePage())));
        }
        if (getRecResp.getReturnCode() > 4) {
            result.setRC(getRecResp.getReturnCode());
            return false;
        }
        byte[] xmlBuffer = new byte[getRecResp.getiPayLoadLength()];
        this.socketIO.readBytes(xmlBuffer, 0, xmlBuffer.length, monitor);
        String s = new String(xmlBuffer, 0, xmlBuffer.length, this.pdHost.getHostType().getCommunicationEncoding());
        logger.debug((Object)s);
        writer.write(s);
        while (getRecResp.isiRepMoreData()) {
            this.writePacket(32, request, null, monitor);
            getRecResp = new GetRecXResponsePacket(this.socketIO, monitor);
            xmlBuffer = new byte[getRecResp.getiPayLoadLength()];
            this.socketIO.readBytes(xmlBuffer, 0, xmlBuffer.length, monitor);
            s = new String(xmlBuffer, 0, xmlBuffer.length, this.pdHost.getHostType().getCommunicationEncoding());
            logger.debug((Object)s);
            writer.write(s);
            if (getRecResp.getMsgCount() <= 0) continue;
            result.add(Arrays.asList(getRecResp.getMessages(this.pdHost.getCodePage())));
        }
        return true;
    }

    protected Object getFile(Object file) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getCompilerListing(Result<StringBuffer> result, File file, IHowIsGoing monitor) throws InterruptedException {
        logger.debug((Object)"Getting compiler listing output of failed template load.");
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
                String request = "GETCMPL";
                this.writePacket(28, request, null, monitor);
                SimpleResponsePacket reqResp = new SimpleResponsePacket(this.socketIO, monitor);
                if (reqResp.getMsgCount() > 0) {
                    result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
                }
                if (reqResp.getReturnCode() > 4) {
                    result.setRC(reqResp.getReturnCode());
                    return false;
                }
                String getRecReq = "GETREC";
                this.writePacket(16, getRecReq, null, monitor);
                GetRecResponsePacket getRecResp = new GetRecResponsePacket(this.socketIO, monitor);
                if (getRecResp.getMsgCount() > 0) {
                    result.add(Arrays.asList(getRecResp.getMessages(this.pdHost.getCodePage())));
                }
                if (getRecResp.getReturnCode() > 4) {
                    result.setRC(getRecResp.getReturnCode());
                    return false;
                }
                writer.write(getRecResp.getRecordsAsString(this.pdHost.getHostType().getCommunicationEncoding()));
                while (true) {
                    if (!getRecResp.isiRepMoreData()) {
                        return true;
                    }
                    getRecReq = "GETREC";
                    this.writePacket(16, getRecReq, null, monitor);
                    getRecResp = new GetRecResponsePacket(this.socketIO, monitor);
                    writer.write(getRecResp.getRecordsAsString(this.pdHost.getHostType().getCommunicationEncoding()));
                    if (getRecResp.getMsgCount() <= 0) continue;
                    result.add(Arrays.asList(getRecResp.getMessages(this.pdHost.getCodePage())));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            String errMsg = Messages.Connection_GET_COMP_LIST_ERR;
            result.add(errMsg);
            result.add((Throwable)e);
            return false;
        }
    }

    public StringBuffer getTemplateXMLData(IHowIsGoing monitor, Result<StringBuffer> result) throws InterruptedException {
        GetRecXResponsePacket reqResp;
        String getRecReq;
        StringBuffer xmlBuf;
        block7: {
            xmlBuf = new StringBuffer(1000);
            getRecReq = "GETRECX";
            this.writePacket(32, getRecReq, null, monitor);
            reqResp = new GetRecXResponsePacket(this.socketIO, monitor);
            if (reqResp.getMsgCount() > 0) {
                result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
            }
            if (reqResp.getReturnCode() <= 4) break block7;
            result.setRC(reqResp.getReturnCode());
            return null;
        }
        try {
            byte[] xmlBuffer = new byte[reqResp.getiPayLoadLength()];
            this.socketIO.readBytes(xmlBuffer, xmlBuffer.length, monitor);
            String s = new String(xmlBuffer, 0, xmlBuffer.length, this.pdHost.getHostType().getCommunicationEncoding());
            xmlBuf.append(s);
            while (reqResp.isiRepMoreData()) {
                getRecReq = "GETRECX";
                this.writePacket(32, getRecReq, null, monitor);
                reqResp = new GetRecXResponsePacket(this.socketIO, monitor);
                xmlBuffer = new byte[reqResp.getiPayLoadLength()];
                this.socketIO.readBytes(xmlBuffer, xmlBuffer.length, monitor);
                s = new String(xmlBuffer, 0, xmlBuffer.length, this.pdHost.getHostType().getCommunicationEncoding());
                xmlBuf.append(s);
                if (reqResp.getMsgCount() <= 0) continue;
                result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
            }
            if (PDLoggerJhost.isTraceEnabled()) {
                logger.trace((Object)xmlBuf);
            }
            return xmlBuf;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            result.add((Throwable)e);
            return null;
        }
    }

    public StringBuffer getTemplateXML2Data(IHowIsGoing monitor, Result<StringBuffer> result) throws InterruptedException {
        GetRecX2ResponsePacket reqResp;
        String getRecReq;
        StringBuffer xmlBuf;
        block6: {
            xmlBuf = new StringBuffer(1000);
            getRecReq = "GETRECX";
            this.writePacket(37, getRecReq, null, monitor);
            reqResp = new GetRecX2ResponsePacket(this.socketIO, monitor);
            if (reqResp.getMsgCount() > 0) {
                result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
            }
            if (reqResp.getReturnCode() <= 4) break block6;
            result.setRC(reqResp.getReturnCode());
            return null;
        }
        try {
            byte[] xmlBuffer = new byte[reqResp.getiPayLoadLength()];
            this.socketIO.readBytes(xmlBuffer, xmlBuffer.length, monitor);
            String s = new String(xmlBuffer, 0, xmlBuffer.length, this.pdHost.getHostType().getCommunicationEncoding());
            xmlBuf.append(s);
            while (reqResp.isiRepMoreData()) {
                getRecReq = "GETRECX";
                this.writePacket(37, getRecReq, null, monitor);
                reqResp = new GetRecX2ResponsePacket(this.socketIO, monitor);
                xmlBuffer = new byte[reqResp.getiPayLoadLength()];
                this.socketIO.readBytes(xmlBuffer, xmlBuffer.length, monitor);
                s = new String(xmlBuffer, 0, xmlBuffer.length, this.pdHost.getHostType().getCommunicationEncoding());
                xmlBuf.append(s);
                if (reqResp.getMsgCount() <= 0) continue;
                result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
            }
            return xmlBuf;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            result.add((Throwable)e);
            return null;
        }
    }

    public StringBuffer updateTemplate(StringBuffer updateInputXml, IHowIsGoing monitor, Result<StringBuffer> result, boolean retrieveNewTemplate, boolean updateToTemplate) throws InterruptedException {
        block12: {
            block10: {
                block11: {
                    logger.trace((Object)("Updating template. new XML template contents: " + String.valueOf(updateInputXml)));
                    byte[] putRecBytes = "PUTREC".getBytes(this.pdHost.getHostType().getCommunicationEncoding());
                    byte[] updateInputXmlBytes = updateInputXml.toString().getBytes(this.pdHost.getHostType().getCommunicationEncoding());
                    int packetLen = updateInputXmlBytes.length + putRecBytes.length + 16 + 2;
                    ByteBuffer buf = ByteBuffer.allocate(packetLen);
                    buf.putInt(packetLen);
                    buf.putInt(updateToTemplate ? 38 : 33);
                    buf.putInt(updateInputXmlBytes.length);
                    buf.put(putRecBytes);
                    buf.put(new byte[2]);
                    buf.putInt(1);
                    buf.put(updateInputXmlBytes);
                    this.socketIO.writeBytes(buf.array(), 0, buf.position(), monitor);
                    if (!updateToTemplate) break block10;
                    PutRecX2TemplateResponsePacket reqResp = new PutRecX2TemplateResponsePacket(this.socketIO, monitor);
                    if (reqResp.getMsgCount() > 0) {
                        result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
                    }
                    if (reqResp.getReturnCode() <= 4) break block11;
                    result.setRC(reqResp.getReturnCode());
                    return null;
                }
                if (retrieveNewTemplate) {
                    logger.trace((Object)"Retrieving and returning the latest template from the host.");
                    return this.getTemplateXMLData(monitor, result);
                }
                logger.trace((Object)"NOT retrieving and returning the latest template from the host.");
                return null;
            }
            PutRecXTemplateResponsePacket reqResp = new PutRecXTemplateResponsePacket(this.socketIO, monitor);
            if (reqResp.getMsgCount() > 0) {
                result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
            }
            if (reqResp.getReturnCode() <= 4) break block12;
            result.setRC(reqResp.getReturnCode());
            return null;
        }
        try {
            if (retrieveNewTemplate) {
                logger.trace((Object)"Retrieving and returning the latest template from the host.");
                return this.getTemplateXMLData(monitor, result);
            }
            logger.trace((Object)"NOT retrieving and returning the latest template from the host.");
            return null;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            String errMsg = Messages.Connection_UPDATE_TEMPLATE_ERR;
            logger.error((Object)errMsg, (Throwable)e);
            result.add(errMsg);
            result.add((Throwable)e);
            return null;
        }
    }

    public Result<StringBuffer> getSupportedCcsid(IHowIsGoing monitor) throws InterruptedException {
        logger.debug((Object)"Retrieving a list of supported CCSIDs.");
        Result result = new Result();
        result.setOutput((Object)new StringBuffer());
        try {
            String request = "CCSID";
            this.writePacket(27, request, null, monitor);
            SimpleResponsePacket reqResp = new SimpleResponsePacket(this.socketIO, monitor);
            if (reqResp.getMsgCount() > 0) {
                result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
            }
            if (reqResp.getReturnCode() > 4) {
                result.setRC(reqResp.getReturnCode());
                return result;
            }
            if (reqResp.getReturnCode() != 0) {
                result.setRC(reqResp.getReturnCode());
                String errMsg = Messages.ZosConnection_0;
                logger.error((Object)errMsg);
                result.add(errMsg);
                return result;
            }
            result.setRC(reqResp.getReturnCode());
            this.readDataIfAny(reqResp, (Result<StringBuffer>)result, monitor);
            return result;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            String errMsg = Messages.ZosConnection_1;
            result.add(errMsg);
            result.add((Throwable)e);
            return result;
        }
    }

    public boolean sendEditorCommand(String editorCommand, String additionalData, Result<StringBuffer> result, IHowIsGoing monitor) throws Exception {
        logger.trace((Object)("Sending editor command: " + editorCommand));
        try {
            this.writePacket(27, editorCommand, additionalData, monitor);
        }
        catch (IOException e) {
            logger.debug((Object)"Returning false - failed to send editor command");
            result.setRC(8);
            result.add(Messages.Connection_CMM_ERR);
            return false;
        }
        SimpleResponsePacket reqResp = new SimpleResponsePacket(this.socketIO, monitor);
        if (reqResp.getMsgCount() > 0) {
            result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
        }
        if (reqResp.getReturnCode() != 0) {
            result.setRC(reqResp.getReturnCode());
            String errMsg = MessageFormat.format(Messages.Connection_EDITOR_CMD_ERR, editorCommand, reqResp.getReturnCode());
            logger.error((Object)errMsg);
            result.add(errMsg);
            this.readDataIfAny(reqResp, result, monitor);
            return false;
        }
        result.setRC(reqResp.getReturnCode());
        this.readDataIfAny(reqResp, result, monitor);
        return true;
    }

    private void readDataIfAny(SimpleResponsePacket reqResp, Result<StringBuffer> result, IHowIsGoing monitor) throws Exception {
        int totalLength = 24;
        if (reqResp.getMsgCount() > 0) {
            totalLength += reqResp.getMessageDataSize();
        }
        if (totalLength < reqResp.getTotalBytes()) {
            byte[] data = new byte[reqResp.getTotalBytes() - totalLength];
            this.socketIO.readBytes(data, 0, data.length, monitor);
            ((StringBuffer)result.getOutput()).append(new String(data, 0, data.length, this.pdHost.getHostType().getCommunicationEncoding()));
        }
    }

    public boolean sendEditorOptions(String editorOptions, Result<StringBuffer> result, IHowIsGoing monitor) throws Exception {
        logger.debug((Object)("Sending editor options: [" + editorOptions + "]."));
        try {
            this.writePacket(8, editorOptions, null, monitor);
        }
        catch (IOException e) {
            logger.debug((Object)"Returning false - failed to send editor options");
            result.setRC(8);
            result.add(Messages.Connection_CMM_ERR);
            return false;
        }
        SimpleResponsePacket reqResp = new SimpleResponsePacket(this.socketIO, monitor);
        if (reqResp.getMsgCount() > 0) {
            result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
        }
        if (reqResp.getReturnCode() != 0) {
            logger.debug((Object)("returning false. rc=" + reqResp.getReturnCode()));
            return false;
        }
        logger.debug((Object)"returning true.");
        result.setRC(reqResp.getReturnCode());
        return true;
    }

    public void updateRecordsInHexInEditSession(String recsToUpdate, int noOfRecs, IHowIsGoing monitor, Result<StringBuffer> overallResult) throws Exception {
        logger.debug((Object)("Updating " + noOfRecs + " records. The contents: [" + recsToUpdate + "]"));
        byte[] putRecBytes = "PUTREC".getBytes(this.pdHost.getHostType().getCommunicationEncoding());
        byte[] recsToUpdateBytes = recsToUpdate.getBytes(this.pdHost.getHostType().getCommunicationEncoding());
        int packetLen = recsToUpdateBytes.length + putRecBytes.length + 16 + 2;
        ByteBuffer buf = ByteBuffer.allocate(packetLen);
        buf.putInt(packetLen);
        buf.putInt(33);
        buf.putInt(recsToUpdateBytes.length);
        buf.put(putRecBytes);
        buf.put(new byte[2]);
        buf.putInt(noOfRecs);
        buf.put(recsToUpdateBytes);
        this.socketIO.writeBytes(buf.array(), 0, buf.position(), monitor);
        PutRecXEditorResponsePacket reqResp = new PutRecXEditorResponsePacket(this.socketIO, monitor);
        this.processResponse(reqResp, reqResp.getHeaderSize(), 0, overallResult, monitor);
    }

    public void updateRecordsInHexInEditSessionForIms(String recsToUpdate, IHowIsGoing monitor, Result<StringBuffer> overallResult) throws Exception {
        logger.debug((Object)("Updating IMS records The contents: [" + recsToUpdate + "]"));
        byte[] putRecBytes = "PUTREC".getBytes(this.pdHost.getHostType().getCommunicationEncoding());
        byte[] recsToUpdateBytes = recsToUpdate.getBytes(this.pdHost.getHostType().getCommunicationEncoding());
        int packetLen = recsToUpdateBytes.length + putRecBytes.length + 16 + 2;
        ByteBuffer buf = ByteBuffer.allocate(packetLen);
        buf.putInt(packetLen);
        buf.putInt(33);
        buf.putInt(recsToUpdateBytes.length);
        buf.put(putRecBytes);
        buf.put(new byte[2]);
        buf.putInt(1);
        buf.put(recsToUpdateBytes);
        this.socketIO.writeBytes(buf.array(), 0, buf.position(), monitor);
        PutRecXEditorResponsePacketForIms reqResp = new PutRecXEditorResponsePacketForIms(this.socketIO, monitor);
        overallResult.setRC(reqResp.getReturnCode());
        if (reqResp.getMsgCount() > 0) {
            overallResult.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
        }
    }

    public Result<StringBuffer> insertFormattedRecordsInEditSession(String recsToUpdate, int noOfRecs, IHowIsGoing monitor) throws Exception {
        logger.debug((Object)("Inserting " + noOfRecs + " formatted records. The contents: [" + recsToUpdate + "]"));
        Result result = new Result((Object)new StringBuffer());
        byte[] recsToUpdateBytes = recsToUpdate.getBytes(this.pdHost.getHostType().getCommunicationEncoding());
        byte[] newRecBytes = "NEWREC".getBytes(this.pdHost.getHostType().getCommunicationEncoding());
        int packetLen = recsToUpdateBytes.length + newRecBytes.length + 16 + 2;
        ByteBuffer buf = ByteBuffer.allocate(packetLen);
        buf.putInt(packetLen);
        buf.putInt(36);
        buf.putInt(recsToUpdateBytes.length);
        buf.put(newRecBytes);
        buf.put(new byte[2]);
        buf.putInt(noOfRecs);
        buf.put(recsToUpdateBytes);
        this.socketIO.writeBytes(buf.array(), 0, buf.position(), monitor);
        NewRecXResponsePacket reqResp = new NewRecXResponsePacket(this.socketIO, monitor);
        if (reqResp.getMsgCount() > 0) {
            result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
        }
        if (reqResp.getReturnCode() > 4) {
            result.setRC(reqResp.getReturnCode());
            return result;
        }
        byte[] buffer = new byte[reqResp.getSize()];
        this.socketIO.readBytes(buffer, 0, buffer.length, monitor);
        String s = new String(buffer, 0, buffer.length, this.pdHost.getHostType().getCommunicationEncoding());
        ((StringBuffer)result.getOutput()).append(s);
        while (reqResp.isiRepMoreData()) {
            this.writePacket(32, "GETRECX", null, monitor);
            GetRecXResponsePacket getRecResp = new GetRecXResponsePacket(this.socketIO, monitor);
            buffer = new byte[getRecResp.getiPayLoadLength()];
            this.socketIO.readBytes(buffer, 0, buffer.length, monitor);
            s = new String(buffer, 0, buffer.length, this.pdHost.getHostType().getCommunicationEncoding());
            ((StringBuffer)result.getOutput()).append(s);
            if (getRecResp.getMsgCount() <= 0) continue;
            result.add(Arrays.asList(getRecResp.getMessages(this.pdHost.getCodePage())));
        }
        return result;
    }

    public Result<StringBuffer> validateFormattedRecordsInEditSession(String recsToCheck, int noOfRecs, IHowIsGoing monitor) throws Exception {
        logger.debug((Object)("Checking " + noOfRecs + " records. The contents: [" + recsToCheck + "]"));
        byte[] updRecBytes = "UPDREC".getBytes(this.pdHost.getHostType().getCommunicationEncoding());
        byte[] recsToCheckBytes = recsToCheck.getBytes(this.pdHost.getHostType().getCommunicationEncoding());
        int packetLen = recsToCheckBytes.length + updRecBytes.length + 16 + 2;
        ByteBuffer buf = ByteBuffer.allocate(packetLen);
        buf.putInt(packetLen);
        buf.putInt(35);
        buf.putInt(recsToCheckBytes.length);
        buf.put(updRecBytes);
        buf.put(new byte[2]);
        buf.putInt(noOfRecs);
        buf.put(recsToCheckBytes);
        this.socketIO.writeBytes(buf.array(), 0, buf.position(), monitor);
        UpdateRecXResponsePacket reqResp = new UpdateRecXResponsePacket(this.socketIO, monitor);
        int lenXMLresult = reqResp.getLength();
        Result result = new Result((Object)new StringBuffer());
        result.setRC(reqResp.getReturnCode());
        if (reqResp.getReturnCode() > 4) {
            if (reqResp.getMsgCount() > 0) {
                result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
            }
            return result;
        }
        byte[] xmlBytes = new byte[lenXMLresult];
        this.socketIO.readBytes(xmlBytes, lenXMLresult, monitor);
        String xmlResult = new String(xmlBytes, 0, lenXMLresult, this.pdHost.getHostType().getCommunicationEncoding());
        ((StringBuffer)result.getOutput()).append(xmlResult);
        if (!reqResp.isiRepMoreData()) {
            return result;
        }
        GetRecXResponsePacket getRecXResp = null;
        String requestRecX = "GETRECX";
        do {
            this.writePacket(32, requestRecX, null, monitor);
            getRecXResp = new GetRecXResponsePacket(this.socketIO, monitor);
            byte[] xmlBuffer = new byte[getRecXResp.getiPayLoadLength()];
            this.socketIO.readBytes(xmlBuffer, xmlBuffer.length, monitor);
            ((StringBuffer)result.getOutput()).append(new String(xmlBuffer, 0, xmlBuffer.length, this.pdHost.getHostType().getCommunicationEncoding()));
            if (getRecXResp.getMsgCount() <= 0) continue;
            result.add(Arrays.asList(getRecXResp.getMessages(this.pdHost.getCodePage())));
        } while (getRecXResp.isiRepMoreData());
        return result;
    }

    public synchronized Result<StringBuffer> readNextRecordsFromEditSession(String fullLocalFilePath, String numberOfRecordsToRead, IHowIsGoing monitor) throws Exception {
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedWriter aWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fullLocalFilePath), StandardCharsets.UTF_8));){
            return this.readNextRecordsFromEditSession(aWriter, numberOfRecordsToRead, monitor);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public synchronized Result<StringBuffer> readNextRecordsFromEditSession(StringBuilder aBuffer, String numberOfRecordsToRead, IHowIsGoing monitor) throws IOException, CommunicationException, InterruptedException {
        CharArrayWriter aWriter = null;
        aWriter = new CharArrayWriter();
        Result<StringBuffer> result = this.readNextRecordsFromEditSession(aWriter, numberOfRecordsToRead, monitor);
        aBuffer.append(aWriter.toString());
        return result;
    }

    private Result<StringBuffer> readNextRecordsFromEditSession(Writer aWriter, String numberOfRecordsToRead, IHowIsGoing monitor) throws IOException, CommunicationException, InterruptedException {
        logger.debug((Object)("reading " + numberOfRecordsToRead + " records from the current edit session."));
        Result result = new Result((Object)new StringBuffer());
        Object requestRecX = "GETRECX NLRECS=" + numberOfRecordsToRead;
        this.writePacket(32, (String)requestRecX, null, monitor);
        GetRecXResponsePacket reqResp = new GetRecXResponsePacket(this.socketIO, monitor);
        StringBuffer data = this.processResponse((SimpleResponsePacket)reqResp, 32, reqResp.getiPayLoadLength(), result, monitor);
        aWriter.write(data.toString());
        if (reqResp.getReturnCode() > 4) {
            return result;
        }
        requestRecX = "GETRECX";
        while (reqResp.isiRepMoreData()) {
            this.writePacket(32, (String)requestRecX, null, monitor);
            reqResp = new GetRecXResponsePacket(this.socketIO, monitor);
            byte[] xmlBuffer = new byte[reqResp.getiPayLoadLength()];
            this.socketIO.readBytes(xmlBuffer, xmlBuffer.length, monitor);
            String s = new String(xmlBuffer, 0, xmlBuffer.length, this.pdHost.getHostType().getCommunicationEncoding());
            aWriter.write(s);
            if (reqResp.getMsgCount() <= 0) continue;
            result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
        }
        result.setRC(0);
        return result;
    }

    private StringBuffer processResponse(SimpleResponsePacket aResponse, int msgHeaderLen, int expectedDataLen, Result<?> result, IHowIsGoing monitor) throws InterruptedException, IOException {
        StringBuffer dataMsg = new StringBuffer();
        if (aResponse.getMsgCount() > 0) {
            int preMsgDataSize = aResponse.getMsgOffset() - msgHeaderLen;
            byte[] preData = new byte[preMsgDataSize];
            this.socketIO.readBytes(preData, preMsgDataSize, monitor);
            dataMsg.append(new String(preData, this.pdHost.getHostType().getCommunicationEncoding()));
            result.add(Arrays.asList(aResponse.getMessages(this.pdHost.getCodePage())));
            int msgDataLength = aResponse.getMessageDataSize();
            if (expectedDataLen - preMsgDataSize - msgDataLength > 0) {
                byte[] postData = new byte[expectedDataLen - preMsgDataSize - msgDataLength];
                this.socketIO.readBytes(postData, postData.length, monitor);
                dataMsg.append(new String(postData, this.pdHost.getHostType().getCommunicationEncoding()));
                result.setRC(aResponse.getReturnCode());
            } else {
                result.setRC(aResponse.getReturnCode());
            }
        } else if (aResponse.getReturnCode() > 4) {
            result.add(Messages.Connection_ReadMoreDataErr);
            result.setRC(aResponse.getReturnCode());
            if (this.socketIO.bytesAvailable() > 0) {
                byte[] buffer = new byte[expectedDataLen];
                this.socketIO.readBytes(buffer, 0, buffer.length, monitor);
                result.add(new String(buffer, this.pdHost.getHostType().getCommunicationEncoding()));
            }
        } else {
            byte[] xmlBuffer = new byte[expectedDataLen];
            this.socketIO.readBytes(xmlBuffer, xmlBuffer.length, monitor);
            String s = new String(xmlBuffer, 0, xmlBuffer.length, this.pdHost.getHostType().getCommunicationEncoding());
            dataMsg.append(s);
        }
        return dataMsg;
    }

    public Result<StringBuffer> editTemplateRetrieve(IZRL aTemplate, String fullLocalPathTemplate, IHowIsGoing monitor) throws Exception {
        Result result = new Result((Object)new StringBuffer());
        Throwable throwable = null;
        Object var6_7 = null;
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fullLocalPathTemplate), StandardCharsets.UTF_8));){
            result.addSubResult(this.setXMLErrorsWrapped(false, monitor));
            if (!result.isSuccessfulWithoutWarnings()) {
                return result;
            }
            String request = "GETRECX";
            this.writePacket(34, request, null, monitor);
            GetTempleXResponsePacket reqResp = new GetTempleXResponsePacket(this.socketIO, monitor);
            if (reqResp.getMsgCount() > 0) {
                result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
            }
            if (reqResp.getReturnCode() != 0) {
                result.add(MessageFormat.format(Messages.Connection_GET_EDIT_TEMPL_ERR, aTemplate.getFormattedName()));
                result.setRC(reqResp.getReturnCode());
                return result;
            }
            byte[] tmp = new byte[reqResp.getiPayLoadLength()];
            this.socketIO.readBytes(tmp, 0, tmp.length, monitor);
            String s1 = new String(tmp, 0, tmp.length, this.pdHost.getHostType().getCommunicationEncoding());
            writer.write(s1);
            if (!reqResp.isiRepMoreData()) {
                ((Writer)writer).close();
                return result;
            }
            GetRecXResponsePacket xmlResponse = null;
            do {
                this.writePacket(32, request, null, monitor);
                xmlResponse = new GetRecXResponsePacket(this.socketIO, monitor);
                byte[] buffer = new byte[xmlResponse.getiPayLoadLength()];
                this.socketIO.readBytes(buffer, 0, buffer.length, monitor);
                String s = new String(buffer, 0, buffer.length, this.pdHost.getHostType().getCommunicationEncoding());
                writer.write(s);
                if (xmlResponse.getMsgCount() <= 0) continue;
                result.add(Arrays.asList(xmlResponse.getMessages(this.pdHost.getCodePage())));
            } while (xmlResponse.isiRepMoreData());
            ((Writer)writer).close();
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Result<StringBuffer> requestLayoutChange(int layoutID, IHowIsGoing monitor) throws Exception {
        Result result = new Result((Object)new StringBuffer());
        String command = "VIEW LAYOUT=" + layoutID;
        logger.debug((Object)("Changing layout. Command: " + command));
        try {
            this.writePacket(25, command, null, monitor);
        }
        catch (IOException e) {
            logger.debug((Object)"Failed to change layout");
            result.setRC(8);
            result.add(Messages.Connection_CMM_ERR);
            return result;
        }
        SimpleResponsePacket reqResp = new SimpleResponsePacket(this.socketIO, monitor);
        if (reqResp.getMsgCount() > 0) {
            result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
        }
        logger.trace((Object)("Returning, rc=" + reqResp.getReturnCode()));
        result.setRC(reqResp.getReturnCode());
        return result;
    }

    public Result<StringBuffer> getImsKeyPosition(IHowIsGoing monitor) throws InterruptedException {
        Result result = new Result((Object)new StringBuffer());
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        try {
            this.writePacket(40, "", null, monitor);
            GetImsKeyPosResponsePacket reqResp = new GetImsKeyPosResponsePacket(this.socketIO, monitor);
            if (reqResp.getMsgCount() > 0) {
                result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
            }
            if (reqResp.getReturnCode() > 4) {
                result.setRC(reqResp.getReturnCode());
                return result;
            }
            byte[] xmlBuffer = new byte[reqResp.getiPayLoadLength()];
            this.socketIO.readBytes(xmlBuffer, 0, xmlBuffer.length, monitor);
            String s = new String(xmlBuffer, 0, xmlBuffer.length, this.pdHost.getHostType().getCommunicationEncoding());
            logger.info((Object)s);
            result.setOutput((Object)new StringBuffer(s));
            return result;
        }
        catch (Exception e) {
            String errMsg = Messages.ZosConnectionJhost0;
            result.add(errMsg);
            result.add((Throwable)e);
            result.setRC(8);
            return result;
        }
    }

    public Result<StringBuffer> setImsKeyPosition(String xmlKeyPosSpec, IHowIsGoing monitor) throws InterruptedException {
        Result result = new Result((Object)new StringBuffer());
        logger.debug((Object)("setting ims key position: " + xmlKeyPosSpec));
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        try {
            byte[] putRecBytes = "PUTREC".getBytes(this.pdHost.getHostType().getCommunicationEncoding());
            byte[] updateInputXmlBytes = xmlKeyPosSpec.toString().getBytes(this.pdHost.getHostType().getCommunicationEncoding());
            int packetLen = updateInputXmlBytes.length + putRecBytes.length + 16 + 2;
            ByteBuffer buf = ByteBuffer.allocate(packetLen);
            buf.putInt(packetLen);
            buf.putInt(41);
            buf.putInt(updateInputXmlBytes.length);
            buf.put(putRecBytes);
            buf.put(new byte[2]);
            buf.putInt(1);
            buf.put(updateInputXmlBytes);
            this.socketIO.writeBytes(buf.array(), 0, buf.position(), monitor);
            SetImsKeyPosResponsePacket reqResp = new SetImsKeyPosResponsePacket(this.socketIO, monitor);
            if (reqResp.getMsgCount() > 0) {
                result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
            }
            if (reqResp.getReturnCode() > 4) {
                result.setRC(reqResp.getReturnCode());
                return result;
            }
            return result;
        }
        catch (Exception e) {
            String errMsg = Messages.ZosConnectionJhost1;
            result.add(errMsg);
            result.add((Throwable)e);
            result.setRC(8);
            return result;
        }
    }
}

