/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.jhost.core.socket.io;

import com.ibm.etools.fm.jhost.core.Messages;
import com.ibm.etools.fm.jhost.core.model.FMHostJhost;
import com.ibm.etools.fm.jhost.core.socket.io.IFMFunctionCode;
import com.ibm.etools.fm.jhost.core.version.FMHostVersion;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.socket.io.CommonConnectionJhost;
import com.ibm.pdtools.common.component.jhost.socket.response.GetRecXResponsePacket;
import com.ibm.pdtools.common.component.jhost.socket.response.SimpleResponsePacket;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringTokenizer;

public class CommonConnectionFMJhost
extends CommonConnectionJhost
implements IFMFunctionCode {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public CommonConnectionFMJhost(IPDHost pdHost, IPDConnectEndpoint endpoint, AuthDetails authInfo, IHowIsGoing howIsGoing) throws CommunicationException, InterruptedException {
        super(Objects.requireNonNull(pdHost, "Must specify a non-null pdHost."), endpoint, true, authInfo, howIsGoing);
    }

    public void checkVersionCompatibility(String serverMsg, IPDHost pdHost, IPDConnectEndpoint endpoint) throws CommunicationException {
        String versionStr = "";
        if (serverMsg != null) {
            int aparInfoStartInd = serverMsg.indexOf("APAR=");
            if (aparInfoStartInd >= 0) {
                int serverMsgLen = serverMsg.length();
                int aparInfoEndInd = aparInfoStartInd + 5;
                while (aparInfoEndInd < serverMsgLen && serverMsg.charAt(aparInfoEndInd) != ' ') {
                    aparInfoEndInd += 8;
                }
                pdHost.setInstalledApars(serverMsg.substring(aparInfoStartInd + 5, aparInfoEndInd));
                serverMsg = serverMsg.substring(0, aparInfoStartInd).concat(aparInfoEndInd < serverMsgLen ? serverMsg.substring(aparInfoEndInd + 1) : "");
            } else {
                pdHost.setInstalledApars("");
            }
        }
        StringTokenizer st = new StringTokenizer(serverMsg, " ");
        while (st.hasMoreTokens()) {
            String aToken = st.nextToken();
            if (aToken.startsWith("CONNECTED")) {
                logger.debug((Object)aToken);
                continue;
            }
            if (aToken.startsWith("COMPONENT=")) {
                logger.debug((Object)aToken);
                continue;
            }
            if (aToken.startsWith("VERSION=")) {
                logger.debug((Object)aToken);
                versionStr = aToken.substring(8);
                continue;
            }
            if (aToken.startsWith("PTF=")) {
                logger.debug((Object)aToken);
                continue;
            }
            if (aToken.startsWith("FEATURE=")) {
                int index = aToken.indexOf(61);
                int major = Integer.parseInt(aToken.substring(index + 1, index + 3));
                int minor = Integer.parseInt(aToken.substring(index + 3));
                FMHostVersion expected = FMHostVersion.getLatestVersion(pdHost.getHostType());
                logger.trace((Object)("Server protocol level: major=" + major + " minor=" + minor + "; expecting " + String.valueOf((Object)expected)));
                if (major == expected.getMajor()) {
                    if (minor == expected.getMinor()) {
                        logger.debug((Object)"FM server & client are fully compatible.");
                    } else if (minor < expected.getMinor()) {
                        msg = MessageFormat.format(Messages.Connection_ServerUseOlderProtocol, expected.getReleaseVersion(pdHost.getHostType()), expected.getAparLevel(pdHost.getHostType()));
                        logger.debug((Object)msg);
                        if (major != 2 || minor != 6 || !versionStr.equals("14")) {
                            this.reportVersionIncompatibility(msg);
                            logger.debug((Object)msg);
                        }
                    } else {
                        msg = Messages.Connection_ServerUseNewerProtocol;
                        logger.debug((Object)msg);
                        this.reportVersionIncompatibility(msg);
                        logger.debug((Object)msg);
                    }
                } else {
                    String errMsg = MessageFormat.format(Messages.Connection_IncompatibleProtocol, expected.getReleaseVersion(pdHost.getHostType()), expected.getAparLevel(pdHost.getHostType()));
                    logger.debug((Object)errMsg);
                    logger.error(new Object[]{Messages.Error, errMsg});
                    throw new CommunicationException(errMsg);
                }
                FMHostVersion actual = FMHostVersion.parseFromProtocolLevels(major, minor);
                FMHostJhost.getSystem(pdHost).setServerVersion(pdHost, actual);
                continue;
            }
            if (aToken.startsWith("<ERROR>")) {
                String errMsg = MessageFormat.format(Messages.Connection_ServerConfigErr, serverMsg);
                logger.debug((Object)errMsg);
                logger.error(new Object[]{Messages.Error, errMsg});
                throw new CommunicationException(errMsg);
            }
            logger.error((Object)("Unknown token: " + aToken));
        }
    }

    protected void reportVersionIncompatibility(String msg) {
        logger.error((Object)("incompatability: " + msg));
    }

    public Result<StringBuffer> updateCompilerOptions(IHowIsGoing howIsGoing) throws InterruptedException {
        if (FMHostJhost.getSystem(this.pdHost).getCompilerOptions().isEmpty()) {
            return new Result();
        }
        return new Result(0);
    }

    public Result<StringBuffer> sessionQuit(IHowIsGoing howIsGoing) {
        return this.sessionCommandLogAllExceptions("QUIT", 13, "error encountered:", howIsGoing);
    }

    public Result<StringBuffer> sessionFile(IHowIsGoing howIsGoing) {
        return this.sessionCommandLogAllExceptions("FILE", 27, Messages.Connection_SAVE_DB2_EX, howIsGoing);
    }

    public Result<StringBuffer> sessionSave(IHowIsGoing howIsGoing) throws InterruptedException {
        return this.sessionCommand("SAVE", 14, Messages.Connection_SAVE_EX, howIsGoing);
    }

    public Result<StringBuffer> doGETRECX(String fullLocalFilePath, IHowIsGoing howIsGoing) throws InterruptedException {
        Result result = new Result((Object)new StringBuffer());
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fullLocalFilePath), StandardCharsets.UTF_8));){
                String getRecReq = "GETRECX";
                this.writePacket(32, getRecReq, null, howIsGoing);
                GetRecXResponsePacket reqResp = new GetRecXResponsePacket(this.socketIO, howIsGoing);
                if (reqResp.getMsgCount() > 0) {
                    result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
                }
                if (reqResp.getReturnCode() > 4) {
                    result.setRC(reqResp.getReturnCode());
                    return result;
                }
                byte[] xmlBuffer = new byte[reqResp.getiPayLoadLength()];
                this.socketIO.readBytes(xmlBuffer, 0, xmlBuffer.length, howIsGoing);
                String s = new String(xmlBuffer, 0, xmlBuffer.length, this.pdHost.getHostType().getCommunicationEncoding());
                writer.write(s);
                while (reqResp.isiRepMoreData()) {
                    getRecReq = "GETRECX";
                    this.writePacket(32, getRecReq, null, howIsGoing);
                    reqResp = new GetRecXResponsePacket(this.socketIO, howIsGoing);
                    xmlBuffer = new byte[reqResp.getiPayLoadLength()];
                    this.socketIO.readBytes(xmlBuffer, 0, xmlBuffer.length, howIsGoing);
                    s = new String(xmlBuffer, 0, xmlBuffer.length, this.pdHost.getHostType().getCommunicationEncoding());
                    if (reqResp.getMsgCount() > 0) {
                        result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
                    }
                    writer.write(s);
                }
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (CommunicationException | IOException e) {
            return CommonConnectionFMJhost.addAndLogException(result, (Exception)e, "");
        }
    }

    private static <T> Result<T> addAndLogException(Result<T> result, Exception e, String descriptiveErrorMessage) {
        logger.error((Object)descriptiveErrorMessage, (Throwable)e);
        result.setRC(8);
        result.add((Throwable)e);
        result.add(descriptiveErrorMessage);
        return result;
    }

    public Result<StringBuffer> sessionCommand(String command, int functionCode, String errorMessage, IHowIsGoing howIsGoing) throws InterruptedException {
        logger.trace((Object)("Issuing " + command + " for the current session."));
        Result result = new Result((Object)new StringBuffer());
        try {
            String request = command.toUpperCase();
            this.writePacket(functionCode, request, null, howIsGoing);
            SimpleResponsePacket reqResp = new SimpleResponsePacket(this.socketIO, howIsGoing);
            if (reqResp.getMsgCount() > 0) {
                result.add(Arrays.asList(reqResp.getMessages(this.pdHost.getCodePage())));
            }
            result.setRC(reqResp.getReturnCode());
            return result;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (CommunicationException | IOException e) {
            return CommonConnectionFMJhost.addAndLogException(result, (Exception)e, errorMessage);
        }
    }

    public Result<StringBuffer> sessionCommandLogAllExceptions(String command, int functionCode, String errorMessage, IHowIsGoing howIsGoing) {
        try {
            return this.sessionCommand(command, functionCode, errorMessage, howIsGoing);
        }
        catch (InterruptedException e) {
            return CommonConnectionFMJhost.addAndLogException(new Result((Object)new StringBuffer()), e, errorMessage);
        }
    }
}

