/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.jhost.core.socket.func;

import com.ibm.etools.fm.jhost.core.Messages;
import com.ibm.etools.fm.jhost.core.socket.func.ALLOCDD;
import com.ibm.etools.fm.jhost.core.socket.func.FREEDD;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunctionParser;
import com.ibm.etools.fm.jhost.core.socket.io.CommonConnectionFMJhost;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import com.ibm.pdtools.common.component.jhost.socket.io.CommonConnectionJhost;
import com.ibm.pdtools.common.component.jhost.socket.io.ConnPoolManagerJhost;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.util.TimeUtils;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Objects;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class UtilityFunctionRunnerJhost {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2025. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLoggerJhost logger = PDLoggerJhost.get(UtilityFunctionRunnerJhost.class);
    protected static final int OUTPUT_TRACE_SPLIT_SIZE = 1000000;

    private static <V> V executeRunnable(IPDHost pdHost, IPDConnectEndpoint endpoint, IHowIsGoing howIsGoing, ConnectionRunnable<V> runnable) throws InterruptedException, CommunicationException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (CommonConnectionJhost connection = ConnPoolManagerJhost.instance().getConnection(pdHost, endpoint, null, howIsGoing);){
            return runnable.run(connection, howIsGoing);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Result<StringBuffer> execute(IPDHost pdHost, IPDConnectEndpoint endpoint, final UtilityFunction function, IHowIsGoing howIsGoing) throws InterruptedException {
        try {
            return UtilityFunctionRunnerJhost.executeRunnable(pdHost, endpoint, howIsGoing, new ConnectionRunnable<Result<StringBuffer>>(){

                @Override
                public Result<StringBuffer> run(CommonConnectionJhost connection, IHowIsGoing howIsGoing) throws InterruptedException, CommunicationException {
                    return UtilityFunctionRunnerJhost.runCommand(connection, function, howIsGoing);
                }
            });
        }
        catch (CommunicationException e) {
            return new Result(e);
        }
    }

    @Deprecated
    private static <T extends UtilityFunctionParser<U>, U> Result<U> executeAndParse(IPDHost pdHost, IPDConnectEndpoint endpoint, UtilityFunction function, T parser, IHowIsGoing howIsGoing) throws InterruptedException {
        Result<StringBuffer> commandResult = UtilityFunctionRunnerJhost.execute(pdHost, endpoint, function, howIsGoing);
        return UtilityFunctionRunnerJhost.parse(commandResult, parser, function, pdHost.getCodePage());
    }

    private static <T extends UtilityFunctionParser<U>, U> Result<U> executeAndParse(CommonConnectionFMJhost conn, UtilityFunction function, T parser, IHowIsGoing howIsGoing) throws InterruptedException, CommunicationException {
        Result<StringBuffer> commandResult = UtilityFunctionRunnerJhost.runCommand(conn, function, howIsGoing);
        return UtilityFunctionRunnerJhost.parse(commandResult, parser, function, conn.getSystem().getCodePage());
    }

    protected static <T extends UtilityFunctionParser<U>, U> Result<U> parse(Result<StringBuffer> commandResult, T parser, UtilityFunction function, String codepage) {
        Result result = new Result(commandResult);
        if (commandResult.getOutput() != null && ((StringBuffer)commandResult.getOutput()).length() > 0) {
            try {
                String encoded = new String(((StringBuffer)commandResult.getOutput()).toString().getBytes(codepage), codepage);
                SAXParserFactory.newInstance().newSAXParser().parse(new InputSource(new StringReader(encoded)), parser);
            }
            catch (Exception e) {
                Result subResult = new Result((Throwable)e);
                result.addSubResult(subResult);
                String displayMessage = e.getMessage();
                if (e instanceof SAXParseException) {
                    displayMessage = MessageFormat.format(Messages.SAXParserException_MESSAGE, ((SAXParseException)e).getLineNumber(), ((SAXParseException)e).getColumnNumber(), e.getMessage());
                }
                result.setDisplayMessage(displayMessage);
            }
            result.addSubResultWithOutput(parser.getResult());
        } else {
            logger.trace((Object)("No output or empty output from command " + String.valueOf(function)));
        }
        return result;
    }

    public static Result<StringBuffer> runCommand(CommonConnectionJhost connection, UtilityFunction utilityFunction, IHowIsGoing howIsGoing) throws InterruptedException, CommunicationException {
        Result setHeadersOffResult;
        Result setErrorTypeResult;
        Objects.requireNonNull(utilityFunction, "Must specify a non-null Set of utilityFunction.");
        Result result = null;
        StringWriter writer = new StringWriter();
        String builtCommand = utilityFunction.getCommandString();
        String data = utilityFunction.getPostHeaderData();
        long timeKey = System.nanoTime();
        logger.debug((Object)(timeKey + " " + builtCommand + (String)(data == null ? "" : " data: " + data)));
        HashMap<String, String> dds = new HashMap<String, String>(utilityFunction.getDDs());
        if (dds.size() > 0) {
            howIsGoing.worked(1);
            logger.trace((Object)(timeKey + " Allocating DDs: " + String.valueOf(dds)));
            ALLOCDD allocdd = new ALLOCDD();
            allocdd.setDDsToAllocate(dds);
            Result<StringBuffer> allocResult = UtilityFunctionRunnerJhost.runCommand(connection, allocdd, howIsGoing);
            if (!allocResult.isSuccessfulWithoutWarnings()) {
                return allocResult;
            }
        }
        if (!(setErrorTypeResult = connection.setXMLErrorsRaw(utilityFunction.isExpectingXmlOutput(), utilityFunction.isXmlMsgRequiredRegardless(), howIsGoing)).isSuccessfulWithoutWarnings()) {
            return setErrorTypeResult;
        }
        if (utilityFunction.isHeaderDisabling() && !(setHeadersOffResult = connection.setHeaderPagesOff(howIsGoing)).isSuccessfulWithoutWarnings()) {
            return setHeadersOffResult;
        }
        howIsGoing.worked(1);
        Calendar before = Calendar.getInstance();
        result = connection.executeUtilityFunction(builtCommand, data, writer, howIsGoing);
        howIsGoing.worked(1);
        Calendar after = Calendar.getInstance();
        result.setOutput((Object)UtilityFunctionRunnerJhost.processOutput(utilityFunction, writer.getBuffer()));
        howIsGoing.worked(1);
        if (PDLoggerJhost.isTraceEnabled()) {
            String formatDifference = TimeUtils.formatDifference((Calendar)before, (Calendar)after);
            logger.trace(new Object[]{timeKey, " completed in ", formatDifference, " with max RC=" + result.getRC()});
        }
        if (PDLoggerJhost.isTraceEnabled()) {
            int start = 0;
            int total = ((StringBuffer)result.getOutput()).length() / 1000000 + 1;
            while (start < ((StringBuffer)result.getOutput()).length()) {
                int end = Math.min(((StringBuffer)result.getOutput()).length(), start + 1000000);
                String splitOutput = ((StringBuffer)result.getOutput()).substring(start, end);
                logger.trace(new Object[]{timeKey, " output (", start / 1000000 + 1, "/", total, "):\n", splitOutput, "\n"});
                start += 1000000;
            }
            StringBuilder messagesCombined = result.getMessagesCombined();
            if (messagesCombined.length() > 0) {
                logger.trace(new Object[]{timeKey, " messages:\n", messagesCombined});
            }
        }
        if (dds.size() > 0) {
            howIsGoing.worked(1);
            logger.trace((Object)(timeKey + " Freeing DDs: " + String.valueOf(dds.keySet())));
            FREEDD freedd = new FREEDD();
            freedd.setDDsToFree(dds.keySet());
            Result<StringBuffer> freeResult = UtilityFunctionRunnerJhost.runCommand(connection, freedd, howIsGoing);
            if (!freeResult.isSuccessfulWithoutWarnings()) {
                result.addSubResult(freeResult);
            }
            howIsGoing.worked(1);
        }
        return result;
    }

    protected static StringBuffer processOutput(UtilityFunction function, StringBuffer buffer) {
        if (function.isExpectingXmlOutput()) {
            if (buffer.length() < "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>".length() || !"<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>".equals(buffer.substring(0, "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>".length()))) {
                buffer.insert(0, "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
                int secHeaderPos = buffer.indexOf("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>", "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>".length());
                if (secHeaderPos > 0) {
                    buffer.replace(secHeaderPos, secHeaderPos + "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>".length(), "");
                }
            }
            if (function.isExpectingXmlOutput()) {
                buffer.insert("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>".length(), "<root>");
                buffer.append("</root>");
            }
        }
        int currentPos = buffer.indexOf("\u0000", 0);
        while (currentPos >= 0 && currentPos < buffer.length()) {
            buffer.replace(currentPos, currentPos + 1, " ");
            currentPos = buffer.indexOf("\u0000", currentPos);
        }
        return buffer;
    }

    public static interface ConnectionRunnable<V> {
        public V run(CommonConnectionJhost var1, IHowIsGoing var2) throws InterruptedException, CommunicationException;
    }
}

