/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.jhost.core.socket.func;

import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class UtilityFunction {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLoggerJhost logger = PDLoggerJhost.get(UtilityFunction.class);
    private String command = null;
    private HashMap<String, String> paramValues = new HashMap();
    private String data;
    private Map<String, String> dds = new HashMap<String, String>();

    public UtilityFunction(String command) {
        Objects.requireNonNull(command, "Must specify a non-null command.");
        this.command = command;
    }

    public boolean isHeaderDisabling() {
        return true;
    }

    public boolean isExpectingXmlOutput() {
        return false;
    }

    public boolean isXmlMsgRequiredRegardless() {
        return false;
    }

    public void setPostHeaderData(String data) {
        this.data = data;
    }

    public String getPostHeaderData() {
        return this.data;
    }

    protected void setParameterValue(String parameter, String value) {
        Objects.requireNonNull(parameter, "Must provide a non-null parameter");
        if (parameter.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (value != null && !value.isEmpty()) {
            this.paramValues.put(parameter, value);
        } else {
            this.paramValues.remove(parameter);
        }
    }

    protected void setParameterValue(String parameter, boolean value) {
        Objects.requireNonNull(parameter, "Must provide a non-null parameter");
        if (parameter.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.paramValues.put(parameter, value ? "YES" : "NO");
    }

    protected <T extends Enum<T>> void setParameterValue(String parameter, T value) {
        Objects.requireNonNull(parameter, "Must provide a non-null parameter");
        if (parameter.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (value != null) {
            this.paramValues.put(parameter, value.name());
        } else {
            this.paramValues.remove(parameter);
        }
    }

    public Map<String, String> getParameterValues() {
        return Collections.unmodifiableMap(this.paramValues);
    }

    public void setParameterValues(Map<String, String> paramValues) {
        Set<Map.Entry<String, String>> mappings = paramValues.entrySet();
        for (Map.Entry<String, String> mapping : mappings) {
            this.setParameterValue(mapping.getKey(), mapping.getValue());
        }
    }

    public String getCommandString() {
        Set<Map.Entry<String, String>> paramsWithValues = this.paramValues.entrySet();
        if (paramsWithValues.size() > 0) {
            StringBuilder cmd = new StringBuilder(this.command + " ");
            boolean afterFirst = false;
            for (Map.Entry<String, String> paramWithValue : paramsWithValues) {
                if (!afterFirst) {
                    afterFirst = true;
                } else {
                    cmd.append(",");
                }
                cmd.append(paramWithValue.getKey());
                cmd.append("=");
                cmd.append(paramWithValue.getValue());
            }
            return cmd.toString();
        }
        return this.command;
    }

    public boolean equals(Object o) {
        if (o instanceof UtilityFunction) {
            UtilityFunction otherFunction = (UtilityFunction)o;
            if (!this.command.equals(otherFunction.command)) {
                return false;
            }
            if (this.data != otherFunction.data && !this.data.equals(otherFunction.data)) {
                return false;
            }
            return this.paramValues.equals(otherFunction.paramValues);
        }
        return false;
    }

    public int hashCode() {
        return this.command.hashCode() * this.paramValues.hashCode() * (this.data == null ? 1 : this.data.hashCode());
    }

    public String toString() {
        return "UtilityFunction[" + this.getCommandString() + "]";
    }

    public Map<String, String> getDDs() {
        return Collections.unmodifiableMap(this.dds);
    }

    public void setDDs(Map<String, String> dds) {
        this.dds = new HashMap<String, String>(dds);
    }

    public String getDD(String name) {
        String value = this.dds.get(name);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void setDD(String name, String value) {
        Objects.requireNonNull(name, "Must provide a non-null name");
        if (value == null) {
            this.dds.remove(name);
        } else {
            this.dds.put(name, value);
        }
    }
}

