/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.jhost.core.model;

import com.ibm.etools.fm.jhost.core.model.FMSubsystemType;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunctionRunnerJhost;
import com.ibm.etools.fm.jhost.core.socket.io.ZosConnectionJhost;
import com.ibm.etools.fm.jhost.core.version.FMFeature;
import com.ibm.etools.fm.jhost.core.version.FMHostVersion;
import com.ibm.etools.fm.jhost.core.version.LevelledFeature;
import com.ibm.etools.fm.jhost.core.version.ServerTooOldException;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.comms.PDContext;
import com.ibm.pdtools.common.component.jhost.core.model.EmptyZRL;
import com.ibm.pdtools.common.component.jhost.core.model.IHostSystem;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import com.ibm.pdtools.common.component.jhost.socket.io.CommonConnectionJhost;
import com.ibm.pdtools.common.component.jhost.socket.io.ConnPoolManagerJhost;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.version.PDFeature;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class FMHostJhost
implements IHostSystem,
IPDConnectEndpoint {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLoggerJhost logger = PDLoggerJhost.get(FMHostJhost.class);
    private static final String PROPERTY_PREFIX = "FM-compiler-options-";
    private static final String PROPERTY_PLUGIN = "com.ibm.etools.fm.ui";
    private String hostId;
    private FMHostVersion version = null;
    protected String xmlCompilerOptions = "";
    protected Map<IZRL, List<IZRL>> templateAssociations = new HashMap<IZRL, List<IZRL>>();

    public static FMHostJhost getSystem(IPDHost host) throws IllegalArgumentException {
        if (host == null) {
            throw new IllegalArgumentException("Must specify a non-null PDHost.");
        }
        IHostSystem fmHostSystem = host.getFMHostSystem();
        if (fmHostSystem == null) {
            return null;
        }
        ((FMHostJhost)fmHostSystem).hostId = host.getHostID();
        return (FMHostJhost)fmHostSystem;
    }

    public void updateFrom(IHostSystem aHost) {
        FMHostJhost host = (FMHostJhost)aHost;
        this.templateAssociations = new HashMap<IZRL, List<IZRL>>(host.templateAssociations);
        this.xmlCompilerOptions = host.xmlCompilerOptions;
        this.version = host.version;
    }

    public String getCompilerOptions() {
        String str;
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(PROPERTY_PLUGIN);
        this.xmlCompilerOptions = str = prefs.get(PROPERTY_PREFIX + this.hostId, "");
        return this.xmlCompilerOptions;
    }

    public void setCompilerOptions(String xmlCompilerOptions) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(PROPERTY_PLUGIN);
        prefs.put(PROPERTY_PREFIX + this.hostId, xmlCompilerOptions);
        this.xmlCompilerOptions = Objects.requireNonNull(xmlCompilerOptions, "Must provide a non-null xmlCompilerOptions");
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        logger.trace((Object)MessageFormat.format("New options: ''{0}''", xmlCompilerOptions));
    }

    public Result<StringBuffer> executeOnHost(IPDHost aHost, String command, IHowIsGoing howIsGoing) throws InterruptedException {
        UtilityFunction func = new UtilityFunction(command);
        return UtilityFunctionRunnerJhost.execute(aHost, this, func, howIsGoing);
    }

    public Result<StringBuffer> executeOnThisHost(IPDHost aHost, String command, IHowIsGoing howIsGoing) {
        return null;
    }

    public boolean addTemplateAssociation(IZRL resource, IZRL templateName) {
        List<IZRL> resourceAssociations = this.templateAssociations.get(resource);
        if (resourceAssociations == null) {
            resourceAssociations = new ArrayList<IZRL>();
            this.templateAssociations.put(resource, resourceAssociations);
        }
        if (!resourceAssociations.contains(templateName)) {
            resourceAssociations.add(0, templateName);
            return true;
        }
        resourceAssociations.remove(templateName);
        resourceAssociations.add(0, templateName);
        return false;
    }

    public boolean setCurrentTemplateAssociationToNoTemplate(IZRL resource) {
        return this.addTemplateAssociation(resource, (IZRL)new EmptyZRL());
    }

    public List<String> getTemplateAssociations(IZRL resource) {
        if (resource == null) {
            return Collections.EMPTY_LIST;
        }
        List<IZRL> templateAssociations = this.getTemplateAssociations(resource, resource.getSystem());
        ArrayList<String> templateAssociationsFormattedNames = new ArrayList<String>();
        for (IZRL z : templateAssociations) {
            templateAssociationsFormattedNames.add(z.getFormattedName());
        }
        return templateAssociationsFormattedNames;
    }

    public List<IZRL> getAllTemplateAssociations(IZRL resource) {
        List<IZRL> resourceAssociations = this.templateAssociations.get(resource);
        if (resourceAssociations == null) {
            resourceAssociations = new ArrayList<IZRL>();
        }
        return resourceAssociations;
    }

    public List<IZRL> getTemplateAssociations(IZRL resource, IPDHost filterHost) {
        List<IZRL> resourceAssociations = this.getAllTemplateAssociations(resource);
        ArrayList<IZRL> filteredList = new ArrayList<IZRL>();
        for (IZRL currentResource : resourceAssociations) {
            if (currentResource instanceof EmptyZRL || !filterHost.getHostName().equals(currentResource.getSystem().getHostName()) || filterHost.getPort() != currentResource.getSystem().getPort()) continue;
            filteredList.add(currentResource);
        }
        return filteredList;
    }

    public Collection<IZRL> getAssociatedResources() {
        ArrayList<IZRL> resourceZRLs = new ArrayList<IZRL>();
        for (IZRL resource : this.templateAssociations.keySet()) {
            resourceZRLs.add(resource);
        }
        return resourceZRLs;
    }

    public String getSubsystemID() {
        return "    ";
    }

    public String getConfigurationID() {
        return "FM";
    }

    public boolean supports(IPDHost aHost, PDFeature feature) {
        if (feature instanceof FMFeature) {
            return ((FMFeature)feature).isSupportedBy(aHost.getHostType(), this.version);
        }
        return false;
    }

    public void ensureSupported(IPDHost aHost, LevelledFeature feature) {
        if (!this.supports(aHost, feature)) {
            logger.trace((Object)("Server is too old! current level=" + String.valueOf((Object)this.getServerVersion()) + " min level=" + String.valueOf((Object)feature.getMinLevel(aHost.getHostType())) + " hostType=" + String.valueOf(aHost.getHostType()) + " host=" + aHost.getConnectionName()));
            throw new ServerTooOldException(aHost, feature);
        }
    }

    public FMHostVersion getServerVersion() {
        return this.version;
    }

    public static String getXmlVersionTag(IPDHost pdHost) {
        Objects.requireNonNull(pdHost, "Must provide a non-null pdHost.");
        return "XMLVER=10";
    }

    public void setServerVersion(IPDHost aHost, FMHostVersion version) {
        Objects.requireNonNull(aHost, "Must provide a non-null aHost.");
        if (this.version != version) {
            this.version = version;
            aHost.serverVersionChanged();
        }
    }

    public void loadServerVersion(IPDHost aHost, IHowIsGoing howIsGoing) throws InterruptedException, CommunicationException {
        Throwable throwable = null;
        Object var4_4 = null;
        try {
            CommonConnectionJhost connection = ConnPoolManagerJhost.instance().getConnection(aHost, (IPDConnectEndpoint)this, null, howIsGoing);
            if (connection != null) {
                connection.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String getComponentName() {
        return FMSubsystemType.BASE.getComponentName();
    }

    public boolean providesConnectEndpointType(String endpointTypeName) {
        FMSubsystemType[] fmSubsystemTypes;
        FMSubsystemType[] fMSubsystemTypeArray = fmSubsystemTypes = FMSubsystemType.values();
        int n = fmSubsystemTypes.length;
        int n2 = 0;
        while (n2 < n) {
            FMSubsystemType fmSubsystemType = fMSubsystemTypeArray[n2];
            if (fmSubsystemType.getComponentName().equalsIgnoreCase(endpointTypeName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean confirmRemoveHost(IPDHost aHost) {
        return true;
    }

    public boolean removeHost(IPDHost aHost) {
        return true;
    }

    public boolean endPointPDHost(IPDHost pdHost) {
        return FMHostJhost.getSystem(pdHost).equals(this);
    }

    @Deprecated
    public CommonConnectionJhost getNewConnection(IPDHost pdHost, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
        return this.getNewConnection(pdHost, null, monitor);
    }

    public CommonConnectionJhost getNewConnection(IPDHost pdHost, PDContext pdContext, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
        ZosConnectionJhost chosenConnection = null;
        chosenConnection = new ZosConnectionJhost(pdHost, (IPDConnectEndpoint)this, pdContext, monitor);
        logger.debug((Object)("Established z/OS connection for endpoint " + String.valueOf(this) + " on system " + pdHost.toString()));
        Result<StringBuffer> compileOptsUpdateResult = chosenConnection.updateCompilerOptions(monitor);
        if (!compileOptsUpdateResult.isSuccessfulWithoutWarnings()) {
            logger.debug((Object)("Failed to set compiler options for endpoint " + String.valueOf(this) + " on system " + pdHost.toString()));
            chosenConnection = null;
        }
        return chosenConnection;
    }

    public static void loadHostVersion(IPDHost system, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
        if (system == null) {
            throw new IllegalArgumentException("Must specify a non-null IPDHost.");
        }
        FMHostJhost fm = FMHostJhost.getSystem(system);
        if (fm != null) {
            fm.loadServerVersion(system, monitor);
        }
    }

    public static boolean isRMSupportedBetween(IPDHost src, IPDHost dest, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
        Objects.requireNonNull(src, "Please provide a non-null src host");
        Objects.requireNonNull(dest, "Please provide a non-null dest host");
        boolean rmSupportedDest = true;
        boolean rmSupportedSource = true;
        boolean sameSecurity = src.isSameSecurity(dest);
        logger.trace((Object)MessageFormat.format("src: {0} isSecured: {1} RMSupported: {2} | dest: {3} isSecured: {4} RMSupported: {5}", src, src.isSecured(), rmSupportedSource, dest, dest.isSecured(), rmSupportedDest));
        return sameSecurity && rmSupportedSource && rmSupportedDest;
    }
}

