/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ext.rse.adapter;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.ext.rse.adapter.AdapterUtils;
import com.ibm.etools.zos.system.zOSSystem;
import com.ibm.ftt.resources.zos.model.MVSFileResource;
import com.ibm.ftt.resources.zos.zosphysical.IZOSDataSet;
import com.ibm.ftt.resources.zos.zosphysical.IZOSDataSetMember;
import com.ibm.ftt.resources.zos.zosphysical.IZOSGenerationDataGroup;
import com.ibm.ftt.resources.zos.zosphysical.IZOSPartitionedDataSet;
import com.ibm.ftt.resources.zos.zosphysical.IZOSSequentialDataSet;
import com.ibm.ftt.resources.zos.zosphysical.ZOSResource;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.PDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemSignonInformation;

public class MVSFileResourceAF
implements IAdapterFactory {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(MVSFileResourceAF.class);

    public Class<?>[] getAdapterList() {
        return new Class[]{IZRL.class, DataSet.class, Member.class, PDHost.class};
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        logger.trace((Object)("RDz Adapter requested to adapt to " + String.valueOf(adapterType)));
        if (adaptableObject instanceof MVSFileResource) {
            MVSFileResource mfr = (MVSFileResource)adaptableObject;
            if (adapterType.equals(PDHost.class)) {
                return MVSFileResourceAF.getHost(mfr);
            }
            if (IZRL.class.isAssignableFrom(adapterType)) {
                IZRL zrl = MVSFileResourceAF.convertToZrl(mfr);
                if (zrl != null && !adapterType.isAssignableFrom(zrl.getClass())) {
                    logger.trace((Object)("RDz Adapter was able to adapt to ZRL, but got " + zrl.getClass().getCanonicalName() + " while was expecting " + adapterType.getCanonicalName()));
                    zrl = null;
                }
                return zrl;
            }
        }
        return null;
    }

    private static IPDHost getHost(MVSFileResource mfr) {
        IHost rdzHost = mfr.getSystemConnection();
        if (rdzHost == null) {
            logger.error((Object)"Cannot find host information from selected resource");
            throw new RuntimeException(Messages.RSEObjectHandler_NO_HOST);
        }
        String encoding = null;
        try {
            encoding = ((com.ibm.ftt.resources.zos.zosphysical.impl.ZOSResource)mfr.getZOSResource()).getMvsResource().getHostCp();
        }
        catch (Throwable e) {
            logger.debug((Object)("Couldn't get encoding from RDz MVSFileResource: " + String.valueOf(mfr)), e);
        }
        SystemSignonInformation ssi = ((zOSSystem)rdzHost).getUserInformation();
        return AdapterUtils.getFMHost(rdzHost, ssi, encoding);
    }

    private static IZRL convertToZrl(MVSFileResource mfr) {
        ZOSResource rdzResource = mfr.getZOSResource();
        String fullpath = rdzResource.getFullPath().toString();
        IPDHost fmHost = MVSFileResourceAF.getHost(mfr);
        String hostEncoding = rdzResource.getMVSFileMapping().getHostCodePage();
        String extension = "";
        if (rdzResource.getMVSFileMappingOverride() != null && rdzResource.getMVSFileMappingOverride().getLocalFileExtension() != null && rdzResource.getMVSFileMappingOverride().getLocalFileExtension().length() > 0) {
            extension = rdzResource.getMVSFileMapping().getLocalFileExtension();
        } else if (rdzResource.getMVSFileMapping() != null && rdzResource.getMVSFileMapping().getLocalFileExtension() != null && rdzResource.getMVSFileMapping().getLocalFileExtension().length() > 0) {
            extension = rdzResource.getMVSFileMapping().getLocalFileExtension();
        }
        int index = fullpath.indexOf(47);
        DataSetOrMember parsed = null;
        IZOSDataSet rdzDataSet = null;
        if (rdzResource instanceof IZOSDataSetMember) {
            String ds = fullpath.substring(0, index);
            String member = fullpath.substring(index + 1);
            if (extension.length() > 0 && member.endsWith(extension)) {
                member = member.substring(0, member.length() - extension.length() - 1);
            }
            rdzDataSet = (IZOSDataSet)rdzResource.getParent();
            String aName = ds + "(" + member + ")";
            parsed = Member.parse((IPDHost)fmHost, (String)aName);
        } else if (rdzResource instanceof IZOSDataSet) {
            String ds = fullpath;
            if (extension.length() > 0 && ds.endsWith(extension)) {
                ds = ds.substring(0, ds.length() - extension.length() - 1);
            }
            rdzDataSet = (IZOSDataSet)rdzResource;
            ds = rdzDataSet.getName();
            parsed = Member.parse((IPDHost)fmHost, (String)ds);
        } else {
            logger.debug((Object)("rdz resource not recognised: " + String.valueOf(rdzResource)));
        }
        if (parsed != null) {
            if (rdzDataSet instanceof IZOSPartitionedDataSet) {
                parsed.asDataSet().setType(DataSetType.PDS);
            } else if (rdzDataSet instanceof IZOSGenerationDataGroup) {
                parsed.asDataSet().setType(DataSetType.GDG);
            } else if (rdzDataSet instanceof IZOSSequentialDataSet) {
                parsed.asDataSet().setType(DataSetType.PS);
            }
        }
        return parsed;
    }
}

