/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ext.rse.adapter;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.ext.rse.adapter.AdapterUtils;
import com.ibm.etools.fm.ui.util.ZrlLoaderDialogUtils;
import com.ibm.etools.zos.system.zOSSystem;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.PDHost;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;

public class DStoreFileResourceAF
implements IAdapterFactory {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(DStoreFileResourceAF.class);

    public Class<?>[] getAdapterList() {
        return new Class[]{IZRL.class, UssFile.class, PDHost.class};
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IRemoteFile) {
            IRemoteFile rf = (IRemoteFile)adaptableObject;
            if (adapterType.equals(PDHost.class)) {
                return DStoreFileResourceAF.getHost(rf);
            }
            if (IZRL.class.isAssignableFrom(adapterType)) {
                IZRL zrl = DStoreFileResourceAF.convertToZrl(rf);
                if (zrl != null && !adapterType.isAssignableFrom(zrl.getClass())) {
                    zrl = null;
                }
                return zrl;
            }
        }
        return null;
    }

    private static IPDHost getHost(IRemoteFile rf) {
        IHost rdzHost = rf.getHost();
        if (rdzHost == null || !(rdzHost instanceof zOSSystem)) {
            String msg = MessageFormat.format(Messages.RSEObjectHandler_INVALID_HOST, rdzHost != null ? rdzHost.getName() : "");
            PDDialogs.openInfoThreadSafe((String)msg);
            return null;
        }
        String encoding = null;
        try {
            encoding = rf.getEncoding();
        }
        catch (Exception e) {
            logger.debug((Object)("Couldn't get encoding from RDz DStoreFileResource: " + String.valueOf(rf)), (Throwable)e);
        }
        SystemSignonInformation ssi = ((zOSSystem)rdzHost).getUserInformation();
        return AdapterUtils.getFMHost(rdzHost, ssi, encoding);
    }

    private static IZRL convertToZrl(IRemoteFile rf) {
        IPDHost fmHost = DStoreFileResourceAF.getHost(rf);
        if (fmHost == null) {
            return null;
        }
        String encoding = rf.getEncoding();
        String fileName = rf.getAbsolutePath();
        try {
            fileName = ZrlLoaderDialogUtils.getNameForProcessing((String)fileName, (String)encoding, (HostType)fmHost.getHostType());
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("Unsupported encoding value specified: " + encoding));
        }
        UssFile aFile = UssFile.parse((IPDHost)fmHost, (String)fileName);
        return aFile;
    }
}

