/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ext.rse.adapter;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.zos.system.zOSSystem;
import com.ibm.pdtools.common.component.core.base.auth.AuthenticationFrameworkUtilitiesImp;
import com.ibm.pdtools.common.component.core.comms.ConnectionUtilities;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.PDHost;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.PDToolsCommonServerClientJhost;
import com.ibm.pdtools.common.component.jhost.comms.HostDetails;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.ui.util.AuthTokenManager;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.shells.ui.RemoteCommandHelpers;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.ShellServiceSubSystem;

public class AdapterUtils {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(AdapterUtils.class);
    private static final String PORT_VALUE_ENVVAR_NAME = "PD_SERVER_PORT";

    public static IPDHost getFMHost(IHost rdzHost, SystemSignonInformation ssi, String encoding) {
        String systemDescription = rdzHost.getAliasName() != null ? MessageFormat.format(Messages.RSEObjectHandler_RDZ_DESC_WITH_ALIAS, rdzHost.getAliasName()) : Messages.RSEObjectHandler_RDZ_DESC;
        int portNo = AdapterUtils.getFMPort(rdzHost);
        HostDetails aHostDetails = ConnectionUtilities.getConnection((String)systemDescription, (String)rdzHost.getHostName(), (int)portNo, (String)ssi.getUserId().toUpperCase(), (String)ssi.getPassword());
        PDHost fmHost = PDHost.create((String)aHostDetails.getHostID(), (String)rdzHost.getHostName(), (int)portNo);
        fmHost = (IPDHost)RegistryLocator.instance().getHostRegistry().findOrAdd((Object)fmHost);
        fmHost.setDescription(systemDescription);
        fmHost.setCodePage(encoding);
        IHost[] hosts = RSECorePlugin.getDefault().getSystemRegistry().getHosts();
        boolean bypassLogin = FMUIPlugin.getDefault().getPreferenceStore().getBoolean("fm.bypass.login");
        IHost[] iHostArray = hosts;
        int n = hosts.length;
        int n2 = 0;
        while (n2 < n) {
            IHost nonSelectedHostsinRSEView = iHostArray[n2];
            if (nonSelectedHostsinRSEView instanceof zOSSystem && !nonSelectedHostsinRSEView.getHostName().equals(rdzHost.getHostName()) && !bypassLogin) {
                systemDescription = nonSelectedHostsinRSEView.getAliasName() != null ? MessageFormat.format(Messages.RSEObjectHandler_RDZ_DESC_WITH_ALIAS, nonSelectedHostsinRSEView.getAliasName()) : Messages.RSEObjectHandler_RDZ_DESC;
                try {
                    portNo = AdapterUtils.getFMPort(nonSelectedHostsinRSEView);
                }
                catch (Exception ex) {
                    if (ex instanceof NullPointerException) {
                        PDDialogs.openInfoThreadSafe((String)Messages.TE_infoTabName, (String)Messages.RSEObjectHandler_LOGIN_INFO_MSG);
                    }
                    try {
                        nonSelectedHostsinRSEView.getConnectorServices()[0].clearCredentials();
                        nonSelectedHostsinRSEView.getConnectorServices()[0].connect((IProgressMonitor)new NullProgressMonitor());
                        portNo = AdapterUtils.getFMPort(nonSelectedHostsinRSEView);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ssi = ((zOSSystem)nonSelectedHostsinRSEView).getUserInformation();
                if (ssi.getPassword() != null && ssi.getUserId() != null) {
                    HostDetails otherHostDetails = ConnectionUtilities.getConnection((String)systemDescription, (String)nonSelectedHostsinRSEView.getHostName(), (int)portNo, (String)ssi.getUserId().toUpperCase(), (String)ssi.getPassword());
                    PDHost otherHost = PDHost.create((String)otherHostDetails.getHostID(), (String)nonSelectedHostsinRSEView.getHostName(), (int)portNo);
                    if (!RegistryLocator.instance().getHostRegistry().contains((Object)otherHost)) {
                        otherHost = (IPDHost)RegistryLocator.instance().getHostRegistry().findOrAdd((Object)otherHost);
                        otherHost.setDescription(systemDescription);
                        otherHost.setCodePage(encoding);
                    }
                }
            }
            ++n2;
        }
        if (PDToolsCommonServerClientJhost.getAuthTokenManager().isConnectionUsingTokens(fmHost.getHostName(), Integer.valueOf(fmHost.getPort()))) {
            try {
                if (!AuthTokenManager.getInstance().hasAuthToken(aHostDetails, ssi.getUserId(), PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)new NullProgressMonitor()))) {
                    AuthenticationFrameworkUtilitiesImp.clearPassword((String)"com.ibm.pdtools.comms.cics.category", (String)aHostDetails.getHostID());
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return fmHost;
    }

    private static int getFMPort(IHost rdzHost) {
        String portVariable = null;
        ShellServiceSubSystem shellSubSystem = null;
        IRemoteCmdSubSystem[] systems = RemoteCommandHelpers.getCmdSubSystems((IHost)rdzHost);
        int i = 0;
        while (i < systems.length) {
            if (systems[i] instanceof ShellServiceSubSystem) {
                shellSubSystem = (ShellServiceSubSystem)systems[i];
                break;
            }
            ++i;
        }
        if (shellSubSystem == null) {
            logger.error((Object)"Can't determine FM server port - was not able to find a ShellServiceSubSystem on the provided host");
            throw new RuntimeException(Messages.RSEObjectHandler_NO_SUBSYSTEM);
        }
        List variables = shellSubSystem.getHostEnvironmentVariables();
        int i2 = 0;
        while (i2 < variables.size()) {
            String variable = (String)variables.get(i2);
            if (variable.startsWith(PORT_VALUE_ENVVAR_NAME)) {
                portVariable = variable;
                break;
            }
            ++i2;
        }
        if (portVariable == null) {
            logger.error((Object)("Can't determine Common Server server port for " + rdzHost.getName() + " - no environment variable found called PD_SERVER_PORT"));
            throw new RuntimeException(MessageFormat.format(Messages.RSEObjectHandler_NO_PORT, rdzHost.getName(), PORT_VALUE_ENVVAR_NAME));
        }
        try {
            String portNumber = portVariable.substring(portVariable.indexOf("=") + 1).trim();
            return Integer.parseInt(portNumber);
        }
        catch (NumberFormatException e) {
            logger.error((Object)("Can't parse Common Server port for " + rdzHost.getName() + " from host environment variable configuration; looking for [PD_SERVER_PORT], found [" + portVariable + "]"));
            throw new RuntimeException(MessageFormat.format(Messages.RSEObjectHandler_PORT_EX, rdzHost.getName(), PORT_VALUE_ENVVAR_NAME, portVariable), e);
        }
    }
}

