/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.lookup.view.internal.tree;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.CategoryTreeNode;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.CodeExplanationUser;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.RootTreeNote;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.TypeTreeNode;
import com.ibm.pdtools.common.component.lookup.view.sax.LookupAttributeTagNames;
import com.ibm.pdtools.common.component.ui.util.XMLMementoUtils;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class UserMessageSerializer {
    private static final PDLogger logger = PDLogger.get(UserMessageSerializer.class);
    private static final String MESSAGES = "MESSAGES";
    private static final String MESSAGE = "MESSAGE";
    private static final String MSGLINE = "MSGLINE";
    private static final String USER_MESSAGES = "user-messages";
    private static final String CATEGORY = "category";
    private static final String EXPLANATION = "explanation";
    private static final String TYPE = "type";
    private static final String CODE = "code";
    private static final String NAME = "name";

    public boolean deserialize(IFile file, RootTreeNote rootNode) {
        Objects.requireNonNull(file);
        Objects.requireNonNull(rootNode);
        boolean addedUserMessage = false;
        TypeTreeNode userNode = rootNode.addOrGetChildNode(LookupAttributeTagNames.USER);
        userNode.removeAllChildren();
        XMLMemento document = XMLMementoUtils.loadMementoFromFileShowErrors((File)file.getRawLocation().toFile());
        if (document != null) {
            IMemento[] categories;
            IMemento[] iMementoArray = categories = document.getChildren(CATEGORY);
            int n = categories.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento[] explanations;
                IMemento category = iMementoArray[n2];
                String categoryName = category.getString(NAME);
                CategoryTreeNode categoryNode = userNode.addOrGetChildNode(categoryName);
                IMemento[] iMementoArray2 = explanations = category.getChildren(EXPLANATION);
                int n3 = explanations.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemento explanation = iMementoArray2[n4];
                    categoryNode.addOrGetChildNode(new CodeExplanationUser(explanation.getString(CODE), explanation.getTextData()));
                    addedUserMessage = true;
                    ++n4;
                }
                ++n2;
            }
        }
        if (!addedUserMessage) {
            rootNode.removeChild(userNode);
        }
        return addedUserMessage;
    }

    public int serialize(XMLMemento hostDocument, IFile file) {
        try {
            Response response = UserMessageSerializer.hostXML2CachedXML(hostDocument);
            if (response != null) {
                XMLMementoUtils.saveXMLMementoToFile((XMLMemento)response.getMemento(), (File)file.getRawLocation().toFile());
                return response.getCount();
            }
            logger.error((Object)("Exception occurred while caching: " + file.getRawLocation().toString()));
        }
        catch (IOException e) {
            logger.error((Object)("Exception occurred while caching: " + file.getRawLocation().toString()), (Throwable)e);
        }
        return 0;
    }

    private static Response hostXML2CachedXML(XMLMemento hostDocument) {
        IMemento messagesHolder = hostDocument.getChild(MESSAGES);
        if (messagesHolder != null) {
            IMemento[] messageNodes = messagesHolder.getChildren(MESSAGE);
            XMLMemento cachedRootNode = XMLMemento.createWriteRoot((String)USER_MESSAGES);
            int size = 0;
            IMemento[] iMementoArray = messageNodes;
            int n = messageNodes.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento messageNode = iMementoArray[n2];
                String name = UserMessageSerializer.sanitizeType(messageNode.getString(TYPE));
                String code = UserMessageSerializer.sanitizeCode(messageNode.getString(CODE));
                IMemento categoryNode = UserMessageSerializer.findCategory(cachedRootNode, name);
                if (categoryNode == null) {
                    categoryNode = cachedRootNode.createChild(CATEGORY);
                    categoryNode.putString(NAME, name);
                }
                IMemento explanationNode = categoryNode.createChild(EXPLANATION);
                explanationNode.putString(CODE, code);
                explanationNode.putTextData(UserMessageSerializer.sanitizeExplanationFromHost(messageNode));
                ++size;
                ++n2;
            }
            return new Response(size, cachedRootNode);
        }
        return null;
    }

    private static IMemento findCategory(XMLMemento node, String name) {
        IMemento[] categoryNodes;
        IMemento[] iMementoArray = categoryNodes = node.getChildren(CATEGORY);
        int n = categoryNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento categoryNode = iMementoArray[n2];
            if (categoryNode.getString(NAME).equals(name)) {
                return categoryNode;
            }
            ++n2;
        }
        return null;
    }

    private static String sanitizeExplanationFromHost(IMemento messageNode) {
        IMemento[] lineNodes;
        StringBuilder sb = new StringBuilder();
        IMemento[] iMementoArray = lineNodes = messageNode.getChildren(MSGLINE);
        int n = lineNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento lineNode = iMementoArray[n2];
            String text = lineNode.getTextData();
            if (text != null) {
                sb.append(text.trim());
            }
            sb.append('\n');
            ++n2;
        }
        return sb.toString();
    }

    /*
     * Exception decompiling
     */
    private static String sanitizeType(String string) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[5] lbl31 : CaseStatement: default:\u000a, @NONE, blocks:[5] lbl31 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String sanitizeCode(String string) {
        if (string.startsWith(".")) {
            string = string.substring(1);
        }
        return string;
    }

    private static class Response {
        private int count;
        private XMLMemento memento;

        Response(int count, XMLMemento memento) {
            this.count = count;
            this.memento = memento;
        }

        public int getCount() {
            return this.count;
        }

        public XMLMemento getMemento() {
            return this.memento;
        }
    }
}

