/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.lookup.view.internal.tree;

import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.lookup.view.LookedUpMessage;
import com.ibm.pdtools.common.component.lookup.view.LookupPreferencePage;
import com.ibm.pdtools.common.component.lookup.view.LookupView;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.AbstractCodeExplanation;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.AbstractCodeExplanationTreeNode;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.CategorizedUserCodeExplanations;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.CategoryTreeNode;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.CodeExplanationAbend;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.CodeExplanationMessage;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.CodeExplanationUser;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.GetMessagesFromContributors;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.RootTreeNote;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.TypeTreeNode;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.UserMessageSerializer;
import com.ibm.pdtools.common.component.lookup.view.sax.LookupAttributeTagNames;
import com.ibm.pdtools.common.component.lookup.view.sax.LookupDataParser;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.statushandlers.StatusManager;

public class LookupViewTree {
    private static final PDLogger logger = PDLogger.get(LookupViewTree.class);
    private RootTreeNote rootNote = new RootTreeNote();

    public LookupViewTree(IProgressMonitor monitor) {
        String nl = Platform.isRunning() ? Platform.getNL() : "en";
        String lookup = "nl" + File.separator + nl + File.separator + "lookup.xml";
        URL resource = LookupView.class.getResource(lookup);
        if (resource == null && (resource = LookupView.class.getResource("lookup.xml")) == null) {
            logger.error((Object)"Failed load messages.");
        }
        if (resource != null) {
            LookupDataParser.parseLookupData(this.rootNote, resource, monitor);
        }
    }

    private Collection<AbstractCodeExplanationTreeNode> loadDymamicMappings(final String searchTerm, final IProgressMonitor monitor) {
        Objects.requireNonNull(searchTerm, "Must provide a non-null searchTerm.");
        final ArrayList<AbstractCodeExplanationTreeNode> results = new ArrayList<AbstractCodeExplanationTreeNode>();
        if (Platform.isRunning() && LookupPreferencePage.isUserCodeExplanationProvidersEnabled()) {
            SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    results.addAll(LookupViewTree.this.convertToInternal(GetMessagesFromContributors.INSTANCE.search(searchTerm, monitor)));
                }

                public void handleException(Throwable t) {
                    PDLogger.get(this.getClass()).error((Object)"Errors occurred while loading contributed code explanations: ", t);
                }
            });
        }
        return results;
    }

    private Collection<AbstractCodeExplanationTreeNode> convertToInternal(Map<String, Map<String, String>> userMessages) {
        ArrayList<AbstractCodeExplanationTreeNode> results = new ArrayList<AbstractCodeExplanationTreeNode>();
        if (userMessages != null) {
            for (Map.Entry<String, Map<String, String>> messagesFromProvider : userMessages.entrySet()) {
                CategoryTreeNode userCategory = this.rootNote.addOrGetChildNode(LookupAttributeTagNames.USER).addOrGetChildNode(messagesFromProvider.getKey());
                for (Map.Entry<String, String> e : messagesFromProvider.getValue().entrySet()) {
                    userCategory.addOrGetChildNode(new CodeExplanationUser(e.getKey(), e.getValue()));
                }
                results.addAll(userCategory.getChildren());
            }
        }
        return results;
    }

    public Collection<AbstractCodeExplanationTreeNode> search(String searchString, boolean headless, boolean quotePatternOnErrors, IProgressMonitor monitor) {
        Objects.requireNonNull(searchString, "Please provide a non-null search term.");
        ArrayList<AbstractCodeExplanationTreeNode> search_results = new ArrayList<AbstractCodeExplanationTreeNode>();
        this.loadDymamicMappings(searchString, monitor);
        searchString = searchString.replaceAll("\\*", ".*");
        searchString = searchString.replaceAll("%", ".?");
        searchString = searchString.replace("(", "").replace(")", "");
        logger.trace((Object)searchString);
        searchString = searchString.toUpperCase();
        Pattern regex = LookupViewTree.compilePattern(searchString, headless, quotePatternOnErrors);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.RootNode_Searching, this.rootNote.getChildren().size());
        for (TypeTreeNode type : this.rootNote.getChildren()) {
            monitor.subTask(MessageFormat.format(Messages.LookupViewTree_Searching, type.getData()));
            for (AbstractCodeExplanationTreeNode abend : type.getAllMessages()) {
                if (regex.matcher(abend.getLabel()).matches() || regex.matcher(((AbstractCodeExplanation)abend.getData()).getCode()).matches() || ((AbstractCodeExplanation)abend.getData()).getCode().contains(searchString)) {
                    search_results.add(abend);
                }
                if (monitor.isCanceled()) break;
            }
            monitor.worked(1);
        }
        return search_results;
    }

    private static Pattern compilePattern(String searchString, boolean headless, boolean quotePatternOnErrors) {
        try {
            return Pattern.compile(searchString, 2);
        }
        catch (PatternSyntaxException e) {
            String quoted = Pattern.quote(searchString);
            logger.error((Object)MessageFormat.format("An invalid regular expression was specified:\n{0}\n Searching for \"{1}\" instead.", e.getMessage(), searchString));
            if (!headless) {
                PDDialogs.openErrorThreadSafe((String)Messages.RootNode_0, (String)MessageFormat.format(Messages.RootNode_1, e.getMessage(), searchString));
            }
            return Pattern.compile(quoted, 2);
        }
    }

    public AbstractCodeExplanationTreeNode addExplanation(LookedUpMessage message) {
        TypeTreeNode typeNode = this.rootNote.addOrGetChildNode(message.getType().messageType());
        CategoryTreeNode categoryNode = typeNode.addOrGetChildNode(message.getType().getCategory());
        switch (message.getType()) {
            case MESSAGE: {
                return categoryNode.addOrGetChildNode(new CodeExplanationMessage(message.getCode(), message.getDescription()));
            }
        }
        return categoryNode.addOrGetChildNode(new CodeExplanationAbend(message.getCode(), message.getDescription()));
    }

    public RootTreeNote reloadUserCodeExplanations() {
        TypeTreeNode user = this.rootNote.addOrGetChildNode(LookupAttributeTagNames.USER);
        user.removeAllChildren();
        this.rootNote.removeChild(user);
        if (Platform.isRunning() && LookupPreferencePage.isUserCodeExplanationProvidersEnabled()) {
            SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    CategorizedUserCodeExplanations staticCodeExplanations = GetMessagesFromContributors.INSTANCE.getStaticCodeExplanations(true);
                    if (staticCodeExplanations.iterator().hasNext()) {
                        TypeTreeNode userTypeNode = LookupViewTree.this.rootNote.addOrGetChildNode(LookupAttributeTagNames.USER);
                        for (Map.Entry<String, Collection<CodeExplanationUser>> entry : staticCodeExplanations) {
                            CategoryTreeNode categoryNode = userTypeNode.addOrGetChildNode(entry.getKey());
                            for (CodeExplanationUser m : entry.getValue()) {
                                categoryNode.addOrGetChildNode(m);
                            }
                        }
                    }
                }

                public void handleException(Throwable t) {
                    PDLogger.get(this.getClass()).error((Object)"Errors occurred while loading contributed code explanations: ", t);
                    StatusManager.getManager().handle((IStatus)new Status(4, "com.ibm.pdtools.common.component.lookup", t.getMessage()));
                }
            });
        } else {
            logger.info((Object)"User code explanations are only available when eclipse is running.");
        }
        return this.rootNote;
    }

    public boolean addUserExplanationsFromCachedFile(IFile cachedMessageFile) {
        return new UserMessageSerializer().deserialize(cachedMessageFile, this.rootNote);
    }
}

