/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.lookup.view.internal.tree;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.CodeExplanationUser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

enum JSONLoader {
    INSTANCE;

    private ObjectMapper mapper = new ObjectMapper();

    private JSONLoader() {
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.mapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS});
        this.mapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES});
        this.mapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES});
        this.mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.mapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
    }

    <K, V> String serializeMap(Map<K, V> map) throws IOException {
        return this.mapper.writeValueAsString(map);
    }

    <K, V> Map<K, V> deserializeMap(String jsonMapString) throws IOException {
        return (Map)this.mapper.readValue(jsonMapString, new TypeReference<Map<K, V>>(){});
    }

    <K, V> Map<K, V> deserializeMap(InputStream is) throws IOException {
        return (Map)this.mapper.readValue(is, new TypeReference<Map<K, V>>(){});
    }

    Collection<CodeExplanationUser> load(InputStream is) throws IOException {
        ArrayList<CodeExplanationUser> mappings = new ArrayList<CodeExplanationUser>();
        for (Map.Entry e : this.deserializeMap(is).entrySet()) {
            mappings.add(new CodeExplanationUser((String)e.getKey(), (String)e.getValue()));
        }
        return mappings;
    }
}

