/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.lookup.view.internal.tree;

import com.ibm.pdtools.common.component.lookup.view.internal.tree.CategorizedUserCodeExplanations;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.CodeExplanationUser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class IDIHUSRMLoader {
    private static final Pattern explanationMatcher = Pattern.compile(":(msg|abend|misc)\\.(.*)");
    private static final Pattern plusPattern = Pattern.compile("\\++(:(msg|abend|misc)\\..*)");

    IDIHUSRMLoader() {
    }

    static CategorizedUserCodeExplanations loadFAUserCodeExplanations(InputStream is) throws IOException {
        CategorizedUserCodeExplanations categorizedUserCodeExplanations = new CategorizedUserCodeExplanations();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String line;
            String code = "";
            String type = "";
            StringBuilder explanation = new StringBuilder();
            while ((line = br.readLine()) != null) {
                Matcher codeMatcher = explanationMatcher.matcher(line = IDIHUSRMLoader.removeLeadingPluses(line));
                if (codeMatcher.matches()) {
                    if (!code.isEmpty()) {
                        categorizedUserCodeExplanations.add(type, Arrays.asList(new CodeExplanationUser(code, explanation.toString())));
                    }
                    type = codeMatcher.group(1);
                    code = codeMatcher.group(2);
                    explanation = new StringBuilder();
                    continue;
                }
                explanation.append(line).append(System.lineSeparator());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return categorizedUserCodeExplanations;
    }

    private static String removeLeadingPluses(String line) {
        Matcher rawMatcher = plusPattern.matcher(line);
        if (rawMatcher.matches() && rawMatcher.find()) {
            line = rawMatcher.group(1);
        }
        return line;
    }
}

