/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.lookup.view.internal.tree;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.lookup.Messages;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.CSVLoader;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.CategorizedUserCodeExplanations;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.CodeExplanationUser;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.IDIHUSRMLoader;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.JSONLoader;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.PropertyLoader;
import common.component.lookup.extension.api.IMessageExplanationProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.statushandlers.StatusManager;

public enum GetMessagesFromContributors {
    INSTANCE;

    private static final PDLogger logger;
    private static final String ID_ELEMENTS = "pdtools.user.code.explanation.providers";
    private final Map<String, IMessageExplanationProvider> providers = new HashMap<String, IMessageExplanationProvider>();
    private final Collection<UserCodeExplanationProviderDescription> codeExplanationProviderDescriptions = new ArrayList<UserCodeExplanationProviderDescription>();
    private CategorizedUserCodeExplanations staticCodeExplanations;

    static {
        logger = PDLogger.get(GetMessagesFromContributors.class);
    }

    public CategorizedUserCodeExplanations getStaticCodeExplanations(boolean reloadFirst) {
        if (reloadFirst) {
            this.loadContributedCodeExplanations();
        }
        return this.staticCodeExplanations;
    }

    private void loadContributedCodeExplanations() {
        block36: {
            this.staticCodeExplanations = new CategorizedUserCodeExplanations();
            this.codeExplanationProviderDescriptions.clear();
            IConfigurationElement[] elements = RegistryFactory.getRegistry().getConfigurationElementsFor(ID_ELEMENTS);
            if (elements == null) break block36;
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement elem = iConfigurationElementArray[n2];
                String file = elem.getAttribute("file");
                String bundleId = elem.getDeclaringExtension().getContributor().getName();
                switch (elem.getName()) {
                    case "dynamicProvider": {
                        Object obj = GetMessagesFromContributors.createExtension(elem, "class");
                        if (!(obj instanceof IMessageExplanationProvider)) break;
                        this.providers.put(elem.getAttribute("category"), (IMessageExplanationProvider)obj);
                        this.codeExplanationProviderDescriptions.add(new UserCodeExplanationProviderDescription(Messages.GetMessagesFromContributors_Dynamic, elem.getAttribute("class"), elem.getAttribute("category"), file, bundleId));
                        break;
                    }
                    case "staticProvider": {
                        FileInputStream fis;
                        Object var11_15;
                        try {
                            Throwable throwable = null;
                            var11_15 = null;
                            try {
                                fis = new FileInputStream(this.loadFromFile(bundleId, file));
                                try {
                                    String providerType = elem.getAttribute("type");
                                    Collection<CodeExplanationUser> loaded = StaticUserCodeExplanationFileLoader.valueOf(providerType).load(fis);
                                    this.staticCodeExplanations.add(elem.getAttribute("category"), loaded);
                                    this.codeExplanationProviderDescriptions.add(new UserCodeExplanationProviderDescription(MessageFormat.format(Messages.GetMessagesFromContributors_staticX, providerType), "", elem.getAttribute("category"), this.loadFromFile(bundleId, file).getAbsolutePath(), bundleId, loaded.size()));
                                }
                                finally {
                                    if (fis != null) {
                                        ((InputStream)fis).close();
                                    }
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException | InvalidRegistryObjectException e) {
                            StatusManager.getManager().handle((IStatus)new Status(4, "com.ibm.pdtools.common.component.lookup", MessageFormat.format(Messages.GetMessagesFromContributors_errorLoading, file), e), 3);
                        }
                        break;
                    }
                    case "IDIHUSRMProvider": {
                        FileInputStream fis;
                        Object var11_15;
                        try {
                            Throwable e = null;
                            var11_15 = null;
                            try {
                                fis = new FileInputStream(this.loadFromFile(bundleId, file));
                                try {
                                    this.staticCodeExplanations.addAll(IDIHUSRMLoader.loadFAUserCodeExplanations(fis));
                                    this.codeExplanationProviderDescriptions.add(new UserCodeExplanationProviderDescription(Messages.GetMessagesFromContributors_staticIDIHUSRM, "", Messages.GetMessagesFromContributors_Any, this.loadFromFile(bundleId, file).getAbsolutePath(), bundleId));
                                }
                                finally {
                                    if (fis != null) {
                                        ((InputStream)fis).close();
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                if (e == null) {
                                    e = throwable;
                                } else if (e != throwable) {
                                    e.addSuppressed(throwable);
                                }
                                throw e;
                            }
                        }
                        catch (IOException | InvalidRegistryObjectException e) {
                            StatusManager.getManager().handle((IStatus)new Status(4, "com.ibm.pdtools.common.component.lookup", MessageFormat.format(Messages.GetMessagesFromContributors_errorLoading, file), e), 3);
                        }
                        break;
                    }
                    default: {
                        StatusManager.getManager().handle((IStatus)new Status(4, "com.ibm.pdtools.common.component.lookup", MessageFormat.format(Messages.GetMessagesFromContributors_typeNotSupported, elem.getName())), 3);
                    }
                }
                ++n2;
            }
        }
    }

    private static Object createExtension(IConfigurationElement elem, String elementName) {
        Objects.requireNonNull(elem, "Must provide a non-null IConfigurationElement elem.");
        Objects.requireNonNull(elementName, "Must provide a non-null elementName string.");
        try {
            return elem.createExecutableExtension(elementName);
        }
        catch (CoreException e) {
            PDLogger.get(GetMessagesFromContributors.class).error((Object)"An error occurred while attempting to load an ", (Throwable)e);
            return null;
        }
    }

    public Map<String, Map<String, String>> search(final String s, final IProgressMonitor monitor) {
        Objects.requireNonNull(s, "Must provide a non-null search string.");
        final HashMap<String, Map<String, String>> providerCodeExplanations = new HashMap<String, Map<String, String>>();
        for (final Map.Entry<String, IMessageExplanationProvider> provider : this.providers.entrySet()) {
            SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    Map<String, String> messages = ((IMessageExplanationProvider)provider.getValue()).provideMessagesForId(s, (IProgressMonitor)(monitor == null ? new NullProgressMonitor() : monitor));
                    if (messages != null && !messages.isEmpty()) {
                        providerCodeExplanations.put((String)provider.getKey(), messages);
                    }
                }

                public void handleException(Throwable t) {
                    logger.error((Object)("An error occurred while requesting message from  " + (String)provider.getKey()), t);
                }
            });
        }
        return providerCodeExplanations;
    }

    private File loadFromFile(String bundleId, String file) {
        Objects.requireNonNull(file, "Please provide a non-null file.");
        try {
            URL entry = Platform.getBundle((String)bundleId).getEntry(file);
            return new File(FileLocator.toFileURL((URL)entry).getFile());
        }
        catch (IOException e) {
            PDLogger.get(((Object)((Object)this)).getClass()).error((Object)"Failure to create file based on path: ", (Throwable)e);
            return null;
        }
    }

    public Collection<UserCodeExplanationProviderDescription> getCodeExplanationProviderDescriptions() {
        if (this.codeExplanationProviderDescriptions.isEmpty()) {
            this.loadContributedCodeExplanations();
        }
        return this.codeExplanationProviderDescriptions;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum StaticUserCodeExplanationFileLoader {
        PROPERTIES{

            @Override
            Collection<CodeExplanationUser> load(InputStream is) throws IOException {
                return PropertyLoader.loadAsProperties(is, false);
            }
        }
        ,
        PROPERTIES_XML{

            @Override
            Collection<CodeExplanationUser> load(InputStream is) throws IOException {
                return PropertyLoader.loadAsProperties(is, true);
            }
        }
        ,
        JSON{

            @Override
            Collection<CodeExplanationUser> load(InputStream is) throws IOException {
                return JSONLoader.INSTANCE.load(is);
            }
        }
        ,
        CSV{

            @Override
            Collection<CodeExplanationUser> load(InputStream is) throws IOException {
                return CSVLoader.loadAsCSV(is);
            }
        };


        abstract Collection<CodeExplanationUser> load(InputStream var1) throws IOException;
    }

    public static class UserCodeExplanationProviderDescription {
        private final String type;
        private final String clazz;
        private final String category;
        private final String file;
        private final String bundleId;
        private final int msgCount;

        public UserCodeExplanationProviderDescription(String type, String clazz, String category, String file, String bundleId) {
            this(type, clazz, category, file, bundleId, 0);
        }

        public UserCodeExplanationProviderDescription(String type, String clazz, String category, String file, String bundleId, int msgCount) {
            this.type = type;
            this.clazz = clazz;
            this.category = category;
            this.file = file;
            this.bundleId = bundleId;
            this.msgCount = msgCount;
            PDLogger.get(this.getClass()).trace((Object)("Loaded user message code source: " + this.toString()));
        }

        public String getType() {
            return this.type;
        }

        public String getCategory() {
            return this.category;
        }

        public String getFileOrClass() {
            if (this.file != null) {
                return this.getBundleId() + this.file;
            }
            return this.getBundleId() + this.clazz;
        }

        public String getBundleId() {
            return "bundle://" + this.bundleId + "/";
        }

        public String toString() {
            return "UserCodeExplanationProviderDescription [" + (String)(this.type != null ? "type=" + this.type + ", " : "") + (String)(this.clazz != null ? "clazz=" + this.clazz + ", " : "") + (String)(this.category != null ? "category=" + this.category + ", " : "") + (String)(this.file != null ? "file=" + this.file + ", " : "") + (String)(this.bundleId != null ? "bundleId=" + this.bundleId + ", " : "") + "msgCount=" + this.msgCount + "]";
        }
    }
}

