/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.lookup.view.internal.tree;

import com.ibm.pdtools.common.component.lookup.view.internal.tree.AbstractCodeExplanationTreeNode;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.CodeExplanationAbend;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.CodeExplanationAbendTreeNode;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.CodeExplanationMessage;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.CodeExplanationMessageTreeNode;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.CodeExplanationOther;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.CodeExplanationOtherTreeNode;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.CodeExplanationUser;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.CodeExplanationUserTreeNode;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.TreeNode;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.TypeTreeNode;
import com.ibm.pdtools.common.component.lookup.view.sax.LookupAttributeTagNames;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Objects;

public class CategoryTreeNode
extends TreeNode<TypeTreeNode, String, AbstractCodeExplanationTreeNode> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public CategoryTreeNode(TypeTreeNode parent, String categoryName) {
        super(Objects.requireNonNull(parent, "Must provide a non-null parent 'type' node."), Objects.requireNonNull(categoryName, "Must provide a non-null categoryName."), new ArrayList());
    }

    public AbstractCodeExplanationTreeNode addOrGetChildNode(CodeExplanationAbend type) {
        return this.addOrGet(new CodeExplanationAbendTreeNode(this, type));
    }

    public AbstractCodeExplanationTreeNode addOrGetChildNode(CodeExplanationMessage type) {
        return this.addOrGet(new CodeExplanationMessageTreeNode(this, type));
    }

    public AbstractCodeExplanationTreeNode addOrGetChildNode(CodeExplanationOther type) {
        return this.addOrGet(new CodeExplanationOtherTreeNode(this, type));
    }

    public AbstractCodeExplanationTreeNode addOrGetChildNode(CodeExplanationUser type) {
        return this.addOrGet(new CodeExplanationUserTreeNode(this, type));
    }

    public static String getCategoryFromId(LookupAttributeTagNames type, String id) throws IllegalArgumentException, NullPointerException {
        Objects.requireNonNull(type, "Must provide non-null type.");
        Objects.requireNonNull(id, "Must provide non-null id.");
        if (id.isEmpty()) {
            throw new IllegalArgumentException(MessageFormat.format("id must be specified. (type: {0} id: {1}", new Object[]{type, id}));
        }
        switch (type) {
            case OTHER: {
                return id.substring(0, id.lastIndexOf("_"));
            }
            case ABEND: {
                return id.split("_")[1];
            }
            case MESSAGE: {
                return id.split("_")[1].substring(0, 3);
            }
            case USER: {
                return id;
            }
        }
        throw new IllegalArgumentException("TODO: implement handling of " + String.valueOf((Object)type));
    }
}

