/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.lookup.view;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.lookup.Messages;
import com.ibm.pdtools.common.component.lookup.view.LookupPreferencePage;
import com.ibm.pdtools.common.component.ui.util.ControlHelpers;
import com.ibm.pdtools.common.component.ui.util.PDSafeUIRunner;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.widgets.Control;

public class LookupViewRemoteSearchSupport {
    private static final PDLogger logger = PDLogger.get(LookupViewRemoteSearchSupport.class);

    private static boolean ping(String url, int timeout) {
        url = url.replaceFirst("^https", "http");
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
            connection.setRequestMethod("HEAD");
            int responseCode = connection.getResponseCode();
            return 200 <= responseCode && responseCode <= 399;
        }
        catch (IOException exception) {
            logger.trace((Object)exception.getMessage(), exception.getCause());
            return false;
        }
    }

    public static void searchFromStringInBrowser(final Browser browser, final ProgressIndicator indicator, final String term) {
        Job j = new Job(Messages.LookupViewRemoteSearchSupport_0){

            public boolean belongsTo(Object family) {
                return browser == family;
            }

            public IStatus run(IProgressMonitor monitor) {
                if (LookupPreferencePage.isRemoteSearchEnabled()) {
                    String encodedTerm = LookupViewRemoteSearchSupport.urlEncode(LookupViewRemoteSearchSupport.removePatternQuoting(term));
                    String searchUrl = LookupPreferencePage.getRemoteSearchURL() + encodedTerm;
                    if (encodedTerm != null) {
                        if (LookupViewRemoteSearchSupport.ping(searchUrl, 1000) && !browser.isDisposed() && !indicator.isDisposed() && !monitor.isCanceled()) {
                            LookupViewRemoteSearchSupport.loadUrlWithProgress(browser, indicator, searchUrl);
                        } else {
                            ControlHelpers.setTextAsync((Browser)browser, (String)(Messages.LookupViewRemoteSearchSupport_1 + MessageFormat.format("<p><a href=\"{0}\">{1}</a>", searchUrl, searchUrl)));
                        }
                    } else {
                        ControlHelpers.setTextAsync((Browser)browser, (String)(Messages.LookupViewRemoteSearchSupport_1 + MessageFormat.format("<p><a href=\"{0}\">{1}</a>", searchUrl, searchUrl)));
                    }
                } else {
                    ControlHelpers.setTextAsync((Browser)browser, (String)Messages.LookupViewRemoteSearchSupport_3);
                }
                return Status.OK_STATUS;
            }
        };
        j.schedule();
    }

    private static void loadUrlWithProgress(final Browser browser, final ProgressIndicator indicator, final String searchUrl) {
        Objects.requireNonNull(browser, "Please provide a non-null browser.");
        Objects.requireNonNull(indicator, "Please provide a non-null indicator.");
        Objects.requireNonNull(searchUrl, "Please provide a non-null searchUrl.");
        PDSafeUIRunner.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                ControlHelpers.setVisible((Control)indicator, (boolean)true);
                browser.addProgressListener((ProgressListener)new ProgressAdapter(){

                    public void completed(ProgressEvent event) {
                        indicator.done();
                        ControlHelpers.setVisible((Control)indicator, (boolean)false);
                    }

                    public void changed(ProgressEvent event) {
                        indicator.beginTask(event.total);
                        indicator.worked((double)event.current);
                    }
                });
                ControlHelpers.setUrlSync((Browser)browser, (String)searchUrl);
            }
        });
    }

    private static String removePatternQuoting(String searchTerm) {
        Objects.requireNonNull(searchTerm, "Please provide a non-null search term.");
        if (searchTerm.startsWith("\\Q") && searchTerm.endsWith("\\E")) {
            searchTerm = searchTerm.substring(2, searchTerm.length() - 2);
        }
        return searchTerm;
    }

    private static String urlEncode(String term) {
        Objects.requireNonNull(term, "Please provide a non-null term to encode.");
        try {
            return URLEncoder.encode(term, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.info((Object)("The URL could not be encoded using UTF-8? " + String.valueOf(e)));
            return null;
        }
    }
}

