/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.integration.handler;

import com.ibm.etools.fa.pdtclient.ui.integration.handler.ShowFaultIDs;
import com.ibm.etools.fa.pdtclient.ui.util.QualifiedFaultEntry;
import com.ibm.etools.fa.pdtclient.ui.util.ReportOpenUtils;
import com.ibm.etools.fa.pdtclient.ui.util.integration.OpenReportRSE;
import com.ibm.pdtools.common.component.core.integration.PDAdapterHelper;
import com.ibm.pdtools.common.component.core.integration.PDMVSConnection;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.rse.adapter.JESDatasetEditorInputAF;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenReportFromJobOutputRSE
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static PDLogger logger = PDLogger.get(OpenReportFromJobOutputRSE.class);
    private static final String faultEntryScanPattern = "Fault ID F";

    protected void handle(ExecutionEvent event) {
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (activeEditor instanceof TextEditor) {
            PDMVSConnection c = (PDMVSConnection)PDAdapterHelper.adapt((Object)activeEditor.getEditorInput(), PDMVSConnection.class);
            if (c != null) {
                logger.trace((Object)"Extracted connection, attempting to open report.");
                TextEditor textEditor = (TextEditor)activeEditor;
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)activeEditor.getEditorInput());
                String faultEntry = this.getFaultEntry(activeEditor, document);
                if (faultEntry == null) {
                    List faultIdList = JESDatasetEditorInputAF.faultIdList;
                    if (faultIdList.size() > 1) {
                        ShowFaultIDs.openFaultEntriesDialog(new Shell(), c, faultIdList);
                    } else {
                        OpenReportRSE.open((PDMVSConnection)c, (QualifiedFaultEntry)ReportOpenUtils.search((String)document.get(), (String)faultEntry));
                    }
                } else {
                    OpenReportRSE.open((PDMVSConnection)c, (QualifiedFaultEntry)ReportOpenUtils.search((String)document.get(), (String)faultEntry));
                }
            } else {
                logger.error((Object)"Could not get connection details from the editor input.");
            }
        } else {
            logger.trace((Object)("The selected editor is not a TextEditor: " + (activeEditor == null ? "null" : activeEditor.getClass().getCanonicalName())));
        }
    }

    private String getFaultEntry(IEditorPart activeEditor, IDocument document) {
        ISelection selection = ((TextEditor)activeEditor).getSelectionProvider().getSelection();
        if (selection == null && !(selection instanceof ITextSelection)) {
            return null;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        IRegion lineInfo = null;
        int offsetCurrentCursor = textSelection.getOffset();
        int offsetLine = 0;
        try {
            int lineNumber = document.getLineOfOffset(offsetCurrentCursor);
            lineInfo = document.getLineInformation(lineNumber);
            offsetLine = lineInfo.getOffset();
        }
        catch (BadLocationException e) {
            return null;
        }
        StyledText styledText = (StyledText)activeEditor.getAdapter(Control.class);
        int index = styledText.getLineAtOffset(offsetLine);
        String currentText = styledText.getLine(index);
        if (currentText.equals("") || !currentText.contains(faultEntryScanPattern)) {
            return null;
        }
        int indexOfFaultID = currentText.indexOf(faultEntryScanPattern);
        String faultEntry = currentText.substring(indexOfFaultID + 9, currentText.length()).split(" ")[0];
        return faultEntry;
    }
}

