/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.integration.handler;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.ui.integration.handler.ShowFaultIDs;
import com.ibm.etools.fa.pdtclient.ui.util.QualifiedFaultEntry;
import com.ibm.etools.fa.pdtclient.ui.util.ReportOpenUtils;
import com.ibm.etools.fa.pdtclient.ui.util.integration.OpenReportRSE;
import com.ibm.ftt.jes.util.core.JesJobUtil;
import com.ibm.ftt.resource.utils.PBResourceUtils;
import com.ibm.ftt.resources.core.physical.IOSImage;
import com.ibm.ftt.resources.core.physical.util.OperationFailedException;
import com.ibm.pdtools.common.component.core.api.PDJob;
import com.ibm.pdtools.common.component.core.integration.PDMVSConnection;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.util.PDSafeRunner;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenReportFromJesJobInRSView
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(OpenReportFromJesJobInRSView.class);
    public static final String ID = "com.ibm.etools.fa.pdtclient.ui.integration.rse";
    private List<String> countFaultEntries;

    protected void handle(ExecutionEvent event) {
        final ISelection s = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (s instanceof StructuredSelection) {
            if (!((StructuredSelection)s).isEmpty()) {
                this.countFaultEntries = new ArrayList<String>();
                final PDJob adapt = PDJob.adapt((Object)((IStructuredSelection)s).getFirstElement());
                Job job = new Job("Fetching Fault Entries"){

                    protected IStatus run(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.OpenReportFromJesJobInRSView_AttemptingToOpen, 1);
                        OpenReportFromJesJobInRSView.this.countFaultEntries = OpenReportFromJesJobInRSView.this.countFaultEntries(adapt);
                        monitor.worked(1);
                        return new Status(0, OpenReportFromJesJobInRSView.ID, Messages.OpenReportFromJesJobInRSView_ScheduledSearchForIDI0003Message);
                    }
                };
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        if (OpenReportFromJesJobInRSView.this.countFaultEntries.size() > 1) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ShowFaultIDs.openFaultEntriesDialog(Display.getDefault().getActiveShell(), adapt.getConnection(), (this).OpenReportFromJesJobInRSView.this.countFaultEntries);
                                }
                            });
                        } else {
                            OpenReportFromJesJobInRSView.this.openReportUsingSelect(PDJob.adapt((Object)((IStructuredSelection)s).getFirstElement()));
                        }
                    }
                });
                job.setUser(true);
                job.schedule();
            } else {
                PDDialogs.openErrorThreadSafe((String)Messages.OpenReportFromJesJobInRSView_SelectJobToOpenReport);
            }
        } else {
            logger.trace((Object)("Selection is not a structuredSelection: " + (s == null ? "null" : s.getClass().getCanonicalName())));
        }
    }

    private void openReportUsingSelect(final PDJob p) {
        Job openJob = new Job(Messages.OpenReportFromJesJobInRSView_FAOpeningReport){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.OpenReportFromJesJobInRSView_AttemptingToOpen, 3);
                try {
                    if (p == null) {
                        throw new CoreException((IStatus)new Status(4, OpenReportFromJesJobInRSView.ID, Messages.OpenReportFromJesJobInRSView_CouldNotParseJob));
                    }
                    IOSImage system = OpenReportFromJesJobInRSView.getSystem(p);
                    JesJobUtil jesJobUtil = new JesJobUtil(system);
                    String jesmsgdd = OpenReportFromJesJobInRSView.getJESMSGDD(jesJobUtil, p);
                    monitor.worked(1);
                    logger.trace((Object)("Got system:" + String.valueOf(system) + " Reading dd: " + jesmsgdd));
                    QualifiedFaultEntry idi003Line = OpenReportFromJesJobInRSView.this.findMessage(jesJobUtil, p, monitor);
                    monitor.worked(2);
                    if (idi003Line == null && PDDialogs.openConfirmThreadSafe((String)Messages.OpenReportFromJesJobInRSView_FaultAnalyzer, (String)Messages.OpenReportFromJesJobInRSView_NoIDI0003MessageFoundReadMoreQuestion)) {
                        idi003Line = OpenReportFromJesJobInRSView.this.findMessage(jesJobUtil, p, monitor);
                    }
                    if (idi003Line == null) {
                        Status status = new Status(4, OpenReportFromJesJobInRSView.ID, Messages.OpenReportFromJesJobInRSView_CouldNotFindHForFEInOutput, (Throwable)new Error(Messages.OpenReportFromJesJobInRSView_IDI0003MessageNotFoundInOutput));
                        return status;
                    }
                    logger.trace(new Object[]{"Found an IDI003 message, attempting to open report: ", idi003Line});
                    monitor.worked(1);
                    OpenReportRSE.open((PDMVSConnection)p.getConnection(), (QualifiedFaultEntry)idi003Line);
                    Status status = new Status(0, OpenReportFromJesJobInRSView.ID, Messages.OpenReportFromJesJobInRSView_ScheduledSearchForIDI0003Message);
                    return status;
                }
                catch (CoreException e1) {
                    Status status = new Status(4, OpenReportFromJesJobInRSView.ID, Messages.OpenReportFromJesJobInRSView_ErrorOpeningReport, (Throwable)e1);
                    return status;
                }
                finally {
                    monitor.done();
                }
            }
        };
        openJob.setUser(true);
        openJob.schedule();
    }

    private static IOSImage getSystem(PDJob p) throws CoreException {
        String alias = p.getConnection().getAlias();
        IOSImage system = OpenReportFromJesJobInRSView.getJesJobUtilImpl(alias);
        if (system == null) {
            String hostName = p.getConnection().getHostName();
            logger.trace((Object)MessageFormat.format("Couldn''t find system using alias: {0} trying alias: {1}", alias, hostName));
            system = OpenReportFromJesJobInRSView.getJesJobUtilImpl(hostName);
        }
        if (system == null) {
            throw new CoreException((IStatus)new Status(4, ID, MessageFormat.format(Messages.OpenReportFromJesJobInRSView_CouldNotGetSystemForPDJob, p)));
        }
        logger.trace(new Object[]{"IOSImage system=", system});
        return system;
    }

    private static IOSImage getJesJobUtilImpl(final String system) {
        return (IOSImage)PDSafeRunner.call((Callable)new Callable<IOSImage>(){

            @Override
            public IOSImage call() throws Exception {
                return PBResourceUtils.findSystem((String)system, (int)2);
            }
        });
    }

    private QualifiedFaultEntry findMessage(JesJobUtil jesJobUtil, PDJob p, IProgressMonitor monitor) throws CoreException {
        Objects.requireNonNull(jesJobUtil, "Please provide a non-null jesJobUtil");
        Objects.requireNonNull(p, "Please provide a non-null pdJob");
        try {
            String line;
            InputStream contents = this.getInputStream(p);
            BufferedReader br = new BufferedReader(new InputStreamReader(contents, StandardCharsets.UTF_8));
            while ((line = br.readLine()) != null) {
                QualifiedFaultEntry qualifiedFaultEntry = ReportOpenUtils.search((String)line, null);
                if (qualifiedFaultEntry != null) {
                    return qualifiedFaultEntry;
                }
                monitor.subTask(MessageFormat.format(Messages.OpenReportFromJesJobInRSView_Parsing, line));
                if (!monitor.isCanceled()) continue;
                throw new CoreException((IStatus)new Status(8, ID, Messages.OpenReportFromJesJobInRSView_Cancelled));
            }
            return null;
        }
        catch (OperationFailedException | IOException e) {
            throw new CoreException((IStatus)new Status(4, ID, Messages.OpenReportFromJesJobInRSView_ErrorGettingDetailsCantOpenReport, e));
        }
    }

    private static String getJESMSGDD(JesJobUtil jesJobUtil, PDJob p) throws CoreException {
        try {
            List jobDDNames = jesJobUtil.getJobDDNames(p.getJobId());
            String sysmsgdd = "";
            for (String dd : jobDDNames) {
                if (!dd.matches(".*JESMSGLG.*")) continue;
                sysmsgdd = dd;
            }
            if (sysmsgdd.isEmpty()) {
                throw new CoreException((IStatus)new Status(4, ID, MessageFormat.format(Messages.OpenReportFromJesJobInRSView_CantFindJESYSMSGInJob, jobDDNames)));
            }
            return sysmsgdd;
        }
        catch (OperationFailedException e) {
            throw new CoreException((IStatus)new Status(4, ID, Messages.OpenReportFromJesJobInRSView_JobMissingDDs + String.valueOf(p), (Throwable)e));
        }
    }

    private List<String> countFaultEntries(PDJob p) {
        List<String> faultIdList = new ArrayList<String>();
        try {
            InputStream contents = this.getInputStream(p);
            BufferedReader br = new BufferedReader(new InputStreamReader(contents, StandardCharsets.UTF_8));
            faultIdList = ShowFaultIDs.getFaultIdList(br);
        }
        catch (IOException | CoreException e) {
            new Status(4, ID, Messages.OpenReportFromJesJobInRSView_ErrorGettingDetailsCantOpenReport, e);
        }
        return faultIdList;
    }

    private InputStream getInputStream(PDJob p) throws CoreException, OperationFailedException {
        IOSImage system = OpenReportFromJesJobInRSView.getSystem(p);
        JesJobUtil jesJobUtil = new JesJobUtil(system);
        String jesmsgdd = OpenReportFromJesJobInRSView.getJESMSGDD(jesJobUtil, p);
        InputStream contents = jesmsgdd == null ? jesJobUtil.getContents(p.getJobId()) : jesJobUtil.getContents(p.getJobId(), jesmsgdd);
        return contents;
    }

    public static interface FAPredicate<T> {
        public boolean test(T var1);
    }
}

