/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.analytics.widget.dialog;

import com.ibm.etools.fa.pdtclient.analytics.Messages;
import com.ibm.etools.fa.pdtclient.analytics.data.DatabaseManager;
import com.ibm.etools.fa.pdtclient.analytics.data.filter.ConditionType;
import com.ibm.etools.fa.pdtclient.analytics.handler.OpenChartDisplayFromView;
import com.ibm.etools.fa.pdtclient.analytics.sql.SQLQueryParser;
import com.ibm.etools.fa.pdtclient.analytics.ui.view.FAAnalyticsView;
import com.ibm.etools.fa.pdtclient.analytics.ui.view.model.ChartFunction;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.model.Condition;
import com.ibm.etools.fa.pdtclient.analytics.util.FAAnalyticsUtility;
import com.ibm.etools.fa.pdtclient.analytics.widget.AnalyticsChartFunctionList;
import com.ibm.etools.fa.pdtclient.analytics.widget.IAnalyticsChartFunctionListUser;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DrillDownDialog
extends Dialog
implements IAnalyticsChartFunctionListUser {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private DatabaseManager database;
    private FAAnalyticsView analyticsView;
    private ChartFunction chartFunction;
    private String drillDownTitleAddition;
    private String selectedXColumn;
    private String selectedXValue;
    private List<Condition> parentRecordConditions;
    private Composite dialogComposite;
    private AnalyticsChartFunctionList chartFunctionList;
    private Button displayFaultTableButton;
    private Button cancelButton;

    public DrillDownDialog(Shell parentShell, DatabaseManager database, ChartFunction chartFunction, String baseXColumn, String categoryValue) {
        super(parentShell);
        this.database = database;
        if (chartFunction == null) {
            throw new IllegalArgumentException("Must specify a non-null ChartFunction.");
        }
        this.chartFunction = chartFunction;
        this.selectedXColumn = baseXColumn;
        this.selectedXValue = categoryValue;
        this.drillDownTitleAddition = chartFunction.getDrillDownTitleAddition() == null || chartFunction.getDrillDownTitleAddition().isEmpty() ? this.selectedXColumn + ":" + this.selectedXValue : chartFunction.getDrillDownTitleAddition() + "|" + this.selectedXColumn + ":" + this.selectedXValue;
        SQLQueryParser queryParser = new SQLQueryParser(this.database, this.chartFunction.getQuery());
        if (queryParser.isWhereExists()) {
            try {
                this.parentRecordConditions = queryParser.parseRecordConditions();
            }
            catch (Exception e) {
                PDLogger.get(this.getClass()).warn((Object)Messages.DrillDownDialog_ErrorParsingRecordConditions, (Throwable)e);
                this.parentRecordConditions = new ArrayList<Condition>();
            }
        } else {
            this.parentRecordConditions = new ArrayList<Condition>();
        }
        this.analyticsView = FAAnalyticsView.findView();
        if (this.analyticsView == null) {
            throw new IllegalStateException("Could not find the FAAnalyticsView.");
        }
        Condition inherentCondition = new Condition();
        inherentCondition.setColumn(this.selectedXColumn);
        inherentCondition.setComparator(ConditionType.EQUALS);
        inherentCondition.setValue("'" + this.selectedXValue + "'");
        this.parentRecordConditions.add(inherentCondition);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(MessageFormat.format(Messages.DrillDownDialog_DialogTitle, this.selectedXColumn + " = " + this.selectedXValue));
        this.dialogComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillAll());
        GridData listData = GUI.grid.d.fillAll();
        listData.widthHint = 700;
        listData.heightHint = 300;
        this.chartFunctionList = new AnalyticsChartFunctionList(this.dialogComposite, listData, this, this.analyticsView.getChartFunctionManager());
        this.chartFunctionList.setDatabase(this.database);
        return this.dialogComposite;
    }

    @Override
    public void additionalButtons(Composite buttonParent) {
        this.displayFaultTableButton = GUI.button.push((Composite)buttonParent, (String)Messages.DrillDownDialog_DisplayFaultTable, (Object)new GridData(4, 128, true, false, 1, 1));
        this.cancelButton = GUI.button.push((Composite)buttonParent, (String)Messages.DrillDownDialog_Cancel, (Object)new GridData(4, 128, true, false, 1, 1));
        this.displayFaultTableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FAAnalyticsUtility.displayFaultEntryTable(DrillDownDialog.this.parentRecordConditions);
                DrillDownDialog.this.okPressed();
            }
        });
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DrillDownDialog.this.cancelPressed();
            }
        });
    }

    @Override
    public void displayChart(ChartFunction selectedChartFunction) {
        ChartFunction conditionInsertClone;
        if (selectedChartFunction == null) {
            return;
        }
        try {
            conditionInsertClone = selectedChartFunction.clone();
        }
        catch (CloneNotSupportedException e) {
            PDLogger.get(this.getClass()).error((Object)Messages.DrillDownDialog_CloneException, (Throwable)e);
            throw new RuntimeException();
        }
        SQLQueryParser queryParser = new SQLQueryParser(this.database, selectedChartFunction.getQuery());
        StringBuilder conditionStringBuilder = this.buildConditionString();
        queryParser = DrillDownDialog.insertIntoQueryParser(queryParser, conditionStringBuilder);
        queryParser.setWhereExists(true);
        conditionInsertClone.setName("\u21b3 " + conditionInsertClone.getName());
        conditionInsertClone.setQuery(queryParser.rebuildString());
        conditionInsertClone.setDrillDownTitleAddition(this.drillDownTitleAddition);
        OpenChartDisplayFromView.openChartDisplayFromDialog(conditionInsertClone);
        this.okPressed();
    }

    private StringBuilder buildConditionString() {
        StringBuilder conditionStringBuilder = new StringBuilder();
        int i = 0;
        while (i < this.parentRecordConditions.size()) {
            Condition parentCondition = this.parentRecordConditions.get(i);
            conditionStringBuilder.append("(" + parentCondition.toString() + ")");
            if (i != this.parentRecordConditions.size() - 1) {
                conditionStringBuilder.append(" AND ");
            }
            ++i;
        }
        return conditionStringBuilder;
    }

    private static SQLQueryParser insertIntoQueryParser(SQLQueryParser queryParser, StringBuilder conditionStringBuilder) {
        if (queryParser.isWhereExists()) {
            conditionStringBuilder.insert(0, " AND ");
            String whereContents = queryParser.getClauseMap().get("WHERE");
            queryParser.getClauseMap().put("WHERE", whereContents + conditionStringBuilder.toString());
        } else {
            queryParser.getClauseMap().put("WHERE", conditionStringBuilder.toString());
        }
        return queryParser;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    public boolean close() {
        this.chartFunctionList.onDispose();
        return super.close();
    }
}

