/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.analytics.widget;

import com.ibm.etools.fa.pdtclient.analytics.Messages;
import com.ibm.etools.fa.pdtclient.analytics.data.ChartData;
import com.ibm.etools.fa.pdtclient.analytics.data.DatabaseManager;
import com.ibm.etools.fa.pdtclient.analytics.ui.view.model.ChartFunction;
import com.ibm.etools.fa.pdtclient.analytics.widget.dialog.DrillDownDialog;
import com.ibm.etools.fa.pdtclient.ui.dialog.FaultEntryPropertiesDialog;
import com.ibm.etools.fa.pdtclient.ui.faobjects.view.ViewParser;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.util.Map;
import java.util.Objects;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.device.ICallBackNotifier;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.CallBackValue;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.statushandlers.StatusManager;

public class ChartRenderer
extends Canvas
implements ICallBackNotifier {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String packageReference = "device.double.buffered";
    private final PDLogger logger = PDLogger.get(ChartRenderer.class);
    private DatabaseManager database;
    private ChartFunction chartFunction;
    protected IDeviceRenderer device;
    protected Chart chart;
    protected GeneratedChartState state;
    private Image cachedImage;
    private PaintListener listener;
    private boolean bFirstPaint = true;
    private Bounds bounds;
    private int currX = -1;
    private int currY = -1;

    public ChartRenderer(Composite parent, int style, DatabaseManager database, ChartFunction chartFunction) {
        super(Objects.requireNonNull(parent, "Must specify a non-null parent Composite."), style);
        this.database = database;
        this.chartFunction = chartFunction;
        try {
            this.device = PluginSettings.instance().getDevice("dv.SWT");
            if (this.device == null) {
                StatusManager.getManager().handle((IStatus)new Status(4, "com.ibm.etools.fa.pdtclient.analytics", Messages.ChartRenderer_CouldNotInitializeBIRTRenderer, new Throwable()), 3);
            } else {
                this.device.setProperty("device.component", (Object)this);
            }
        }
        catch (ChartException e) {
            this.logger.error((Object)Messages.ChartRenderer_ErrorSWTDeviceRendererNotFound, (Throwable)e);
        }
    }

    public void drawChart() {
        if (this.listener != null) {
            this.removePaintListener(this.listener);
        }
        this.listener = new PaintListener(){

            public void paintControl(PaintEvent event) {
                Rectangle area = ((Composite)event.getSource()).getClientArea();
                if (ChartRenderer.this.device != null) {
                    if (Math.abs(area.height - ChartRenderer.this.currX) > 10 || Math.abs(area.width - ChartRenderer.this.currY) > 10) {
                        ChartRenderer.this.bFirstPaint = true;
                    }
                    if (ChartRenderer.this.bFirstPaint) {
                        if (ChartRenderer.this.cachedImage != null) {
                            ChartRenderer.this.cachedImage.dispose();
                        }
                        ChartRenderer.this.cachedImage = new Image((Device)ChartRenderer.this.getDisplay(), area);
                        GC gc = new GC((Drawable)ChartRenderer.this.cachedImage);
                        ChartRenderer.this.device.setProperty("device.output.context", (Object)gc);
                        ChartRenderer.this.bounds = BoundsImpl.create((double)0.0, (double)0.0, (double)area.width, (double)area.height);
                        ChartRenderer.this.bounds.scale(72.0 / (double)ChartRenderer.this.device.getDisplayServer().getDpiResolution());
                        ChartRenderer.this.currX = area.height;
                        ChartRenderer.this.currY = area.width;
                    }
                    try {
                        if (ChartRenderer.this.bFirstPaint) {
                            ChartRenderer.this.state = Generator.instance().build(ChartRenderer.this.device.getDisplayServer(), ChartRenderer.this.chart, ChartRenderer.this.bounds, null, null, null);
                        }
                        Generator.instance().render(ChartRenderer.this.device, ChartRenderer.this.state);
                        event.gc.drawImage(ChartRenderer.this.cachedImage, area.x, area.y);
                    }
                    catch (ChartException ce) {
                        ChartRenderer.this.logger.error((Object)Messages.ChartRenderer_ErrorFailedToBuildChart, (Throwable)ce);
                    }
                    ChartRenderer.this.bFirstPaint = false;
                }
            }
        };
        this.addPaintListener(this.listener);
        this.bFirstPaint = true;
    }

    public void paintChart() {
    }

    public void dispose() {
        if (this.cachedImage != null) {
            this.cachedImage.dispose();
        }
        super.dispose();
    }

    public void regenerateChart() {
        if (!this.isDisposed()) {
            try {
                Generator.instance().refresh(this.state);
            }
            catch (ChartException ex) {
                this.logger.error((Object)"An exception occurred while refrshing the chart.", (Throwable)ex);
            }
            this.redraw();
        }
    }

    public void repaintChart() {
        try {
            Generator.instance().render(this.device, this.state);
        }
        catch (ChartException e) {
            this.logger.error((Object)Messages.ChartRenderer_ExceptionWhileDrawingToCachedImage, (Throwable)e);
        }
    }

    public Object peerInstance() {
        return this;
    }

    public Chart getDesignTimeModel() {
        return this.chart;
    }

    public Chart getRunTimeModel() {
        return this.state.getChartModel();
    }

    public void setChart(Chart chart) {
        if (this.cachedImage != null) {
            this.cachedImage.dispose();
        }
        this.cachedImage = null;
        this.chart = chart;
    }

    public Chart getChart() {
        return this.chart;
    }

    public void callback(Object event, Object source, CallBackValue value) {
        if (source == null) {
            throw new IllegalArgumentException("Must provide a non-null source Object.");
        }
        WrappedStructureSource structureSource = (WrappedStructureSource)source;
        ChartData seriesDefinition = (ChartData)((SeriesImpl)structureSource.getParent().getSource()).getSeriesIdentifier();
        if (structureSource.getSource() instanceof DataPointHints) {
            DataPointHints hints = (DataPointHints)((WrappedStructureSource)source).getSource();
            if (seriesDefinition.getBaseXColumn().equals("FAULT_ID")) {
                boolean found = false;
                for (Map<String, String> entryObject : this.database.getEntries()) {
                    Map<String, String> entryMap = entryObject;
                    if (!entryMap.get("FAULT_ID").equals(hints.getBaseDisplayValue())) continue;
                    found = true;
                    new FaultEntryPropertiesDialog(entryMap.get(ViewParser.class.getCanonicalName()), entryMap.get("FAULT_ID")).open();
                    break;
                }
                if (!found) {
                    PDDialogs.openErrorThreadSafe((String)Messages.ChartRenderer_ErrorFaultEntryNotFoundDialogTitle, (String)Messages.ChartRenderer_ErrorFaultEntryNotFoundDialogMessage);
                    this.logger.error((Object)"The selected fault entry could not be found, the fault entry properties dialog cannot be displayed.");
                }
            } else {
                DrillDownDialog dialog = new DrillDownDialog(this.getShell(), this.database, this.chartFunction, seriesDefinition.getBaseXColumn(), hints.getBaseDisplayValue());
                try {
                    dialog.open();
                }
                catch (NullPointerException e) {
                    this.logger.error((Object)"Caught NPE while opening DrillDownDialog.");
                }
            }
        } else {
            PDDialogs.openErrorThreadSafe((String)Messages.ChartRenderer_ErrorDataSourceNotRecognisedDialogTitle, (String)Messages.ChartRenderer_ErrorDataSourceNotRecognisedDialogMessage);
            this.logger.error((Object)"The data source object of the selected was category not recognised, cannot open drill down dialog.");
        }
    }
}

