/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.analytics.widget;

import com.ibm.etools.fa.pdtclient.analytics.Messages;
import com.ibm.etools.fa.pdtclient.analytics.data.DatabaseManager;
import com.ibm.etools.fa.pdtclient.analytics.editor.ChartEditorInput;
import com.ibm.etools.fa.pdtclient.analytics.handler.OpenChartDisplayFromView;
import com.ibm.etools.fa.pdtclient.analytics.ui.view.model.ChartFunction;
import com.ibm.etools.fa.pdtclient.analytics.ui.view.model.ChartFunctionManager;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.ChartFunctionWizard;
import com.ibm.etools.fa.pdtclient.analytics.util.FAAnalyticsUtility;
import com.ibm.etools.fa.pdtclient.analytics.widget.IAnalyticsChartFunctionListUser;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IEditorInput;

public class AnalyticsChartFunctionList
implements Observer {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private IAnalyticsChartFunctionListUser listUser;
    private DatabaseManager database;
    private ChartFunctionManager chartFunctionManager;
    private Composite listComposite;
    private ScrolledComposite scrolledChartButtonsComposite;
    private Composite chartButtonsComposite;
    private Button chartDisplayButton;
    private Button chartNewButton;
    private Button chartEditButton;
    private Button chartDuplicateButton;
    private Button chartDeleteButton;
    private List chartFunctionList;
    private ListViewer chartFunctionListViewer;

    public AnalyticsChartFunctionList(Composite parent, GridData data, IAnalyticsChartFunctionListUser tableUser, ChartFunctionManager chartFunctionManager) {
        this.listUser = tableUser;
        this.database = null;
        this.chartFunctionManager = chartFunctionManager;
        this.createList(parent, data);
    }

    private void createList(Composite parent, GridData data) {
        if (this.listComposite != null) {
            throw new IllegalStateException("Cannot create this list more than once");
        }
        this.listComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)data);
        this.scrolledChartButtonsComposite = new ScrolledComposite(this.listComposite, 768);
        this.scrolledChartButtonsComposite.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        this.scrolledChartButtonsComposite.setExpandHorizontal(true);
        this.scrolledChartButtonsComposite.setExpandVertical(true);
        this.chartButtonsComposite = GUI.composite((Composite)this.scrolledChartButtonsComposite, (Layout)GUI.grid.l.customMargins((int)1, (boolean)true, (int)5, (int)20), (Object)new GridData(16384, 4, false, true, 1, 1));
        this.scrolledChartButtonsComposite.setContent((Control)this.chartButtonsComposite);
        this.chartDisplayButton = GUI.button.push((Composite)this.chartButtonsComposite, (String)Messages.FAAnalyticsView_DisplayChart, (Object)GUI.grid.d.horiz((int)4, (boolean)true, (int)1));
        this.chartNewButton = GUI.button.push((Composite)this.chartButtonsComposite, (String)Messages.FAAnalyticsView_NewChart, (Object)GUI.grid.d.horiz((int)4, (boolean)true, (int)1));
        this.chartEditButton = GUI.button.push((Composite)this.chartButtonsComposite, (String)Messages.FAAnalyticsView_EditChart, (Object)GUI.grid.d.horiz((int)4, (boolean)true, (int)1));
        this.chartDuplicateButton = GUI.button.push((Composite)this.chartButtonsComposite, (String)Messages.FAAnalyticsView_DuplicateChart, (Object)GUI.grid.d.horiz((int)4, (boolean)true, (int)1));
        this.chartDeleteButton = GUI.button.push((Composite)this.chartButtonsComposite, (String)Messages.FAAnalyticsView_DeleteChart, (Object)GUI.grid.d.horiz((int)4, (boolean)true, (int)1));
        this.scrolledChartButtonsComposite.setMinSize(this.chartButtonsComposite.computeSize(-1, -1));
        this.listUser.additionalButtons(this.chartButtonsComposite);
        this.chartFunctionList = new List(this.listComposite, 2564);
        this.chartFunctionList.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.chartFunctionListViewer = new ListViewer(this.chartFunctionList);
        this.chartFunctionListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.chartFunctionListViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.chartFunctionList.select(0);
        this.chartFunctionListViewer.setInput(this.chartFunctionManager.getChartFunctions());
        this.chartFunctionManager.addObserver(this);
        this.dataSetWidgetsEnabled(false);
        this.refreshContents();
        this.chartDisplayButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnalyticsChartFunctionList.this.listUser.displayChart(AnalyticsChartFunctionList.this.getFirstSelectedChart());
            }
        });
        this.chartNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartFunction newChartFunction = new ChartFunction();
                if (PDScrollableWizardDialog.openWizard((IWizard)new ChartFunctionWizard(AnalyticsChartFunctionList.this.database, AnalyticsChartFunctionList.this.chartFunctionManager, newChartFunction)) == 0) {
                    AnalyticsChartFunctionList.this.chartFunctionManager.addChartFunction(newChartFunction);
                    AnalyticsChartFunctionList.this.chartFunctionListViewer.setSelection((ISelection)new StructuredSelection((Object)newChartFunction), true);
                    ChartFunctionManager.saveFunctionToFile(newChartFunction);
                }
            }
        });
        this.chartEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartFunction selected = AnalyticsChartFunctionList.this.getFirstSelectedChart();
                if (selected != null) {
                    String oldName = selected.getName();
                    if (PDScrollableWizardDialog.openWizard((IWizard)new ChartFunctionWizard(AnalyticsChartFunctionList.this.database, AnalyticsChartFunctionList.this.chartFunctionManager, selected)) == 0) {
                        AnalyticsChartFunctionList.this.chartFunctionListViewer.setSelection((ISelection)new StructuredSelection((Object)selected), true);
                        ChartFunctionManager.saveFunctionToFile(selected, oldName);
                        AnalyticsChartFunctionList.this.refreshContents();
                        AnalyticsChartFunctionList.reopenChartIfBeingDisplayed(selected);
                    }
                }
            }
        });
        this.chartDuplicateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnalyticsChartFunctionList.this.chartFunctionManager.duplicateAndAddChartFunction(AnalyticsChartFunctionList.this.getFirstSelectedChart());
            }
        });
        this.chartDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnalyticsChartFunctionList.this.deleteChartFromList(AnalyticsChartFunctionList.this.getFirstSelectedChart());
            }
        });
        this.chartFunctionListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AnalyticsChartFunctionList.this.listUser.displayChart(AnalyticsChartFunctionList.this.getFirstSelectedChart());
            }
        });
        this.chartFunctionList.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ChartFunction selected = AnalyticsChartFunctionList.this.getFirstSelectedChart();
                if (selected != null) {
                    switch (e.character) {
                        case '\r': {
                            AnalyticsChartFunctionList.this.listUser.displayChart(selected);
                            break;
                        }
                        case '\u007f': {
                            if (selected.isReadOnly()) break;
                            AnalyticsChartFunctionList.this.deleteChartFromList(selected);
                        }
                    }
                }
            }
        });
        this.chartFunctionListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AnalyticsChartFunctionList.this.dataSetWidgetsEnabled(AnalyticsChartFunctionList.this.chartFunctionListViewer.getSelection() != null);
            }
        });
    }

    private static void reopenChartIfBeingDisplayed(final ChartFunction selected) {
        final AtomicBoolean closed = new AtomicBoolean();
        PDPlatformUIUtils.editor.closeAllEditorsWithInput((PDPlatformUIUtils.editor.EditorInputTester)new PDPlatformUIUtils.editor.EditorInputTester(){

            public boolean test(IEditorInput input) {
                boolean b;
                boolean bl = b = input instanceof ChartEditorInput && ((ChartEditorInput)input).getChartFunction().equals(selected);
                if (b) {
                    closed.set(true);
                }
                return b;
            }
        }, (boolean)true);
        if (closed.get()) {
            OpenChartDisplayFromView.openChartDisplayFromDialog(selected);
        }
    }

    private ChartFunction getFirstSelectedChart() {
        IStructuredSelection s = (IStructuredSelection)this.chartFunctionListViewer.getSelection();
        return s == null ? null : (ChartFunction)s.getFirstElement();
    }

    @Override
    public void update(Observable o, Object arg) {
        this.refreshContents();
    }

    public void refreshContents() {
        this.chartFunctionManager.sortContentsByName();
        this.chartFunctionListViewer.refresh();
        if (this.database != null) {
            this.dataSetWidgetsEnabled(this.chartFunctionListViewer.getSelection() != null);
        }
    }

    public void dataSetWidgetsEnabled(boolean enabled) {
        if (this.listComposite == null) {
            throw new IllegalStateException("Must create widgets first.");
        }
        if (!this.listComposite.isDisposed()) {
            this.listComposite.setEnabled(enabled);
        }
        this.chartFunctionList.setEnabled(enabled);
        this.chartNewButton.setEnabled(enabled);
        if (enabled && ((IStructuredSelection)this.chartFunctionListViewer.getSelection()).getFirstElement() != null) {
            if (((ChartFunction)((IStructuredSelection)this.chartFunctionListViewer.getSelection()).getFirstElement()).isReadOnly()) {
                this.chartDisplayButton.setEnabled(true);
                this.chartEditButton.setEnabled(false);
                this.chartDuplicateButton.setEnabled(true);
                this.chartDeleteButton.setEnabled(false);
            } else {
                this.chartDisplayButton.setEnabled(true);
                this.chartEditButton.setEnabled(true);
                this.chartDuplicateButton.setEnabled(true);
                this.chartDeleteButton.setEnabled(true);
            }
        } else {
            this.chartDisplayButton.setEnabled(false);
            this.chartEditButton.setEnabled(false);
            this.chartDuplicateButton.setEnabled(false);
            this.chartDeleteButton.setEnabled(false);
        }
    }

    private void deleteChartFromList(final ChartFunction selectedChartFunction) {
        if (selectedChartFunction != null && PDDialogs.openConfirmThreadSafe((String)Messages.FAAnalyticsView_DeleteChartFunctionDialogTitle, (String)Messages.FAAnalyticsView_DeleteChartFunctionDialogMessage)) {
            this.chartFunctionList.select(FAAnalyticsUtility.adjustCurrentSelection(this.chartFunctionList.getFocusIndex()));
            this.chartFunctionManager.removeChartFunction(selectedChartFunction);
            this.refreshContents();
            PDPlatformUIUtils.editor.closeAllEditorsWithInput((PDPlatformUIUtils.editor.EditorInputTester)new PDPlatformUIUtils.editor.EditorInputTester(){

                public boolean test(IEditorInput input) {
                    return input instanceof ChartEditorInput && ((ChartEditorInput)input).getChartFunction().equals(selectedChartFunction);
                }
            }, (boolean)true);
        }
    }

    public ListViewer getListViewer() {
        return this.chartFunctionListViewer;
    }

    public DatabaseManager getDatabase() {
        return this.database;
    }

    public void setDatabase(DatabaseManager database) {
        this.database = database;
        this.dataSetWidgetsEnabled(database != null);
    }

    public boolean setFocus() {
        return this.listComposite.isEnabled() ? this.chartFunctionList.setFocus() : false;
    }

    public void onDispose() {
        this.chartFunctionManager.deleteObserver(this);
    }
}

