/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.analytics.util;

import com.ibm.etools.fa.pdtclient.analytics.Messages;
import com.ibm.etools.fa.pdtclient.analytics.chart.AbstractAxisChartBuilder;
import com.ibm.etools.fa.pdtclient.analytics.chart.AbstractChartBuilder;
import com.ibm.etools.fa.pdtclient.analytics.chart.BarChartBuilder;
import com.ibm.etools.fa.pdtclient.analytics.chart.ChartType;
import com.ibm.etools.fa.pdtclient.analytics.chart.PieChartBuilder;
import com.ibm.etools.fa.pdtclient.analytics.ui.view.model.ChartFunction;
import java.lang.reflect.Field;
import org.eclipse.ui.IMemento;

public class MementoParser {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private boolean saveEssentialsOnly = false;

    public void readWriteChartFunctionMemento(IMemento memento, ChartFunction chartFunction, boolean save) {
        if (memento == null) {
            throw new IllegalArgumentException("Must specify a non-null IMemento.");
        }
        try {
            memento.getChildren();
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Must specify an IMemento with a non-null element and / or 1 or more children.");
        }
        if (chartFunction == null) {
            throw new IllegalArgumentException("Must specify a non-null chartFunction.");
        }
        IMemento chartFunctionMemento = MementoParser.parseChild(memento, "chartFunction", save);
        if (chartFunctionMemento == null) {
            return;
        }
        chartFunction.setName(MementoParser.parseString(chartFunctionMemento, "chartFunctionName", chartFunction.getName(), save));
        chartFunction.setQuery(MementoParser.parseString(chartFunctionMemento, "query", chartFunction.getQuery(), save));
        chartFunction.setLimitResults(MementoParser.parseBoolean(chartFunctionMemento, "limitResults", chartFunction.isLimitResults(), save));
        chartFunction.setResultsLimit(MementoParser.parseInteger(chartFunctionMemento, "resultLimit", chartFunction.getResultsLimit(), save));
        IMemento chartBuilderMemento = MementoParser.parseChild(chartFunctionMemento, "chartBuilder", save);
        String builderType = MementoParser.parseString(chartBuilderMemento, "chartBuilderType", chartFunction.getChartBuilder().getChartType().getName(), save);
        if (!save) {
            chartFunction.setChartBuilder(ChartType.stringToChartBuilder(builderType));
        }
        AbstractChartBuilder currentBuilder = chartFunction.getChartBuilder();
        IMemento chartTitleMemento = MementoParser.parseChild(chartBuilderMemento, "chartTitle", save);
        currentBuilder.setChartTitleEnabled(MementoParser.parseBoolean(chartTitleMemento, "chartTitleEnabled", currentBuilder.isChartTitleEnabled(), save));
        if (currentBuilder.isChartTitleEnabled()) {
            currentBuilder.setChartTitleFontName(MementoParser.parseString(chartTitleMemento, "chartTitleFont", currentBuilder.getChartTitleFontName(), save));
            currentBuilder.setChartTitleFontSize(MementoParser.parseInteger(chartTitleMemento, "chartTitleSize", currentBuilder.getChartTitleFontSize(), save));
            currentBuilder.setChartTitleBold(MementoParser.parseBoolean(chartTitleMemento, "chartTitleBold", currentBuilder.isChartTitleBold(), save));
            currentBuilder.setChartTitleItalic(MementoParser.parseBoolean(chartTitleMemento, "chartTitleItalic", currentBuilder.isChartTitleItalic(), save));
        }
        IMemento chartLegendMemento = MementoParser.parseChild(chartBuilderMemento, "legend", save);
        currentBuilder.setLegendEnabled(MementoParser.parseBoolean(chartLegendMemento, "legendEnabled", currentBuilder.isLegendEnabled(), save));
        if (currentBuilder.isLegendEnabled()) {
            currentBuilder.setLegendTitleEnabled(MementoParser.parseBoolean(chartLegendMemento, "legendTitleEnabled", currentBuilder.isLegendTitleEnabled(), save));
            if (currentBuilder.isLegendTitleEnabled()) {
                currentBuilder.setLegendTitle(MementoParser.parseString(chartLegendMemento, "legendTitle", currentBuilder.getLegendTitle(), save));
                currentBuilder.setLegendTitleFontName(MementoParser.parseString(chartLegendMemento, "legendTitleFont", currentBuilder.getLegendTitleFontName(), save));
                currentBuilder.setLegendTitleFontSize(MementoParser.parseInteger(chartLegendMemento, "legendTitleSize", currentBuilder.getLegendTitleFontSize(), save));
                currentBuilder.setLegendTitleBold(MementoParser.parseBoolean(chartLegendMemento, "legendTitleBold", currentBuilder.isLegendTitleBold(), save));
                currentBuilder.setLegendTitleItalic(MementoParser.parseBoolean(chartLegendMemento, "legendTitleItalic", currentBuilder.isLegendTitleItalic(), save));
            }
            currentBuilder.setLegendLabelFontName(MementoParser.parseString(chartLegendMemento, "legendLabelFont", currentBuilder.getLegendLabelFontName(), save));
            currentBuilder.setLegendLabelFontSize(MementoParser.parseInteger(chartLegendMemento, "legendLabelSize", currentBuilder.getLegendLabelFontSize(), save));
            currentBuilder.setLegendLabelBold(MementoParser.parseBoolean(chartLegendMemento, "legendLabelBold", currentBuilder.isLegendLabelBold(), save));
            currentBuilder.setLegendLabelItalic(MementoParser.parseBoolean(chartLegendMemento, "legendLabelItalic", currentBuilder.isLegendLabelItalic(), save));
        }
        if (currentBuilder instanceof AbstractAxisChartBuilder) {
            IMemento chartAxisMemento = MementoParser.parseChild(chartBuilderMemento, "subTitles", save);
            ((AbstractAxisChartBuilder)currentBuilder).setxTitleEnabled(MementoParser.parseBoolean(chartAxisMemento, "xAxisTitleEnabled", ((AbstractAxisChartBuilder)currentBuilder).isxTitleEnabled(), save));
            if (((AbstractAxisChartBuilder)currentBuilder).isxTitleEnabled()) {
                ((AbstractAxisChartBuilder)currentBuilder).setxTitle(MementoParser.parseString(chartAxisMemento, "xAxisTitle", ((AbstractAxisChartBuilder)currentBuilder).getxTitle(), save));
            }
            ((AbstractAxisChartBuilder)currentBuilder).setyTitleEnabled(MementoParser.parseBoolean(chartAxisMemento, "yAxisTitleEnabled", ((AbstractAxisChartBuilder)currentBuilder).isyTitleEnabled(), save));
            if (((AbstractAxisChartBuilder)currentBuilder).isyTitleEnabled()) {
                ((AbstractAxisChartBuilder)currentBuilder).setyTitle(MementoParser.parseString(chartAxisMemento, "yAxisTitle", ((AbstractAxisChartBuilder)currentBuilder).getyTitle(), save));
            }
        }
        currentBuilder.setChart3D(MementoParser.parseBoolean(chartBuilderMemento, "chart3D", currentBuilder.isChart3D(), save));
        if (currentBuilder instanceof BarChartBuilder) {
            ((BarChartBuilder)currentBuilder).setBarHorizontal(MementoParser.parseBoolean(chartBuilderMemento, "barHorizontal", ((BarChartBuilder)currentBuilder).isBarHorizontal(), save));
            ((BarChartBuilder)currentBuilder).setBarStacked(MementoParser.parseBoolean(chartBuilderMemento, "barStacked", ((BarChartBuilder)currentBuilder).isBarStacked(), save));
        }
        if (currentBuilder instanceof PieChartBuilder) {
            ((PieChartBuilder)currentBuilder).setPieDonut(MementoParser.parseBoolean(chartBuilderMemento, "pieDonut", ((PieChartBuilder)currentBuilder).isPieDonut(), save));
            ((PieChartBuilder)currentBuilder).setPieExploded(MementoParser.parseBoolean(chartBuilderMemento, "pieExploded", ((PieChartBuilder)currentBuilder).isPieExploded(), save));
        }
    }

    private static String parseString(IMemento memento, String key, String value, boolean save) {
        if (save) {
            memento.putString(key, value);
            return value;
        }
        String str = memento.getString(key);
        if (str.startsWith("%") && str.endsWith("%")) {
            String result;
            Field f;
            str = str.substring(1, str.length() - 1);
            Class<Messages> c = Messages.class;
            try {
                f = c.getDeclaredField(str);
            }
            catch (NoSuchFieldException e) {
                throw new IllegalStateException(e);
            }
            catch (SecurityException e) {
                throw new IllegalStateException(e);
            }
            try {
                result = (String)f.get(null);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            return result;
        }
        return str;
    }

    private static boolean parseBoolean(IMemento memento, String key, boolean value, boolean save) {
        if (save) {
            memento.putBoolean(key, value);
            return value;
        }
        return memento.getBoolean(key);
    }

    private static int parseInteger(IMemento memento, String key, int value, boolean save) {
        if (save) {
            memento.putInteger(key, value);
            return value;
        }
        return memento.getInteger(key);
    }

    private static IMemento parseChild(IMemento memento, String key, boolean save) {
        return save ? memento.createChild(key) : memento.getChild(key);
    }

    public boolean isSaveEssentialsOnly() {
        return this.saveEssentialsOnly;
    }

    public void setSaveEssentialsOnly(boolean saveEssentialsOnly) {
        this.saveEssentialsOnly = saveEssentialsOnly;
    }
}

