/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.analytics.util;

import com.ibm.etools.fa.pdtclient.analytics.Messages;
import com.ibm.etools.fa.pdtclient.analytics.data.ChartData;
import com.ibm.etools.fa.pdtclient.analytics.data.filter.ConditionType;
import com.ibm.etools.fa.pdtclient.analytics.preferences.FAAnalyticsConstants;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.model.Condition;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsList;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.swt.graphics.Point;

public class FAAnalyticsUtility {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String DATE_FORMAT = "YYYY/MM/DD";

    public static void generateImageFromChart(Chart inputChart, String imageFileName, Point size) {
        if (size == null) {
            throw new IllegalArgumentException("Must provide a non-null size");
        }
        Objects.requireNonNull(imageFileName, "Please provide a non-null imageFileName.");
        Graphics gc = null;
        try {
            try {
                PluginSettings pluginSettings = PluginSettings.instance();
                IDeviceRenderer device = pluginSettings.getDevice("dv.JPG");
                device.setProperty("device.file.identifier", (Object)imageFileName);
                Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)size.x, (double)size.y);
                int resolution = device.getDisplayServer().getDpiResolution();
                bo.scale(72.0 / (double)resolution);
                Generator gr = Generator.instance();
                GeneratedChartState state = gr.build(device.getDisplayServer(), inputChart, bo, null, null, null);
                BufferedImage cachedImage = new BufferedImage(size.x, size.y, 1);
                gc = ((Image)cachedImage).getGraphics();
                device.setProperty("device.output.context", (Object)gc);
                gr.render(device, state);
            }
            catch (Exception e) {
                PDLogger.get(FAAnalyticsUtility.class).error((Object)Messages.FAAnalyticsUtility_ErrorRenderingChartImage, (Throwable)e);
                if (gc != null) {
                    gc.dispose();
                }
            }
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
    }

    public static String monthNameToDateStringNumber(String month) {
        if (month.equals(Messages.FAAnalyticsUtility_January)) {
            return "01";
        }
        if (month.equals(Messages.FAAnalyticsUtility_February)) {
            return "02";
        }
        if (month.equals(Messages.FAAnalyticsUtility_March)) {
            return "03";
        }
        if (month.equals(Messages.FAAnalyticsUtility_April)) {
            return "04";
        }
        if (month.equals(Messages.FAAnalyticsUtility_May)) {
            return "05";
        }
        if (month.equals(Messages.FAAnalyticsUtility_June)) {
            return "06";
        }
        if (month.equals(Messages.FAAnalyticsUtility_July)) {
            return "07";
        }
        if (month.equals(Messages.FAAnalyticsUtility_August)) {
            return "08";
        }
        if (month.equals(Messages.FAAnalyticsUtility_September)) {
            return "09";
        }
        if (month.equals(Messages.FAAnalyticsUtility_October)) {
            return "10";
        }
        if (month.equals(Messages.FAAnalyticsUtility_November)) {
            return "11";
        }
        if (month.equals(Messages.FAAnalyticsUtility_December)) {
            return "12";
        }
        return ".*";
    }

    public static void orderChartData(ChartData chartData) {
        List<String> fullList;
        switch (chartData.getBaseXColumn()) {
            case "WEEKDAY": {
                fullList = FAAnalyticsUtility.getWeekDays();
                break;
            }
            case "MONTH": {
                fullList = FAAnalyticsUtility.getMonths();
                break;
            }
            default: {
                return;
            }
        }
        List<Double> numericList = FAAnalyticsUtility.getEmptyDoubleList(fullList);
        int i = 0;
        while (i < chartData.getxSeries().size()) {
            String categoryString = chartData.getxSeries().get(i);
            Double value = chartData.getySeries().get(i);
            int index = fullList.indexOf(categoryString);
            if (index == -1) {
                StringBuffer titleString = new StringBuffer(categoryString.length());
                titleString.append(categoryString);
                titleString.setCharAt(0, Character.toUpperCase(categoryString.charAt(0)));
                index = fullList.indexOf(titleString.toString());
            }
            numericList.set(index, value);
            ++i;
        }
        chartData.setxSeries(fullList);
        chartData.setySeries(numericList);
    }

    private static List<String> getWeekDays() {
        ArrayList<String> weekdays = new ArrayList<String>();
        weekdays.add(Messages.FAAnalyticsUtility_Monday);
        weekdays.add(Messages.FAAnalyticsUtility_Tuesday);
        weekdays.add(Messages.FAAnalyticsUtility_Wednesday);
        weekdays.add(Messages.FAAnalyticsUtility_Thursday);
        weekdays.add(Messages.FAAnalyticsUtility_Friday);
        weekdays.add(Messages.FAAnalyticsUtility_Saturday);
        weekdays.add(Messages.FAAnalyticsUtility_Sunday);
        return weekdays;
    }

    private static List<String> getMonths() {
        ArrayList<String> months = new ArrayList<String>();
        months.add(Messages.FAAnalyticsUtility_January);
        months.add(Messages.FAAnalyticsUtility_February);
        months.add(Messages.FAAnalyticsUtility_March);
        months.add(Messages.FAAnalyticsUtility_April);
        months.add(Messages.FAAnalyticsUtility_May);
        months.add(Messages.FAAnalyticsUtility_June);
        months.add(Messages.FAAnalyticsUtility_July);
        months.add(Messages.FAAnalyticsUtility_August);
        months.add(Messages.FAAnalyticsUtility_September);
        months.add(Messages.FAAnalyticsUtility_October);
        months.add(Messages.FAAnalyticsUtility_November);
        months.add(Messages.FAAnalyticsUtility_December);
        return months;
    }

    private static List<Double> getEmptyDoubleList(List<String> xList) {
        ArrayList<Double> result = new ArrayList<Double>();
        int i = 0;
        while (i < xList.size()) {
            result.add(0.0);
            ++i;
        }
        return result;
    }

    public static int adjustCurrentSelection(int currentIndex) {
        if (currentIndex == 0) {
            return currentIndex;
        }
        return currentIndex - 1;
    }

    public static void displayFaultEntryTable(List<Condition> recordConditions) {
        ReportsList reportsListView;
        if (recordConditions == null) {
            throw new IllegalArgumentException("Must specify a non-null List of conditions.");
        }
        String dateString = DATE_FORMAT;
        String duplicateDateString = DATE_FORMAT;
        HashMap<String, String> filters = new HashMap<String, String>();
        for (Condition recordCondition : recordConditions) {
            if (recordCondition == null) {
                PDLogger.get(FAAnalyticsUtility.class).info((Object)"Encountered a null recordCondition. Skipping it.");
                continue;
            }
            String recordColumn = recordCondition.getColumn();
            if (recordColumn.equals("WEEKDAY") || !recordCondition.getComparator().equals((Object)ConditionType.EQUALS) && !recordCondition.getComparator().equals((Object)ConditionType.LIKE)) continue;
            String recordValue = recordCondition.getValue().replace("'", "");
            if (recordCondition.getComparator().equals((Object)ConditionType.LIKE)) {
                recordValue = recordValue.replace("%", ".*");
                recordValue = recordValue.replace("_", ".?");
            }
            if (FAAnalyticsConstants.DATABASE_HEADER_DATE_LIST.contains(recordColumn) || recordColumn.equals("MONTH") || recordColumn.equals("YEAR")) {
                if (FAAnalyticsConstants.DATABASE_HEADER_DATE_LIST.contains(recordColumn)) {
                    dateString = recordValue.replace("-", "/");
                }
                if (recordColumn.equals("MONTH")) {
                    dateString = dateString.replace("MM", FAAnalyticsUtility.monthNameToDateStringNumber(recordValue));
                }
                if (!recordColumn.equals("YEAR")) continue;
                dateString = dateString.replace("YYYY", recordValue);
                continue;
            }
            filters.put(recordColumn, recordValue);
        }
        if (!dateString.equals(DATE_FORMAT)) {
            dateString = dateString.replace("YYYY", ".*");
            dateString = dateString.replace("MM", ".*");
            dateString = dateString.replace("DD", ".*");
            filters.put("DATE", dateString);
        }
        if ((reportsListView = ReportsList.show((boolean)false)) != null) {
            reportsListView.setFilters(filters);
            reportsListView.refresh(null);
        }
    }
}

