/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.analytics.ui.wizard.model;

import com.ibm.etools.fa.pdtclient.analytics.data.filter.AggregateType;

public class SeriesDef {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private String baseColumn;
    private String aliasColumn;
    private AggregateType aggregateFunction;
    private boolean useAlias;
    private boolean distinct;

    public SeriesDef() {
        this.baseColumn = "";
        this.aliasColumn = "";
        this.aggregateFunction = AggregateType.NONE;
        this.useAlias = false;
        this.distinct = false;
    }

    public SeriesDef(String baseHeader, String seriesName, AggregateType aggregateFunction, boolean useAlias, boolean distinct) {
        this.baseColumn = baseHeader;
        this.aliasColumn = seriesName;
        if (aggregateFunction == null) {
            throw new IllegalArgumentException("Must specify non-null aggregateFunction. i.e. use AggregateType.NONE instead of null.");
        }
        this.aggregateFunction = aggregateFunction;
        this.useAlias = useAlias;
        this.distinct = distinct;
    }

    public String getBaseColumn() {
        return this.baseColumn;
    }

    public void setBaseColumn(String baseColumn) {
        this.baseColumn = baseColumn;
    }

    public String getAliasColumn() {
        return this.aliasColumn;
    }

    public void setAliasColumn(String aliasColumn) {
        this.aliasColumn = aliasColumn;
    }

    public AggregateType getAggregateFunction() {
        return this.aggregateFunction;
    }

    public void setAggregateFunction(AggregateType aggregateFunction) {
        this.aggregateFunction = aggregateFunction;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isUseAlias() {
        return this.useAlias;
    }

    public void setUseAlias(boolean useAlias) {
        this.useAlias = useAlias;
    }

    public String getSeriesReference() {
        return String.format(this.aggregateFunction.getFormat(), (this.distinct ? "DISTINCT " : "") + "\"" + this.baseColumn + "\"");
    }

    public String toString() {
        return this.getSeriesReference() + (String)(this.useAlias && !this.aliasColumn.equals(this.baseColumn) ? " AS \"" + this.aliasColumn + "\"" : "");
    }
}

