/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.analytics.ui.wizard.dialog;

import com.ibm.etools.fa.pdtclient.analytics.Messages;
import com.ibm.etools.fa.pdtclient.analytics.data.DatabaseManager;
import com.ibm.etools.fa.pdtclient.analytics.data.filter.AggregateType;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.dialog.AggregateFunctionLabelProvider;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.model.SeriesDef;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SeriesDefDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int MIN_DIALOG_WIDTH = 700;
    private static final int MIN_DIALOG_HEIGHT = 270;
    private DatabaseManager database;
    private SeriesDef tentativeDefinition;
    private Composite dialogComposite;
    private Composite leftComposite;
    private Composite rightComposite;
    private Label columnLabel;
    private Combo columnCombo;
    private ComboViewer columnComboViewer;
    private Label aliasLabel;
    private Text aliasText;
    private Label aggregateLabel;
    private Combo aggregateCombo;
    private ComboViewer aggregateComboViewer;
    private Button distinctCheck;
    private Button useAliasCheck;
    private Button cancelButton;
    private Button okayButton;

    public SeriesDefDialog(DatabaseManager database, SeriesDef definition) {
        this.database = database;
        this.tentativeDefinition = definition;
    }

    public Composite createDialogContent(Composite parent) {
        this.getShell().setMinimumSize(700, 270);
        this.setTitle(Messages.SeriesDefDialog_DialogTitle);
        this.setMessage(Messages.SeriesDefDialog_DialogMessage);
        GridData comboData = new GridData(4, -1, true, true, 1, 1);
        comboData.widthHint = 150;
        this.dialogComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.leftComposite = GUI.composite((Composite)this.dialogComposite, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.columnLabel = GUI.label((Composite)this.leftComposite, (String)Messages.SeriesDefDialog_ColumnLabel, (Object)GUI.grid.d.left1(), (int)0);
        this.columnCombo = GUI.combo((Composite)this.leftComposite, (Object)comboData, (int)12);
        this.columnComboViewer = new ComboViewer(this.columnCombo);
        this.columnComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.aggregateLabel = GUI.label((Composite)this.leftComposite, (String)Messages.SeriesDefDialog_AggregateFunctionLabel, (Object)GUI.grid.d.left1(), (int)0);
        this.aggregateCombo = GUI.combo((Composite)this.leftComposite, (Object)comboData, (int)12);
        this.aggregateComboViewer = new ComboViewer(this.aggregateCombo);
        this.aggregateComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.aggregateComboViewer.setLabelProvider((IBaseLabelProvider)new AggregateFunctionLabelProvider());
        this.rightComposite = GUI.composite((Composite)this.dialogComposite, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.distinctCheck = GUI.button((Composite)this.rightComposite, (String)Messages.SeriesDefDialog_DistinctLabel, (Object)GUI.grid.d.horiz((int)16384, (boolean)true, (int)2), (int)32);
        this.initialise();
        return this.dialogComposite;
    }

    private void initialise() {
        if (this.database.getColumnNames().isEmpty()) {
            throw new IllegalStateException();
        }
        this.columnComboViewer.setComparator(new ViewerComparator());
        this.columnComboViewer.setInput(this.database.getColumnNames());
        this.aggregateComboViewer.setInput((Object)AggregateType.values());
        if (!this.tentativeDefinition.getBaseColumn().isEmpty()) {
            this.columnComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.tentativeDefinition.getBaseColumn()), true);
        } else {
            this.columnCombo.select(0);
        }
        this.aggregateComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.tentativeDefinition.getAggregateFunction()), true);
        this.distinctCheck.setSelection(this.tentativeDefinition.isDistinct());
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.horiz((int)131072, (boolean)false, (int)2));
        GridData buttonData = new GridData(131072, -1, false, false, 1, 1);
        buttonData.widthHint = 150;
        this.okayButton = GUI.button.push((Composite)buttonComposite, (String)Messages.SeriesDefDialog_Okay, (Object)buttonData);
        this.okayButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SeriesDefDialog.this.okPressed();
            }
        });
        this.cancelButton = GUI.button.push((Composite)buttonComposite, (String)Messages.SeriesDefDialog_Cancel, (Object)buttonData);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SeriesDefDialog.this.cancelPressed();
            }
        });
        return buttonComposite;
    }

    protected void okPressed() {
        this.setReturnCode(0);
        this.tentativeDefinition.setBaseColumn((String)((IStructuredSelection)this.columnComboViewer.getSelection()).getFirstElement());
        this.tentativeDefinition.setUseAlias(false);
        this.tentativeDefinition.setAliasColumn((String)((IStructuredSelection)this.columnComboViewer.getSelection()).getFirstElement());
        this.tentativeDefinition.setAggregateFunction((AggregateType)((Object)((IStructuredSelection)this.aggregateComboViewer.getSelection()).getFirstElement()));
        this.tentativeDefinition.setDistinct(this.distinctCheck.getSelection());
        this.close();
    }
}

