/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.analytics.ui.wizard.dialog;

import com.ibm.etools.fa.pdtclient.analytics.Messages;
import com.ibm.etools.fa.pdtclient.analytics.data.DatabaseManager;
import com.ibm.etools.fa.pdtclient.analytics.data.filter.AggregateType;
import com.ibm.etools.fa.pdtclient.analytics.data.filter.ConditionType;
import com.ibm.etools.fa.pdtclient.analytics.preferences.FAAnalyticsConstants;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.dialog.AggregateFunctionLabelProvider;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.dialog.ComparatorLabelProvider;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.model.AggregateCondition;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.model.Condition;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ConditionDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int MIN_DIALOG_WIDTH = 700;
    private static final int MIN_DIALOG_HEIGHT = 300;
    private DatabaseManager database;
    private Condition tentativeCondition;
    private boolean aggregateCondition;
    private Composite dialogComposite;
    private Composite leftComposite;
    private Composite rightComposite;
    private Label columnLabel;
    private Combo columnCombo;
    private ComboViewer columnComboViewer;
    private Label comparatorLabel;
    private Combo comparatorCombo;
    private ComboViewer comparatorComboViewer;
    private Label valueLabel;
    private Text valueText;
    private Label aggregateLabel;
    private Combo aggregateCombo;
    private ComboViewer aggregateComboViewer;
    private Button distinctCheck;
    private Button cancelButton;
    private Button okayButton;

    public ConditionDialog(DatabaseManager database, Condition tentativeCondition) {
        this.database = database;
        this.tentativeCondition = tentativeCondition;
        this.aggregateCondition = this.tentativeCondition instanceof AggregateCondition;
    }

    public Composite createDialogContent(Composite parent) {
        this.getShell().setMinimumSize(700, 300);
        if (this.aggregateCondition) {
            this.setTitle(Messages.ConditionDialog_AggregateConditionDialogTitle);
        } else {
            this.setTitle(Messages.ConditionDialog_RecordConditionDialogTitle);
        }
        this.setMessage(Messages.ConditionDialog_ConditionDialogMessage);
        this.dialogComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)true), (Object)GUI.grid.d.fillAll());
        this.leftComposite = GUI.composite((Composite)this.dialogComposite, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.columnLabel = GUI.label((Composite)this.leftComposite, (String)Messages.ConditionDialog_ColumnLabel, (Object)GUI.grid.d.left1(), (int)0);
        this.columnCombo = GUI.combo((Composite)this.leftComposite, (Object)GUI.grid.d.fillH((int)1), (int)12);
        this.columnComboViewer = new ComboViewer(this.columnCombo);
        this.columnComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.comparatorLabel = GUI.label((Composite)this.leftComposite, (String)Messages.ConditionDialog_ComparatorLabel, (Object)GUI.grid.d.left1(), (int)0);
        this.comparatorCombo = GUI.combo((Composite)this.leftComposite, (Object)GUI.grid.d.fillH((int)1), (int)12);
        this.comparatorComboViewer = new ComboViewer(this.comparatorCombo);
        this.comparatorComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.comparatorComboViewer.setLabelProvider((IBaseLabelProvider)new ComparatorLabelProvider());
        this.valueLabel = GUI.label((Composite)this.leftComposite, (String)Messages.ConditionDialog_ValueLabel, (Object)GUI.grid.d.left1(), (int)0);
        this.valueText = GUI.text((Composite)this.leftComposite, (Object)GUI.grid.d.fillH((int)1), (int)4);
        this.rightComposite = GUI.composite((Composite)this.dialogComposite, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillAll());
        Composite aggregateComposite = GUI.composite((Composite)this.rightComposite, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)2));
        this.aggregateLabel = GUI.label((Composite)aggregateComposite, (String)Messages.ConditionDialog_AggregateFunctionLabel, (Object)GUI.grid.d.left1(), (int)0);
        this.aggregateCombo = GUI.combo((Composite)aggregateComposite, (Object)GUI.grid.d.fillH((int)1), (int)12);
        this.aggregateComboViewer = new ComboViewer(this.aggregateCombo);
        this.aggregateComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.aggregateComboViewer.setLabelProvider((IBaseLabelProvider)new AggregateFunctionLabelProvider());
        this.distinctCheck = GUI.button((Composite)this.rightComposite, (String)Messages.ConditionDialog_DistinctCheckLabel, (Object)GUI.grid.d.fillH((int)1), (int)32);
        if (!this.aggregateCondition) {
            this.aggregateLabel.setVisible(false);
            this.aggregateCombo.setVisible(false);
            this.distinctCheck.setVisible(false);
        }
        this.initialise();
        return this.dialogComposite;
    }

    private void initialise() {
        this.columnComboViewer.setComparator(new ViewerComparator());
        this.columnComboViewer.setInput(this.database.getColumnNames());
        this.comparatorComboViewer.setInput((Object)ConditionType.values());
        this.aggregateComboViewer.setInput((Object)AggregateType.allAggregateFunctions().toArray());
        if (!this.tentativeCondition.getColumn().isEmpty()) {
            this.columnComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.tentativeCondition.getColumn()), true);
        } else {
            this.columnCombo.select(0);
        }
        if (this.tentativeCondition.getComparator() != null) {
            this.comparatorComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.tentativeCondition.getComparator()), true);
        } else {
            this.comparatorCombo.select(0);
        }
        if (!this.tentativeCondition.getValue().isEmpty()) {
            this.valueText.setText(this.tentativeCondition.getValue().replace("'", ""));
        } else {
            this.valueText.setText("");
        }
        if (this.aggregateCondition) {
            if (((AggregateCondition)this.tentativeCondition).getAggregateFunction() != null) {
                this.aggregateComboViewer.setSelection((ISelection)new StructuredSelection((Object)((AggregateCondition)this.tentativeCondition).getAggregateFunction()), true);
            } else {
                this.aggregateCombo.select(0);
            }
            this.distinctCheck.setSelection(((AggregateCondition)this.tentativeCondition).isDistinct());
            this.valueText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    String currentContents = ((Text)e.widget).getText();
                    String valueNumber = currentContents.substring(0, e.start) + e.text + currentContents.substring(e.end);
                    try {
                        ConditionDialog.this.okayButton.setEnabled(true);
                    }
                    catch (NumberFormatException e1) {
                        if (!valueNumber.trim().isEmpty()) {
                            e.doit = false;
                        }
                        ConditionDialog.this.okayButton.setEnabled(false);
                    }
                }
            });
        } else {
            this.valueText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    String currentContents = ((Text)e.widget).getText();
                    String totalContents = currentContents.substring(0, e.start) + e.text + currentContents.substring(e.end);
                    if (totalContents.isEmpty()) {
                        ConditionDialog.this.okayButton.setEnabled(false);
                    } else {
                        ConditionDialog.this.okayButton.setEnabled(true);
                    }
                }
            });
            this.valueText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    if (e.text != null && e.text.equals("'")) {
                        e.doit = false;
                    }
                }
            });
        }
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.horiz((int)131072, (boolean)false, (int)2));
        GridData buttonData = new GridData(131072, -1, false, false, 1, 1);
        buttonData.widthHint = 150;
        this.okayButton = GUI.button.push((Composite)buttonComposite, (String)Messages.ConditionDialog_Okay, (Object)buttonData);
        this.okayButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConditionDialog.this.okPressed();
            }
        });
        this.cancelButton = GUI.button.push((Composite)buttonComposite, (String)Messages.ConditionDialog_Cancel, (Object)buttonData);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConditionDialog.this.cancelPressed();
            }
        });
        this.okayButton.setEnabled(!this.valueText.getText().trim().isEmpty());
        return buttonComposite;
    }

    protected void okPressed() {
        this.tentativeCondition.setColumn((String)((IStructuredSelection)this.columnComboViewer.getSelection()).getFirstElement());
        this.tentativeCondition.setComparator((ConditionType)((Object)((IStructuredSelection)this.comparatorComboViewer.getSelection()).getFirstElement()));
        if (FAAnalyticsConstants.DATABASE_HEADER_NUMERIC_LIST.contains(this.tentativeCondition.getColumn()) || this.aggregateCondition) {
            this.tentativeCondition.setValue(this.valueText.getText());
        } else {
            this.tentativeCondition.setValue("'" + this.valueText.getText().replace("'", "") + "'");
        }
        if (this.aggregateCondition) {
            ((AggregateCondition)this.tentativeCondition).setAggregateFunction((AggregateType)((Object)((IStructuredSelection)this.aggregateComboViewer.getSelection()).getFirstElement()));
            ((AggregateCondition)this.tentativeCondition).setDistinct(this.distinctCheck.getSelection());
        }
        super.okPressed();
    }
}

