/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.analytics.ui.wizard;

import com.ibm.etools.fa.pdtclient.analytics.Messages;
import com.ibm.etools.fa.pdtclient.analytics.data.DatabaseManager;
import com.ibm.etools.fa.pdtclient.analytics.data.filter.AggregateType;
import com.ibm.etools.fa.pdtclient.analytics.sql.SQLQueryBuilder;
import com.ibm.etools.fa.pdtclient.analytics.sql.SQLQueryParser;
import com.ibm.etools.fa.pdtclient.analytics.ui.view.model.ChartFunction;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.ChartFunctionWizard;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.ChartFunctionWizardLabellingPage;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.dialog.ConditionDialog;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.dialog.SeriesDefDialog;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.model.AggregateCondition;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.model.Condition;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.model.SeriesDef;
import com.ibm.etools.fa.pdtclient.analytics.util.FAAnalyticsUtility;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ChartFunctionWizardDataPage
extends WizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int SQL_QUERY_TEXT_LIMIT = 10000;
    private static final String FREQUENCY_DUPLICATES_COLUMN = "DUPS";
    private DatabaseManager database;
    private ChartFunction model;
    private SQLQueryBuilder queryBuilder;
    private List<SeriesDef> xSeries;
    private List<SeriesDef> ySeries;
    private List<Condition> recordConditions;
    private List<AggregateCondition> aggregateConditions;
    private ScrolledComposite scrolledPageComposite;
    private Composite pageComposite;
    private Group seriesGroup;
    private Label xSeriesLabel;
    private Text xSeriesText;
    private Button xSeriesChangeButton;
    private Button ySeriesCheckButton;
    private Text ySeriesText;
    private Button ySeriesChangeButton;
    private Composite conditionsComposite;
    private Group recordConditionGroup;
    private org.eclipse.swt.widgets.List recordConditionList;
    private ListViewer recordConditionListViewer;
    private Button recordConditionAddButton;
    private Button recordConditionEditButton;
    private Button recordConditionRemoveButton;
    private Group aggregateConditionGroup;
    private org.eclipse.swt.widgets.List aggregateConditionList;
    private ListViewer aggregateConditionListViewer;
    private Button aggregateConditionAddButton;
    private Button aggregateConditionEditButton;
    private Button aggregateConditionRemoveButton;
    private Composite resultsOptionsComposite;
    private Composite sortResultsComposite;
    private Button sortResultsCheck;
    private Button sortDescendingCheck;
    private Button groupCheck;
    private Composite limitResultsComposite;
    private Button limitResultsCheck;
    private Composite limitSelectComposite;
    private Label limitSelectTopPrefixLabel;
    private Text limitSelectTopText;
    private Label limitSelectTopSuffixLabel;
    private Group queryResultGroup;
    private Label queryLabel;
    private Composite queryButtonComposite;
    private Button freeformSQLQueryCheck;
    private Button enableInterfaceButton;
    private Button validateButton;
    private Text sqlQueryTextBox;

    public ChartFunctionWizardDataPage(String pageName, DatabaseManager database, ChartFunction model) {
        super(Objects.requireNonNull(pageName, "Must specify a non-null pageName."));
        this.database = database;
        this.model = model;
        this.queryBuilder = new SQLQueryBuilder();
        this.setTitle(Messages.ChartFunctionWizardDataPage_ChartDataPageTitle);
    }

    public void createControl(Composite parent) {
        GridData textData = new GridData(4, -1, true, true, 1, 1);
        textData.widthHint = 200;
        GridData smallTextData = GUI.grid.d.horiz((int)16384, (boolean)false, (int)1);
        smallTextData.widthHint = 25;
        this.scrolledPageComposite = new ScrolledComposite(parent, 768);
        this.scrolledPageComposite.setLayoutData((Object)GUI.grid.d.fillAll());
        this.scrolledPageComposite.setExpandHorizontal(true);
        this.scrolledPageComposite.setExpandVertical(true);
        this.pageComposite = GUI.composite((Composite)this.scrolledPageComposite, (Layout)GUI.grid.l.noMargins((int)1, (boolean)true), (Object)GUI.grid.d.fillAll());
        this.scrolledPageComposite.setContent((Control)this.pageComposite);
        this.seriesGroup = GUI.group((Composite)this.pageComposite, (String)Messages.ChartFunctionWizardDataPage_DataSeriesGroupTitle, (Layout)GUI.grid.l.margins((int)6, (boolean)false), (Object)GUI.grid.d.horiz((int)4, (boolean)true, (int)1));
        this.xSeriesLabel = GUI.label((Composite)this.seriesGroup, (String)Messages.ChartFunctionWizardDataPage_XSeriesLabel, (Object)GUI.grid.d.left1(), (int)0);
        this.xSeriesText = GUI.text((Composite)this.seriesGroup, (Object)textData, (int)12);
        this.xSeriesChangeButton = GUI.button.push((Composite)this.seriesGroup, (String)Messages.ChartFunctionWizardDataPage_ChangeButton, (Object)GUI.grid.d.left1());
        this.ySeriesCheckButton = GUI.button((Composite)this.seriesGroup, (String)Messages.ChartFunctionWizardDataPage_YSeriesLabel, (Object)GUI.grid.d.left1(), (int)32);
        this.ySeriesCheckButton.setToolTipText(Messages.ChartFunctionWizardDataPage_ySeriesCheckToolTip);
        this.ySeriesText = GUI.text((Composite)this.seriesGroup, (Object)textData, (int)12);
        this.ySeriesChangeButton = GUI.button.push((Composite)this.seriesGroup, (String)"Change...", (Object)GUI.grid.d.left1());
        this.conditionsComposite = GUI.composite((Composite)this.pageComposite, (Layout)GUI.grid.l.noMargins((int)2, (boolean)true), (Object)GUI.grid.d.fillAll());
        GridData listData = new GridData(4, 4, true, true, 3, 4);
        listData.heightHint = 100;
        this.recordConditionGroup = GUI.group((Composite)this.conditionsComposite, (String)Messages.ChartFunctionWizardDataPage_RecordConditionsGroupTitle, (Layout)GUI.grid.l.margins((int)3, (boolean)true), (Object)GUI.grid.d.fillAll());
        this.recordConditionList = new org.eclipse.swt.widgets.List((Composite)this.recordConditionGroup, 2564);
        this.recordConditionList.setLayoutData((Object)listData);
        this.recordConditionList.setToolTipText(Messages.ChartFunctionWizardDataPage_RecordConditionsToolTip);
        this.recordConditionListViewer = new ListViewer(this.recordConditionList);
        this.recordConditionListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.recordConditionAddButton = GUI.button.push((Composite)this.recordConditionGroup, (String)Messages.ChartFunctionWizardDataPage_AddConditionButton, (Object)GUI.grid.d.standard());
        this.recordConditionEditButton = GUI.button.push((Composite)this.recordConditionGroup, (String)Messages.ChartFunctionWizardDataPage_EditConditionButton, (Object)GUI.grid.d.standard());
        this.recordConditionRemoveButton = GUI.button.push((Composite)this.recordConditionGroup, (String)Messages.ChartFunctionWizardDataPage_RemoveConditionButton, (Object)GUI.grid.d.standard());
        this.aggregateConditionGroup = GUI.group((Composite)this.conditionsComposite, (String)Messages.ChartFunctionWizardDataPage_AggregateConditionsGroupTitle, (Layout)GUI.grid.l.margins((int)3, (boolean)true), (Object)GUI.grid.d.fillAll());
        this.aggregateConditionList = new org.eclipse.swt.widgets.List((Composite)this.aggregateConditionGroup, 2564);
        this.aggregateConditionList.setLayoutData((Object)listData);
        this.aggregateConditionList.setToolTipText(Messages.ChartFunctionWizardDataPage_AggregateConditionsToolTip);
        this.aggregateConditionListViewer = new ListViewer(this.aggregateConditionList);
        this.aggregateConditionListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.aggregateConditionAddButton = GUI.button.push((Composite)this.aggregateConditionGroup, (String)"Add...", (Object)GUI.grid.d.standard());
        this.aggregateConditionEditButton = GUI.button.push((Composite)this.aggregateConditionGroup, (String)"Edit...", (Object)GUI.grid.d.standard());
        this.aggregateConditionRemoveButton = GUI.button.push((Composite)this.aggregateConditionGroup, (String)"Remove...", (Object)GUI.grid.d.standard());
        this.resultsOptionsComposite = GUI.composite((Composite)this.pageComposite, (Layout)GUI.grid.l.margins((int)2, (boolean)true), (Object)GUI.grid.d.fillAll());
        this.sortResultsComposite = GUI.composite((Composite)this.resultsOptionsComposite, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)GUI.grid.d.fillAll());
        this.sortResultsCheck = GUI.button((Composite)this.sortResultsComposite, (String)Messages.ChartFunctionWizardDataPage_SortResultsCheckLabel, (Object)GUI.grid.d.standard(), (int)32);
        this.sortResultsCheck.setToolTipText(Messages.ChartFunctionWizardDataPage_SortResultsToolTip);
        this.sortDescendingCheck = GUI.button((Composite)this.sortResultsComposite, (String)Messages.ChartFunctionWizardDataPage_SortDescendingCheckLabel, (Object)GUI.grid.d.standard(), (int)32);
        this.sortDescendingCheck.setToolTipText(Messages.ChartFunctionWizardDataPage_SortDescendingToolTip);
        this.groupCheck = GUI.button((Composite)this.sortResultsComposite, (String)Messages.ChartFunctionWizardDataPage_GroupDataCheckLabel, (Object)GUI.grid.d.standard(), (int)32);
        this.groupCheck.setToolTipText(Messages.ChartFunctionWizardDataPage_GroupDataToolTip);
        this.limitResultsComposite = GUI.composite((Composite)this.resultsOptionsComposite, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.limitResultsCheck = GUI.button((Composite)this.limitResultsComposite, (String)Messages.ChartFunctionWizardDataPage_LimitResultsCheckLabel, (Object)GUI.grid.d.horiz((int)16384, (boolean)true, (int)3), (int)32);
        this.limitResultsCheck.setToolTipText(Messages.ChartFunctionWizardDataPage_LimitResultsToolTip);
        this.limitSelectComposite = GUI.composite((Composite)this.limitResultsComposite, (Layout)GUI.grid.l.noMargins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.limitSelectTopPrefixLabel = GUI.label((Composite)this.limitSelectComposite, (String)"Select top ", (Object)GUI.grid.d.left1(), (int)0);
        this.limitSelectTopText = GUI.text((Composite)this.limitSelectComposite, (Object)smallTextData, (int)4);
        this.limitSelectTopText.setTextLimit(5);
        this.limitSelectTopSuffixLabel = GUI.label((Composite)this.limitSelectComposite, (String)" results.", (Object)GUI.grid.d.left1(), (int)0);
        GridData queryBoxData = GUI.grid.d.fillAll();
        queryBoxData.heightHint = 100;
        queryBoxData.widthHint = 400;
        this.queryResultGroup = GUI.group((Composite)this.pageComposite, (String)Messages.ChartFunctionWizardDataPage_OutputQueryGroupTitle, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.queryResultGroup.setToolTipText(Messages.ChartFunctionWizardDataPage_OutputQueryToolTip);
        this.queryButtonComposite = GUI.composite((Composite)this.queryResultGroup, (Layout)GUI.grid.l.noMargins((int)3, (boolean)false), (Object)GUI.grid.d.left1());
        this.freeformSQLQueryCheck = GUI.button((Composite)this.queryButtonComposite, (String)Messages.ChartFunctionWizardDataPage_DirectlyEditQueryCheckLabel, (Object)GUI.grid.d.left1(), (int)32);
        this.enableInterfaceButton = GUI.button.push((Composite)this.queryButtonComposite, (String)Messages.ChartFunctionWizardDataPage_EnableInterfaceButton, (Object)GUI.grid.d.left1());
        this.enableInterfaceButton.setToolTipText(Messages.ChartFunctionWizardDataPage_EnableInterfaceToolTip);
        this.validateButton = GUI.button.push((Composite)this.queryButtonComposite, (String)Messages.ChartFunctionWizardDataPage_ValidateQueryButton, (Object)GUI.grid.d.left1());
        this.validateButton.setToolTipText(Messages.ChartFunctionWizardDataPage_ValidateQueryToolTip);
        this.sqlQueryTextBox = GUI.text((Composite)this.queryResultGroup, (Object)queryBoxData, (int)578);
        this.sqlQueryTextBox.setTextLimit(10000);
        this.scrolledPageComposite.setMinSize(this.pageComposite.computeSize(-1, -1));
        this.createListeners();
        this.setControl((Control)this.scrolledPageComposite);
    }

    private void createListeners() {
        this.xSeriesChangeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SeriesDefDialog dialog = new SeriesDefDialog(ChartFunctionWizardDataPage.this.database, ChartFunctionWizardDataPage.this.xSeries.get(0));
                dialog.open();
                ChartFunctionWizardDataPage.this.xSeriesText.setText(ChartFunctionWizardDataPage.this.xSeries.get(0).toString());
                ChartFunctionWizardDataPage.this.refreshYSeries();
                ChartFunctionWizardDataPage.this.buildQueryString();
            }
        });
        this.ySeriesCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartFunctionWizardDataPage.this.refreshYSeries();
                ChartFunctionWizardDataPage.this.buildQueryString();
            }
        });
        this.ySeriesChangeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SeriesDefDialog dialog = new SeriesDefDialog(ChartFunctionWizardDataPage.this.database, ChartFunctionWizardDataPage.this.ySeries.get(0));
                dialog.open();
                ChartFunctionWizardDataPage.this.ySeriesText.setText(ChartFunctionWizardDataPage.this.ySeries.get(0).toString());
                ChartFunctionWizardDataPage.this.buildQueryString();
            }
        });
        this.recordConditionAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Condition tentativeCondition = new Condition();
                ConditionDialog dialog = new ConditionDialog(ChartFunctionWizardDataPage.this.database, tentativeCondition);
                if (dialog.open() == 0) {
                    ChartFunctionWizardDataPage.this.recordConditions.add(tentativeCondition);
                }
                ChartFunctionWizardDataPage.this.recordConditionListViewer.refresh();
                ChartFunctionWizardDataPage.this.buildQueryString();
            }
        });
        this.recordConditionEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Condition selected = (Condition)((IStructuredSelection)ChartFunctionWizardDataPage.this.recordConditionListViewer.getSelection()).getFirstElement();
                if (selected != null) {
                    ConditionDialog dialog = new ConditionDialog(ChartFunctionWizardDataPage.this.database, selected);
                    dialog.open();
                    ChartFunctionWizardDataPage.this.recordConditionListViewer.refresh();
                    ChartFunctionWizardDataPage.this.buildQueryString();
                }
            }
        });
        this.recordConditionRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Condition selected = (Condition)((IStructuredSelection)ChartFunctionWizardDataPage.this.recordConditionListViewer.getSelection()).getFirstElement();
                if (selected != null && PDDialogs.openConfirmThreadSafe((String)Messages.ChartFunctionWizardDataPage_DeleteConditionDialogTitle, (String)Messages.ChartFunctionWizardDataPage_DeleteConditionDialogMessage)) {
                    ChartFunctionWizardDataPage.this.recordConditions.remove(selected);
                    ChartFunctionWizardDataPage.this.recordConditionList.select(FAAnalyticsUtility.adjustCurrentSelection(ChartFunctionWizardDataPage.this.recordConditionList.getFocusIndex()));
                    ChartFunctionWizardDataPage.this.recordConditionListViewer.refresh();
                    ChartFunctionWizardDataPage.this.buildQueryString();
                }
            }
        });
        this.aggregateConditionAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AggregateCondition tentativeCondition = new AggregateCondition();
                ConditionDialog dialog = new ConditionDialog(ChartFunctionWizardDataPage.this.database, tentativeCondition);
                if (dialog.open() == 0) {
                    ChartFunctionWizardDataPage.this.aggregateConditions.add(tentativeCondition);
                }
                ChartFunctionWizardDataPage.this.aggregateConditionListViewer.refresh();
                ChartFunctionWizardDataPage.this.buildQueryString();
            }
        });
        this.aggregateConditionEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AggregateCondition selected = (AggregateCondition)((IStructuredSelection)ChartFunctionWizardDataPage.this.aggregateConditionListViewer.getSelection()).getFirstElement();
                if (selected != null) {
                    ConditionDialog dialog = new ConditionDialog(ChartFunctionWizardDataPage.this.database, selected);
                    dialog.open();
                    ChartFunctionWizardDataPage.this.aggregateConditionListViewer.refresh();
                    ChartFunctionWizardDataPage.this.buildQueryString();
                }
            }
        });
        this.aggregateConditionRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Condition selected = (Condition)((IStructuredSelection)ChartFunctionWizardDataPage.this.aggregateConditionListViewer.getSelection()).getFirstElement();
                if (selected != null && PDDialogs.openConfirmThreadSafe((String)"Delete Condition?", (String)"Are you sure you want to delete this condition?")) {
                    ChartFunctionWizardDataPage.this.aggregateConditions.remove(selected);
                    ChartFunctionWizardDataPage.this.aggregateConditionList.select(FAAnalyticsUtility.adjustCurrentSelection(ChartFunctionWizardDataPage.this.aggregateConditionList.getFocusIndex()));
                    ChartFunctionWizardDataPage.this.aggregateConditionListViewer.refresh();
                    ChartFunctionWizardDataPage.this.buildQueryString();
                }
            }
        });
        this.sortResultsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartFunctionWizardDataPage.this.sortDescendingCheck.setEnabled(ChartFunctionWizardDataPage.this.sortResultsCheck.getSelection());
                ChartFunctionWizardDataPage.this.buildQueryString();
            }
        });
        this.sortDescendingCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartFunctionWizardDataPage.this.buildQueryString();
            }
        });
        this.groupCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartFunctionWizardDataPage.this.enableAggregateConditionGroup(ChartFunctionWizardDataPage.this.groupCheck.getSelection());
                ChartFunctionWizardDataPage.this.buildQueryString();
            }
        });
        this.limitResultsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartFunctionWizardDataPage.this.limitSelectTopText.setEnabled(ChartFunctionWizardDataPage.this.limitResultsCheck.getSelection());
            }
        });
        this.limitResultsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartFunctionWizardDataPage.this.model.setLimitResults(ChartFunctionWizardDataPage.this.limitResultsCheck.getSelection());
            }
        });
        this.limitSelectTopText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                block2: {
                    String currentContents = ((Text)e.widget).getText();
                    String wholeLimitNumber = currentContents.substring(0, e.start) + e.text + currentContents.substring(e.end);
                    try {
                        ChartFunctionWizardDataPage.this.model.setResultsLimit(Integer.valueOf(wholeLimitNumber.trim()));
                    }
                    catch (NumberFormatException e1) {
                        if (wholeLimitNumber.equals("")) break block2;
                        e.doit = false;
                    }
                }
            }
        });
        this.freeformSQLQueryCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartFunctionWizardDataPage.this.sqlQueryTextBox.setEnabled(ChartFunctionWizardDataPage.this.freeformSQLQueryCheck.getSelection());
            }
        });
        this.enableInterfaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PDDialogs.openConfirmThreadSafe((String)Messages.ChartFunctionWizardDataPage_ReactivateQueryInterfaceDialogTitle, (String)Messages.ChartFunctionWizardDataPage_ReactivateQueryInterfaceDialogWarningMessage)) {
                    ChartFunctionWizardDataPage.this.parseModelQuery();
                    ChartFunctionWizardDataPage.this.enableQueryBuilderInterface(true);
                }
            }
        });
        this.validateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLException exception = ChartFunctionWizardDataPage.this.validateSQLQuery();
                if (exception == null) {
                    PDDialogs.openInfoThreadSafe((String)Messages.ChartFunctionWizardDataPage_ValidationSuccessfulDialogTitle, (String)Messages.ChartFunctionWizardDataPage_ValidationSuccessfulDialogMessage);
                } else {
                    PDDialogs.openErrorThreadSafe((String)Messages.ChartFunctionWizardDataPage_ValidationErrorDialogTitle, (String)MessageFormat.format(Messages.ChartFunctionWizardDataPage_ValidationErrorDialogMessage, exception.getMessage()));
                }
            }
        });
        this.sqlQueryTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChartFunctionWizardDataPage.this.model.setQuery(ChartFunctionWizardDataPage.this.sqlQueryTextBox.getText());
            }
        });
    }

    private void refreshYSeries() {
        if (this.ySeriesCheckButton.getSelection()) {
            this.ySeriesChangeButton.setEnabled(true);
            this.ySeriesText.setEnabled(true);
            this.ySeriesText.setText(this.ySeries.isEmpty() ? "" : this.ySeries.get(0).toString());
        } else {
            this.ySeriesChangeButton.setEnabled(false);
            this.ySeriesText.setEnabled(false);
            if (this.xSeries.isEmpty()) {
                this.ySeriesText.setText("");
            } else {
                this.ySeriesText.setText(new SeriesDef(FREQUENCY_DUPLICATES_COLUMN, "", AggregateType.SUMPLUS, false, false).toString());
            }
        }
    }

    private static boolean isYSeriesFrequency(SeriesDef xParsedSeries, SeriesDef yParsedSeries) {
        return !yParsedSeries.getAggregateFunction().equals((Object)AggregateType.COUNT) || !yParsedSeries.getBaseColumn().equals(xParsedSeries.getBaseColumn()) || yParsedSeries.isDistinct();
    }

    private void buildQueryString() {
        ArrayList<SeriesDef> frequency = new ArrayList<SeriesDef>();
        frequency.add(new SeriesDef(FREQUENCY_DUPLICATES_COLUMN, "", AggregateType.SUMPLUS, false, false));
        this.queryBuilder.setSelectedXSeries(this.xSeries);
        if (this.ySeriesCheckButton.getSelection()) {
            this.queryBuilder.setSelectedYSeries(this.ySeries);
        } else {
            this.queryBuilder.setSelectedYSeries(frequency);
        }
        this.queryBuilder.setWhereClauseConditions(this.recordConditions);
        this.queryBuilder.setHavingClauseConditions(this.aggregateConditions);
        if (!this.xSeries.isEmpty() && this.groupCheck.getSelection()) {
            this.queryBuilder.setGroupBySeries(this.xSeries.get(0));
        } else {
            this.queryBuilder.setGroupBySeries(null);
        }
        if (this.sortResultsCheck.getSelection()) {
            if (this.ySeriesCheckButton.getSelection() && !this.ySeries.isEmpty()) {
                this.queryBuilder.setOrderBySeries(this.ySeries.get(0));
            } else {
                this.queryBuilder.setOrderBySeries((SeriesDef)frequency.get(0));
            }
        } else {
            this.queryBuilder.setOrderBySeries(null);
        }
        this.queryBuilder.setOrderDescending(this.sortDescendingCheck.getSelection());
        String query = this.queryBuilder.buildQueryString();
        this.sqlQueryTextBox.setText(query);
    }

    public void onPageOpen() {
        boolean limitResults = this.model.isLimitResults();
        int resultsLimit = this.model.getResultsLimit();
        this.ySeriesCheckButton.setSelection(false);
        this.sqlQueryTextBox.setText(this.model.getQuery());
        boolean parseSuccessful = this.parseModelQuery();
        this.freeformSQLQueryCheck.setSelection(false);
        this.sqlQueryTextBox.setEnabled(false);
        this.limitResultsCheck.setSelection(limitResults);
        this.limitSelectTopText.setText("" + resultsLimit);
        this.limitSelectTopText.setEnabled(limitResults);
        if (this.xSeries.get(0).getBaseColumn().isEmpty()) {
            this.xSeries.get(0).setBaseColumn("ABEND");
        }
        this.xSeriesText.setText(this.xSeries.get(0).toString());
        this.ySeriesText.setText(this.ySeries.get(0).toString());
        this.recordConditionListViewer.setInput(this.recordConditions);
        this.aggregateConditionListViewer.setInput(this.aggregateConditions);
        this.buildQueryString();
        if (!parseSuccessful) {
            this.enableQueryBuilderInterface(false);
        } else {
            this.enableQueryBuilderInterface(true);
        }
    }

    private void enableAggregateConditionGroup(boolean enable) {
        this.aggregateConditionAddButton.setEnabled(enable);
        this.aggregateConditionEditButton.setEnabled(enable);
        this.aggregateConditionRemoveButton.setEnabled(enable);
        this.aggregateConditionList.setEnabled(enable);
    }

    private void enableQueryBuilderInterface(boolean enable) {
        this.xSeriesChangeButton.setEnabled(enable);
        this.xSeriesText.setText(this.xSeries.get(0).toString());
        this.ySeriesCheckButton.setEnabled(enable);
        this.ySeriesChangeButton.setEnabled(this.ySeriesCheckButton.getSelection() && enable);
        this.ySeriesText.setEnabled(this.ySeriesCheckButton.getSelection() && enable);
        this.ySeriesText.setText(this.ySeries.get(0).toString());
        this.recordConditionList.setEnabled(enable);
        this.recordConditionAddButton.setEnabled(enable);
        this.recordConditionEditButton.setEnabled(enable);
        this.recordConditionRemoveButton.setEnabled(enable);
        this.recordConditionListViewer.setInput(this.recordConditions);
        this.recordConditionListViewer.refresh();
        this.enableAggregateConditionGroup(this.groupCheck.getSelection() && enable);
        this.aggregateConditionListViewer.setInput(this.aggregateConditions);
        this.aggregateConditionListViewer.refresh();
        this.sortResultsCheck.setEnabled(enable);
        this.sortDescendingCheck.setEnabled(enable ? this.sortResultsCheck.getSelection() : enable);
        this.groupCheck.setEnabled(enable);
        this.freeformSQLQueryCheck.setEnabled(enable);
        this.freeformSQLQueryCheck.setSelection(!enable);
        this.enableInterfaceButton.setEnabled(!enable);
        this.sqlQueryTextBox.setEnabled(!enable);
        if (enable) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(Messages.ChartFunctionWizardDataPage_QueryStringNotParsedDisablingInterface);
        }
    }

    private boolean parseModelQuery() {
        boolean successful;
        block16: {
            SQLQueryParser queryParser = new SQLQueryParser(this.database, this.model.getQuery());
            successful = true;
            this.xSeries = new ArrayList<SeriesDef>();
            this.ySeries = new ArrayList<SeriesDef>();
            this.recordConditions = new ArrayList<Condition>();
            this.aggregateConditions = new ArrayList<AggregateCondition>();
            try {
                if (queryParser.isMappingSuccessful()) {
                    if (!queryParser.parseTable()) {
                        throw new Exception("table parsing error.");
                    }
                    SeriesDef inputXSeries = queryParser.parseSeries(true);
                    this.xSeries.add(inputXSeries);
                    SeriesDef inputYSeries = queryParser.parseSeries(false);
                    this.ySeries.add(inputYSeries);
                    this.ySeriesCheckButton.setSelection(ChartFunctionWizardDataPage.isYSeriesFrequency(inputXSeries, inputYSeries));
                    if (queryParser.isWhereExists()) {
                        this.recordConditions = queryParser.parseRecordConditions();
                    }
                    if (queryParser.isGroupExists()) {
                        this.groupCheck.setSelection(true);
                        String groupString = queryParser.parseGrouping();
                        if (!this.xSeries.get(0).getSeriesReference().equals(groupString)) {
                            throw new Exception("groupString error");
                        }
                    } else {
                        this.groupCheck.setSelection(false);
                    }
                    if (queryParser.isHavingExists()) {
                        this.aggregateConditions = queryParser.parseAggregateConditions();
                    }
                    if (queryParser.isOrderExists()) {
                        this.sortResultsCheck.setSelection(true);
                        String orderSeries = queryParser.parseOrdering();
                        int orderType = queryParser.parseOrderingType();
                        switch (orderType) {
                            case -1: 
                            case 0: {
                                this.sortDescendingCheck.setSelection(false);
                                break;
                            }
                            default: {
                                this.sortDescendingCheck.setSelection(true);
                            }
                        }
                        if (!this.ySeries.get(0).getSeriesReference().equals(orderSeries)) {
                            throw new Exception("ySeries not equals orderSeries.");
                        }
                    } else {
                        this.sortDescendingCheck.setEnabled(false);
                        this.sortDescendingCheck.setSelection(true);
                    }
                    break block16;
                }
                throw new Exception("mapping not successful.");
            }
            catch (Exception e) {
                this.xSeries = new ArrayList<SeriesDef>();
                this.xSeries.add(new SeriesDef());
                this.ySeries = new ArrayList<SeriesDef>();
                this.ySeriesCheckButton.setSelection(false);
                this.ySeries.add(new SeriesDef());
                this.recordConditions = new ArrayList<Condition>();
                this.aggregateConditions = new ArrayList<AggregateCondition>();
                this.sortResultsCheck.setSelection(false);
                this.sortDescendingCheck.setSelection(true);
                this.groupCheck.setSelection(true);
                if (this.model.getQuery().isEmpty()) {
                    successful = true;
                }
                PDLogger.get(((Object)((Object)this)).getClass()).warn(new Object[]{Messages.ChartFunctionWizardDataPage_LoggerDisablingInterface, this.model.getQuery(), e});
                successful = false;
            }
        }
        return successful;
    }

    public SQLException validateSQLQuery() {
        try {
            this.database.queryDatabase(this.model.getQuery(), 0);
            return null;
        }
        catch (SQLException e1) {
            return e1;
        }
    }

    public IWizardPage getNextPage() {
        ChartFunctionWizardLabellingPage labelPage = ((ChartFunctionWizard)this.getWizard()).getLabelPage();
        return labelPage;
    }
}

