/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.analytics.ui.wizard;

import com.ibm.etools.fa.pdtclient.analytics.Messages;
import com.ibm.etools.fa.pdtclient.analytics.chart.AbstractChartBuilder;
import com.ibm.etools.fa.pdtclient.analytics.chart.ChartType;
import com.ibm.etools.fa.pdtclient.analytics.preferences.FAAnalyticsConstants;
import com.ibm.etools.fa.pdtclient.analytics.ui.view.model.ChartFunction;
import com.ibm.etools.fa.pdtclient.analytics.ui.view.model.ChartFunctionManager;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.ChartFunctionWizard;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.ChartFunctionWizardDataPage;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.ChartTypeLabelProvider;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.util.Objects;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ChartFunctionWizardChartTypePage
extends WizardPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private ChartFunctionManager manager;
    private ChartFunction chartFunctionModel;
    private DataBindingContext chartTypeContext;
    private DataBindingContext pieChartContext;
    private DataBindingContext barChartContext;
    private DataBindingContext lineChartContext;
    private IObservableValue<?> chartWidgetNameObservable;
    private IObservableValue<?> chartWidgetChartTypeObservable;
    private IObservableValue<?> chartModelNameObservable;
    private IObservableValue<?> chartModelChartTypeObservable;
    private IObservableValue<?> pieWidgetDonutObservable;
    private IObservableValue<?> pieWidgetExplodedObservable;
    private IObservableValue<?> pieWidget3DObservable;
    private IObservableValue<?> pieModelDonutObservable;
    private IObservableValue<?> pieModelExplodedObservable;
    private IObservableValue<?> pieModel3DObservable;
    private IObservableValue<?> barWidgetHorizontalObservable;
    private IObservableValue<?> barWidget3DObservable;
    private IObservableValue<?> barModelHorizontalObservable;
    private IObservableValue<?> barModel3DObservable;
    private IObservableValue<?> lineWidget3DObservable;
    private IObservableValue<?> lineModel3DObservable;
    private Composite pageComposite;
    private Composite chartTypeComposite;
    private Label chartNameLabel;
    private Label chartTypeLabel;
    private Text chartNameText;
    private Combo chartTypeCombo;
    private ComboViewer chartTypeComboViewer;
    private Composite chartOptionsStackComposite;
    private StackLayout optionsStackLayout;
    private Group pieChartOptionsGroup;
    private Button pieChartDonutOption;
    private Button pieChartExplodedOption;
    private Button pieChart3DOption;
    private Group barChartOptionsGroup;
    private Button barChartHorizontalOption;
    private Button barChart3DOption;
    private Group lineChartOptionsGroup;
    private Button lineChart3DOption;
    private Composite emptyOptionsComposite;

    public ChartFunctionWizardChartTypePage(String pageName, ChartFunctionManager manager, ChartFunction chartFunctionModel) {
        super(Objects.requireNonNull(pageName, "Must specify a non-null pageName."));
        this.manager = manager;
        this.chartFunctionModel = chartFunctionModel;
        this.setTitle(Messages.ChartFunctionWizardChartTypePage_ChartTypePageTitle);
        this.setDescription(Messages.ChartFunctionWizardChartTypePage_ChartTypePageMessage);
    }

    public void createControl(Composite parent) {
        this.pageComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)1, (boolean)true), (Object)GUI.grid.d.fillAll());
        this.optionsStackLayout = new StackLayout();
        this.chartTypeComposite = GUI.composite((Composite)this.pageComposite, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.chartNameLabel = GUI.label((Composite)this.chartTypeComposite, (String)Messages.ChartFunctionWizardChartTypePage_ChartNameLabel, (Object)GUI.grid.d.left1(), (int)0);
        this.chartNameText = GUI.text((Composite)this.chartTypeComposite, (Object)GUI.grid.d.fillH((int)1), (int)4);
        this.chartNameText.setTextLimit(255);
        this.chartTypeLabel = GUI.label((Composite)this.chartTypeComposite, (String)Messages.ChartFunctionWizardChartTypePage_ChartTypeLabel, (Object)GUI.grid.d.left1(), (int)0);
        this.chartTypeCombo = GUI.combo((Composite)this.chartTypeComposite, (Object)GUI.grid.d.fillH((int)1), (int)8);
        this.chartTypeComboViewer = new ComboViewer(this.chartTypeCombo);
        this.chartTypeComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.chartTypeComboViewer.setLabelProvider((IBaseLabelProvider)new ChartTypeLabelProvider());
        this.chartTypeComboViewer.setInput((Object)ChartType.values());
        this.chartOptionsStackComposite = GUI.composite((Composite)this.pageComposite, (Layout)this.optionsStackLayout, (Object)new GridData(4, 4, true, true, 1, 1));
        this.pieChartOptionsGroup = GUI.group((Composite)this.chartOptionsStackComposite, (String)Messages.ChartFunctionWizardChartTypePage_PieChartGroupTitle, (Layout)GUI.grid.l.margins((int)1, (boolean)true), null);
        this.pieChartDonutOption = GUI.button((Composite)this.pieChartOptionsGroup, (String)Messages.ChartFunctionWizardChartTypePage_DonutCheckLabel, (Object)GUI.grid.d.horiz((int)16384, (boolean)false, (int)1), (int)32);
        this.pieChartExplodedOption = GUI.button((Composite)this.pieChartOptionsGroup, (String)Messages.ChartFunctionWizardChartTypePage_ExplodedCheckLabel, (Object)GUI.grid.d.horiz((int)16384, (boolean)false, (int)1), (int)32);
        this.pieChart3DOption = GUI.button((Composite)this.pieChartOptionsGroup, (String)Messages.ChartFunctionWizardChartTypePage_3DCheckLabel, (Object)GUI.grid.d.horiz((int)16384, (boolean)false, (int)1), (int)32);
        this.barChartOptionsGroup = GUI.group((Composite)this.chartOptionsStackComposite, (String)Messages.ChartFunctionWizardChartTypePage_BarChartGroupTitle, (Layout)GUI.grid.l.margins((int)1, (boolean)true), null);
        this.barChartHorizontalOption = GUI.button((Composite)this.barChartOptionsGroup, (String)Messages.ChartFunctionWizardChartTypePage_HorizontalCheckLabel, (Object)GUI.grid.d.horiz((int)16384, (boolean)false, (int)1), (int)32);
        this.barChart3DOption = GUI.button((Composite)this.barChartOptionsGroup, (String)"3D Chart", (Object)GUI.grid.d.horiz((int)16384, (boolean)false, (int)1), (int)32);
        this.lineChartOptionsGroup = GUI.group((Composite)this.chartOptionsStackComposite, (String)Messages.ChartFunctionWizardChartTypePage_LineChartGroupTitle, (Layout)GUI.grid.l.margins((int)1, (boolean)true), null);
        this.lineChart3DOption = GUI.button((Composite)this.lineChartOptionsGroup, (String)"3D Chart", (Object)GUI.grid.d.horiz((int)16384, (boolean)false, (int)1), (int)32);
        this.emptyOptionsComposite = GUI.composite((Composite)this.chartOptionsStackComposite, null, null);
        this.setupChartTypeObservableValues();
        this.chartTypeCombo.notifyListeners(13, new Event());
        this.setControl((Control)this.pageComposite);
    }

    private void setupChartTypeObservableValues() {
        this.chartTypeContext = new DataBindingContext();
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.chartTypeContext);
        this.chartWidgetNameObservable = WidgetProperties.text((int)24).observe((Widget)this.chartNameText);
        this.chartWidgetChartTypeObservable = ViewerProperties.singleSelection().observe((Viewer)this.chartTypeComboViewer);
        this.chartModelNameObservable = PojoProperties.value((String)"name").observe((Object)this.chartFunctionModel);
        this.chartModelChartTypeObservable = PojoProperties.value((String)"chartBuilder").observe((Object)this.chartFunctionModel);
        this.chartModelChartTypeObservable.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                ChartFunctionWizardChartTypePage.this.chartTypeSelectionChanged();
            }
        });
        final String originalName = (String)this.chartModelNameObservable.getValue();
        UpdateValueStrategy updateNameStrategyWidgetToModel = new UpdateValueStrategy();
        updateNameStrategyWidgetToModel.setAfterConvertValidator(new IValidator(){

            public IStatus validate(Object value) {
                String inputValue = (String)value;
                if (inputValue == null || inputValue.isEmpty()) {
                    return ValidationStatus.error((String)Messages.ChartFunctionWizardChartTypePage_ValidateEnterChartFunctionName);
                }
                for (String s : FAAnalyticsConstants.INVALID_FILENAME_CHARACTERS) {
                    if (!inputValue.contains(s)) continue;
                    return ValidationStatus.error((String)Messages.ChartFunctionWizardChartTypePage_InvalidFileNameError);
                }
                if (!ChartFunctionWizardChartTypePage.this.manager.checkFunctionNameUnique(inputValue) && !inputValue.equals(originalName)) {
                    return ValidationStatus.error((String)Messages.ChartFunctionWizardChartTypePage_ValidateChartFunctionNameNotUnique);
                }
                return ValidationStatus.ok();
            }
        });
        UpdateValueStrategy updateChartTypeStrategyWidgetToModel = new UpdateValueStrategy();
        updateChartTypeStrategyWidgetToModel.setConverter(new IConverter(){

            public Object getFromType() {
                return ChartType.class;
            }

            public Object getToType() {
                return AbstractChartBuilder.class;
            }

            public Object convert(Object fromObject) {
                ChartType chartType = (ChartType)((Object)fromObject);
                return ChartType.chartTypeToChartBuilder(chartType);
            }
        });
        updateChartTypeStrategyWidgetToModel.setAfterConvertValidator(new IValidator(){

            public IStatus validate(Object value) {
                AbstractChartBuilder inputValue = (AbstractChartBuilder)value;
                if (inputValue == null) {
                    return ValidationStatus.error((String)Messages.ChartFunctionWizardChartTypePage_ValidateInvalidChartType);
                }
                return ValidationStatus.ok();
            }
        });
        UpdateValueStrategy updateChartTypeStrategyModelToWidget = new UpdateValueStrategy();
        updateChartTypeStrategyModelToWidget.setConverter(new IConverter(){

            public Object getFromType() {
                return AbstractChartBuilder.class;
            }

            public Object getToType() {
                return ChartType.class;
            }

            public Object convert(Object fromObject) {
                AbstractChartBuilder chartBuilder = (AbstractChartBuilder)fromObject;
                if (chartBuilder == null) {
                    return ChartType.BAR;
                }
                return chartBuilder.getChartType();
            }
        });
        updateChartTypeStrategyModelToWidget.setAfterConvertValidator(new IValidator(){

            public IStatus validate(Object value) {
                ChartType inputValue = (ChartType)((Object)value);
                if (inputValue == null) {
                    return ValidationStatus.error((String)"A valid chart type must be selected.");
                }
                return ValidationStatus.ok();
            }
        });
        this.chartTypeContext.bindValue(this.chartWidgetNameObservable, this.chartModelNameObservable, updateNameStrategyWidgetToModel, updateNameStrategyWidgetToModel);
        this.chartTypeContext.bindValue(this.chartWidgetChartTypeObservable, this.chartModelChartTypeObservable, updateChartTypeStrategyWidgetToModel, updateChartTypeStrategyModelToWidget);
        this.chartTypeSelectionChanged();
    }

    private void chartTypeSelectionChanged() {
        ChartFunctionWizardChartTypePage currentPage = this;
        ChartType selected = (ChartType)((Object)((IStructuredSelection)currentPage.chartTypeComboViewer.getSelection()).getFirstElement());
        if (selected == null) {
            return;
        }
        this.disableActiveComposite();
        switch (selected) {
            case BAR: {
                currentPage.setupBarDataBinding();
                break;
            }
            case LINE: {
                currentPage.setupLineDataBinding();
                break;
            }
            case PIE: {
                currentPage.setupPieDataBinding();
                break;
            }
            case TEXT: {
                this.optionsStackLayout.topControl = this.emptyOptionsComposite;
                break;
            }
            default: {
                currentPage.optionsStackLayout.topControl = currentPage.emptyOptionsComposite;
                currentPage.pieChartOptionsGroup.setEnabled(false);
                currentPage.barChartOptionsGroup.setEnabled(false);
                currentPage.lineChartOptionsGroup.setEnabled(false);
            }
        }
        currentPage.chartOptionsStackComposite.layout();
    }

    private void setupPieDataBinding() {
        this.optionsStackLayout.topControl = this.pieChartOptionsGroup;
        this.pieChartOptionsGroup.setEnabled(true);
        this.pieWidgetDonutObservable = WidgetProperties.widgetSelection().observe((Widget)this.pieChartDonutOption);
        this.pieWidgetExplodedObservable = WidgetProperties.widgetSelection().observe((Widget)this.pieChartExplodedOption);
        this.pieWidget3DObservable = WidgetProperties.widgetSelection().observe((Widget)this.pieChart3DOption);
        this.pieModelDonutObservable = PojoProperties.value(AbstractChartBuilder.class, (String)"pieDonut").observe((Object)this.chartFunctionModel.getChartBuilder());
        this.pieModelExplodedObservable = PojoProperties.value(AbstractChartBuilder.class, (String)"pieExploded").observe((Object)this.chartFunctionModel.getChartBuilder());
        this.pieModel3DObservable = PojoProperties.value((String)"chart3D").observe((Object)this.chartFunctionModel.getChartBuilder());
        this.pieChartContext = new DataBindingContext();
        this.pieChartContext.bindValue(this.pieWidgetDonutObservable, this.pieModelDonutObservable);
        this.pieChartContext.bindValue(this.pieWidgetExplodedObservable, this.pieModelExplodedObservable);
        this.pieChartContext.bindValue(this.pieWidget3DObservable, this.pieModel3DObservable);
    }

    private void setupBarDataBinding() {
        this.optionsStackLayout.topControl = this.barChartOptionsGroup;
        this.barChartOptionsGroup.setEnabled(true);
        this.barWidgetHorizontalObservable = WidgetProperties.widgetSelection().observe((Widget)this.barChartHorizontalOption);
        this.barWidget3DObservable = WidgetProperties.widgetSelection().observe((Widget)this.barChart3DOption);
        this.barModelHorizontalObservable = PojoProperties.value((String)"barHorizontal").observe((Object)this.chartFunctionModel.getChartBuilder());
        this.barModel3DObservable = PojoProperties.value((String)"chart3D").observe((Object)this.chartFunctionModel.getChartBuilder());
        this.barChartContext = new DataBindingContext();
        this.barChartContext.bindValue(this.barWidgetHorizontalObservable, this.barModelHorizontalObservable);
        this.barChartContext.bindValue(this.barWidget3DObservable, this.barModel3DObservable);
    }

    private void setupLineDataBinding() {
        this.optionsStackLayout.topControl = this.lineChartOptionsGroup;
        this.lineChartOptionsGroup.setEnabled(true);
        this.lineWidget3DObservable = WidgetProperties.widgetSelection().observe((Widget)this.lineChart3DOption);
        this.lineModel3DObservable = PojoProperties.value((String)"chart3D").observe((Object)this.chartFunctionModel.getChartBuilder());
        this.lineChartContext = new DataBindingContext();
        this.lineChartContext.bindValue(this.lineWidget3DObservable, this.lineModel3DObservable);
    }

    private void disableActiveComposite() {
        if (this.optionsStackLayout.topControl == this.pieChartOptionsGroup) {
            this.pieChartOptionsGroup.setEnabled(false);
            this.pieModelDonutObservable.dispose();
            this.pieModelExplodedObservable.dispose();
            this.pieModel3DObservable.dispose();
            this.pieChartContext.dispose();
        }
        if (this.optionsStackLayout.topControl == this.barChartOptionsGroup) {
            this.barChartOptionsGroup.setEnabled(false);
            this.barModelHorizontalObservable.dispose();
            this.barModel3DObservable.dispose();
            this.barChartContext.dispose();
        }
        if (this.optionsStackLayout.topControl == this.lineChartOptionsGroup) {
            this.lineChartOptionsGroup.setEnabled(false);
            this.lineModel3DObservable.dispose();
            this.lineChartContext.dispose();
        }
    }

    public IWizardPage getNextPage() {
        ChartFunctionWizardDataPage dataPage = ((ChartFunctionWizard)this.getWizard()).getDataPage();
        return dataPage;
    }
}

