/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.analytics.ui.wizard;

import com.ibm.etools.fa.pdtclient.analytics.Messages;
import com.ibm.etools.fa.pdtclient.analytics.data.DatabaseManager;
import com.ibm.etools.fa.pdtclient.analytics.ui.view.model.ChartFunction;
import com.ibm.etools.fa.pdtclient.analytics.ui.view.model.ChartFunctionManager;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.ChartFunctionWizardChartTypePage;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.ChartFunctionWizardDataPage;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.ChartFunctionWizardLabellingPage;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.sql.SQLException;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;

public class ChartFunctionWizard
extends Wizard
implements IPageChangingListener {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int MIN_WIZARD_WIDTH = 640;
    private static final int MIN_WIZARD_HEIGHT = 500;
    private DatabaseManager database;
    private ChartFunctionManager functionManager;
    private ChartFunction model;
    private ChartFunction tentativeModel;
    private WizardPage openPage;
    private ChartFunctionWizardChartTypePage chartTypePage;
    private ChartFunctionWizardDataPage dataPage;
    private ChartFunctionWizardLabellingPage labelPage;

    public ChartFunctionWizard(DatabaseManager database, ChartFunctionManager functionManager, ChartFunction function) {
        this.database = database;
        this.functionManager = functionManager;
        if (function == null) {
            throw new IllegalArgumentException("Must specify a non-null ChartFunction.");
        }
        this.model = function;
        try {
            this.tentativeModel = this.model.clone();
        }
        catch (CloneNotSupportedException e) {
            PDLogger.get(((Object)((Object)this)).getClass()).error((Object)"CloneNotSupportedException exception has occurred.", (Throwable)e);
            throw new RuntimeException();
        }
    }

    public String getWindowTitle() {
        return Messages.ChartFunctionWizard_ChartFunctionWizardTitle;
    }

    public void addPages() {
        this.getShell().setMinimumSize(640, 500);
        this.chartTypePage = new ChartFunctionWizardChartTypePage(Messages.ChartFunctionWizard_ChartTypePageName, this.functionManager, this.tentativeModel);
        this.dataPage = new ChartFunctionWizardDataPage(Messages.ChartFunctionWizard_DataPageName, this.database, this.tentativeModel);
        this.labelPage = new ChartFunctionWizardLabellingPage(Messages.ChartFunctionWizard_LabelPageName, this.tentativeModel);
        this.addPage((IWizardPage)this.chartTypePage);
        this.addPage((IWizardPage)this.dataPage);
        this.addPage((IWizardPage)this.labelPage);
        WizardDialog dialog = (WizardDialog)this.getContainer();
        this.openPage = this.chartTypePage;
        dialog.addPageChangingListener((IPageChangingListener)this);
    }

    public void handlePageChanging(PageChangingEvent event) {
        SQLException exception;
        if (event.getCurrentPage() == this.dataPage && event.getTargetPage() != this.chartTypePage && (exception = this.dataPage.validateSQLQuery()) != null) {
            PDDialogs.openErrorThreadSafe((String)Messages.ChartFunctionWizard_SQLErrorDialogTitle, (String)MessageFormat.format(Messages.ChartFunctionWizard_SQLErrorDialogMessage, exception.getMessage()));
            event.doit = false;
            return;
        }
        if (event.getTargetPage() == this.dataPage) {
            this.dataPage.onPageOpen();
        }
        if (event.getTargetPage() == this.labelPage) {
            this.labelPage.onPageOpen();
        }
        this.openPage = (WizardPage)event.getTargetPage();
    }

    public boolean canFinish() {
        SQLException exception = this.dataPage.validateSQLQuery();
        return exception == null && this.tentativeModel.getName() != null && !this.tentativeModel.getName().isEmpty() && this.tentativeModel.getChartBuilder() != null;
    }

    public boolean performFinish() {
        SQLException exception = this.dataPage.validateSQLQuery();
        if (exception != null) {
            PDDialogs.openErrorThreadSafe((String)"Syntax Error", (String)("An SQL syntax error was encountered: " + exception.getMessage()));
            return false;
        }
        this.model.setName(this.tentativeModel.getName());
        this.model.setChartBuilder(this.tentativeModel.getChartBuilder());
        this.model.setQuery(this.tentativeModel.getQuery());
        this.model.setLimitResults(this.tentativeModel.isLimitResults());
        this.model.setResultsLimit(this.tentativeModel.getResultsLimit());
        this.functionManager.notifyObservers();
        return true;
    }

    public DatabaseManager getDatabase() {
        return this.database;
    }

    public void setDatabase(DatabaseManager database) {
        this.database = database;
    }

    public ChartFunction getModel() {
        return this.model;
    }

    public void setModel(ChartFunction model) {
        this.model = model;
    }

    public ChartFunction getTentativeModel() {
        return this.tentativeModel;
    }

    public void setTentativeModel(ChartFunction tentativeModel) {
        this.tentativeModel = tentativeModel;
    }

    public ChartFunctionWizardChartTypePage getChartTypePage() {
        return this.chartTypePage;
    }

    public void setChartTypePage(ChartFunctionWizardChartTypePage chartTypePage) {
        this.chartTypePage = chartTypePage;
    }

    public ChartFunctionWizardDataPage getDataPage() {
        return this.dataPage;
    }

    public void setDataPage(ChartFunctionWizardDataPage dataPage) {
        this.dataPage = dataPage;
    }

    public ChartFunctionWizardLabellingPage getLabelPage() {
        return this.labelPage;
    }

    public void setLabelPage(ChartFunctionWizardLabellingPage labelPage) {
        this.labelPage = labelPage;
    }
}

