/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.analytics.ui.view.model;

import com.ibm.etools.fa.pdtclient.analytics.ui.view.model.ChartFunction;
import com.ibm.etools.fa.pdtclient.analytics.util.MementoParser;
import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.core.MementoUtils;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.IResourceUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Observable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.osgi.framework.Bundle;

public class ChartFunctionManager
extends Observable {
    private static IFolder mementoFolder = FACorePlugin.getRoot().getFolder("analytics_charts");
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final PDLogger logger = PDLogger.get(ChartFunctionManager.class);
    private List<ChartFunction> chartFunctionList = new ArrayList<ChartFunction>();

    public ChartFunctionManager() {
        this.loadDefaultChartDefinitionFiles();
        this.loadContentsFromFiles();
    }

    private void loadDefaultChartDefinitionFiles() {
        Bundle bundle = Platform.getBundle((String)"com.ibm.etools.fa.pdtclient.analytics");
        if (bundle != null) {
            try {
                File[] fileArray = new File(FileLocator.toFileURL((URL)bundle.getEntry("analytics_charts")).getFile()).listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File internalChartFile = fileArray[n2];
                    ChartFunction defaultChartFunction = ChartFunctionManager.loadFunctionFromFile((IMemento)MementoUtils.loadXMLMementoFromString((String)new String(Files.readAllBytes(internalChartFile.toPath()), StandardCharsets.UTF_8)));
                    defaultChartFunction.setReadOnly(true);
                    this.addChartFunction(defaultChartFunction);
                    ++n2;
                }
            }
            catch (IOException e) {
                this.logger.error((Object)"Could not load default chart functions. ", (Throwable)e);
            }
        } else {
            this.logger.error((Object)"Plugin bundle could not be found");
        }
    }

    public boolean checkFunctionNameUnique(String chartFunctionName) {
        if (chartFunctionName != null) {
            for (ChartFunction chartFunction : this.chartFunctionList) {
                if (chartFunction.getName().compareTo(chartFunctionName) != 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean addChartFunction(ChartFunction chartFunction) {
        if (chartFunction != null && this.checkFunctionNameUnique(chartFunction.getName())) {
            this.chartFunctionList.add(chartFunction);
            this.setChanged();
            this.notifyObservers();
            return true;
        }
        return false;
    }

    public boolean duplicateAndAddChartFunction(ChartFunction chartFunction) {
        if (chartFunction != null) {
            ChartFunction duplicateChartFunction = this.duplicateChartFunction(chartFunction);
            boolean result = this.addChartFunction(duplicateChartFunction);
            if (result) {
                ChartFunctionManager.saveFunctionToFile(duplicateChartFunction);
            }
            return result;
        }
        return false;
    }

    public ChartFunction duplicateChartFunction(ChartFunction chartFunction) {
        if (chartFunction != null) {
            try {
                ChartFunction duplicateChartFunction = chartFunction.clone();
                int nameNumber = 0;
                while (!this.checkFunctionNameUnique(duplicateChartFunction.getName())) {
                    duplicateChartFunction.setName(chartFunction.getName() + " " + ++nameNumber);
                }
                return duplicateChartFunction;
            }
            catch (CloneNotSupportedException e) {
                this.logger.error((Object)"Chart could not be cloned: ", (Throwable)e);
            }
        }
        return null;
    }

    public boolean removeChartFunction(ChartFunction chartFunction) {
        boolean result = this.chartFunctionList.remove(chartFunction);
        if (result) {
            IResourceUtils.deleteIFile((IFile)mementoFolder.getFile(chartFunction.getName()), (boolean)true, (boolean)false, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
        }
        this.setChanged();
        this.notifyObservers();
        return result;
    }

    public List<ChartFunction> getChartFunctions() {
        return this.chartFunctionList;
    }

    public void sortContentsByName() {
        Collections.sort(this.chartFunctionList, new Comparator<ChartFunction>(){

            @Override
            public int compare(ChartFunction o1, ChartFunction o2) {
                if (o1.isReadOnly() && !o2.isReadOnly()) {
                    return 1;
                }
                if (!o1.isReadOnly() && o2.isReadOnly()) {
                    return -1;
                }
                return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
            }
        });
    }

    public void sortContentsByChartType() {
        Collections.sort(this.chartFunctionList, new Comparator<ChartFunction>(){

            @Override
            public int compare(ChartFunction o1, ChartFunction o2) {
                int compareResult = o1.getChartBuilder().getChartType().compareTo(o2.getChartBuilder().getChartType());
                if (compareResult != 0) {
                    return compareResult;
                }
                return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
            }
        });
    }

    private void loadContentsFromFiles() {
        if (!mementoFolder.exists()) {
            IResourceUtils.mkdirs((IFolder)mementoFolder, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
        }
        for (IResource currentResource : IResourceUtils.ls((IFolder)mementoFolder, (IProgressMonitor)new NullProgressMonitor(), (boolean)false)) {
            if (!(currentResource instanceof IFile)) continue;
            this.addChartFunction(ChartFunctionManager.loadFunctionFromFile((IMemento)MementoUtils.loadXMLMementoFromIFile((IFile)((IFile)currentResource), (boolean)true, (Charset)StandardCharsets.UTF_8)));
        }
    }

    private static ChartFunction loadFunctionFromFile(IMemento memento) {
        ChartFunction loadingChartFunction = new ChartFunction();
        new MementoParser().readWriteChartFunctionMemento(memento, loadingChartFunction, false);
        return loadingChartFunction;
    }

    public static void saveFunctionToFile(ChartFunction chartFunction) {
        ChartFunctionManager.saveFunctionToFile(chartFunction, "");
    }

    public static void saveFunctionToFile(ChartFunction chartFunction, String oldName) {
        if (chartFunction == null) {
            throw new IllegalArgumentException("Must specify non-null chartFunction.");
        }
        String name = chartFunction.getName();
        if (name == null || name.isEmpty()) {
            throw new IllegalStateException("Can't save a chart which doesn't have a name. Give the chart a name and try again.");
        }
        if (!mementoFolder.exists()) {
            IResourceUtils.mkdirs((IFolder)mementoFolder, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
        }
        if (oldName != null && !oldName.isEmpty() && !oldName.equals(name)) {
            IFile oldNameFile = mementoFolder.getFile(oldName);
            IResourceUtils.deleteIFile((IFile)oldNameFile, (boolean)true, (boolean)false, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
        }
        IFile saveFile = mementoFolder.getFile(name);
        XMLMemento memento = XMLMemento.createWriteRoot((String)"chartFunctions");
        new MementoParser().readWriteChartFunctionMemento((IMemento)memento, chartFunction, true);
        String xml = MementoUtils.saveXMLMementoToString((XMLMemento)memento);
        if (!saveFile.exists()) {
            IResourceUtils.createIFile((IFile)saveFile, (String)xml, (Charset)StandardCharsets.UTF_8, (boolean)true, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
        } else {
            IResourceUtils.setIFileContents((IFile)saveFile, (String)xml, (Charset)StandardCharsets.UTF_8, (boolean)true, (boolean)false, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
        }
    }
}

