/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.analytics.ui.view.model;

import com.ibm.etools.fa.pdtclient.analytics.Messages;
import com.ibm.etools.fa.pdtclient.analytics.chart.AbstractChartBuilder;
import com.ibm.etools.fa.pdtclient.analytics.chart.BarChartBuilder;
import com.ibm.etools.fa.pdtclient.analytics.data.ChartData;
import com.ibm.etools.fa.pdtclient.analytics.data.DatabaseManager;
import com.ibm.etools.fa.pdtclient.analytics.sql.SQLQueryParser;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.model.Condition;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.model.SeriesDef;
import com.ibm.etools.fa.pdtclient.analytics.util.FAAnalyticsUtility;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChartFunction
implements Cloneable {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private String name;
    private String query;
    private String drillDownTitleAddition;
    private boolean limitResults;
    private int resultsLimit;
    private boolean readOnly;
    private AbstractChartBuilder chartBuilder;

    public ChartFunction() {
        this("", "", "", false, 10, new BarChartBuilder());
    }

    public ChartFunction(String name, String query, String drillDownTitleAddition, boolean limitResults, int resultsLimit, AbstractChartBuilder chart) {
        this.setName(name);
        this.setQuery(query);
        this.setDrillDownTitleAddition(drillDownTitleAddition);
        this.setLimitResults(limitResults);
        this.setResultsLimit(resultsLimit);
        this.setChartBuilder(chart);
    }

    public String getName() {
        return this.name;
    }

    public AbstractChartBuilder getChartBuilder() {
        return this.chartBuilder;
    }

    public void setName(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Must specify a non-null name.");
        }
        this.name = s;
    }

    public void setChartBuilder(AbstractChartBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Must specify a non-null builder.");
        }
        this.chartBuilder = builder;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        if (query == null) {
            throw new IllegalArgumentException("Must specify a non-null query.");
        }
        this.query = query;
    }

    public String getDrillDownTitleAddition() {
        return this.drillDownTitleAddition;
    }

    public void setDrillDownTitleAddition(String drillDownTitleAddition) {
        if (drillDownTitleAddition == null) {
            throw new IllegalArgumentException("Must specify a non-null drillDownTitleAddition.");
        }
        this.drillDownTitleAddition = drillDownTitleAddition;
    }

    public boolean isLimitResults() {
        return this.limitResults;
    }

    public void setLimitResults(boolean limitResults) {
        this.limitResults = limitResults;
    }

    public int getResultsLimit() {
        return this.resultsLimit;
    }

    public void setResultsLimit(int resultsLimit) {
        this.resultsLimit = resultsLimit;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void prepareChart(DatabaseManager database) throws SQLException, NumberFormatException, IllegalArgumentException {
        if (database == null) {
            throw new IllegalArgumentException("Must specify a non-null DatabaseManager.");
        }
        this.prepareChart(database, false, 0);
    }

    public void prepareChart(DatabaseManager database, boolean useDisplayResultsLimit, int displayResultsLimit) throws SQLException, NumberFormatException, IllegalArgumentException {
        if (database == null) {
            throw new IllegalArgumentException("Must specify a non-null DatabaseManager.");
        }
        Object formattedDrillDownTitle = this.drillDownTitleAddition.isEmpty() ? "" : "(" + this.drillDownTitleAddition + ")";
        List<List<String>> rawData = useDisplayResultsLimit ? database.queryDatabase(this.query, displayResultsLimit) : database.queryDatabase(this.query, 0);
        if (rawData.isEmpty() || rawData.get(0).size() <= 1 || rawData.get(1).size() <= 1) {
            throw new IllegalArgumentException();
        }
        String xSeriesName = rawData.get(0).get(0);
        String ySeriesName = rawData.get(1).get(0);
        ArrayList<String> xSeriesData = new ArrayList<String>();
        int i = 1;
        while (i < rawData.get(0).size()) {
            xSeriesData.add(rawData.get(0).get(i));
            ++i;
        }
        ArrayList<Double> ySeriesData = new ArrayList<Double>();
        int i2 = 1;
        while (i2 < rawData.get(1).size()) {
            String rawString = rawData.get(1).get(i2);
            Double numericData = 0.0;
            if (rawString.isEmpty()) {
                rawString = "0";
            }
            if (!rawString.trim().matches("\\d+")) {
                throw new NumberFormatException(rawString + " is not useable as numeric data.");
            }
            numericData = Double.valueOf(rawString);
            ySeriesData.add(numericData);
            ++i2;
        }
        SQLQueryParser queryParser = new SQLQueryParser(database, this.query);
        String xColumnString = "";
        List<Condition> recordConditions = Collections.EMPTY_LIST;
        try {
            SeriesDef xColumnNoAlias = queryParser.parseSeries(true);
            xColumnNoAlias.setUseAlias(false);
            xColumnString = xColumnNoAlias.getBaseColumn();
            if (queryParser.isWhereExists()) {
                recordConditions = queryParser.parseRecordConditions();
            }
        }
        catch (Exception e) {
            xColumnString = "";
            recordConditions = Collections.EMPTY_LIST;
            PDLogger.get(this.getClass()).error((Object)Messages.ChartFunction_ParsingBaseXColumnAndConditionsFailed, (Throwable)e);
        }
        ChartData chartData = new ChartData(this.name, (String)formattedDrillDownTitle, xSeriesData, ySeriesData, xColumnString, recordConditions, xSeriesName, ySeriesName);
        if (!queryParser.isOrderExists()) {
            FAAnalyticsUtility.orderChartData(chartData);
        }
        this.chartBuilder.build(chartData);
    }

    public String toString() {
        if (this.readOnly) {
            return MessageFormat.format(Messages.ChartFunction_DefaultChartLabel, this.name + " (" + this.chartBuilder.getChartType().name + ")");
        }
        return this.name + " (" + this.chartBuilder.getChartType().name + ")";
    }

    public ChartFunction clone() throws CloneNotSupportedException {
        if (this.chartBuilder == null && (this.query == null || this.query.trim().isEmpty())) {
            return new ChartFunction();
        }
        return new ChartFunction(this.name, this.query, this.drillDownTitleAddition, this.limitResults, this.resultsLimit, this.chartBuilder.clone());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.chartBuilder == null ? 0 : this.chartBuilder.hashCode());
        result = 31 * result + (this.drillDownTitleAddition == null ? 0 : this.drillDownTitleAddition.hashCode());
        result = 31 * result + (this.limitResults ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
        result = 31 * result + this.resultsLimit;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChartFunction other = (ChartFunction)obj;
        if (this.chartBuilder == null ? other.chartBuilder != null : !this.chartBuilder.equals(other.chartBuilder)) {
            return false;
        }
        if (this.drillDownTitleAddition == null ? other.drillDownTitleAddition != null : !this.drillDownTitleAddition.equals(other.drillDownTitleAddition)) {
            return false;
        }
        if (this.limitResults != other.limitResults) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.query == null ? other.query != null : !this.query.equals(other.query)) {
            return false;
        }
        return this.resultsLimit == other.resultsLimit;
    }
}

