/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.analytics.ui.view;

import com.ibm.etools.fa.pdtclient.analytics.Messages;
import com.ibm.etools.fa.pdtclient.analytics.data.DatabaseManager;
import com.ibm.etools.fa.pdtclient.analytics.handler.OpenChartDisplayFromView;
import com.ibm.etools.fa.pdtclient.analytics.ui.view.model.ChartFunction;
import com.ibm.etools.fa.pdtclient.analytics.ui.view.model.ChartFunctionManager;
import com.ibm.etools.fa.pdtclient.analytics.widget.AnalyticsChartFunctionList;
import com.ibm.etools.fa.pdtclient.analytics.widget.IAnalyticsChartFunctionListUser;
import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.ui.impl.historyfile.RemoveHistoryFile;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventType;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class FAAnalyticsView
extends ViewPart
implements IAnalyticsChartFunctionListUser {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String PLUGIN_ID = "com.ibm.etools.fa.pdtclient.analytics";
    private final PDLogger logger = PDLogger.get(FAAnalyticsView.class);
    private static final String ID = "com.ibm.etools.fa.pdtclient.analytics.ui.view.AnalyticsView";
    public static final String ANALYTICS_DATASET_FOLDER_NAME = "analytics";
    private DatabaseManager database;
    private ChartFunctionManager chartFunctionManager;
    private AnalyticsChartFunctionList chartFunctionList;
    private Text statusText;
    private Group chartGroup;
    private final EListener<EntityEvent<IPDHost>> listener = new EListener<EntityEvent<IPDHost>>(){

        public void onEvent(EntityEvent<IPDHost> event1) {
            if (event1.getType() == EntityEventType.REMOVED && FAAnalyticsView.this.database != null && FAAnalyticsView.this.database.getSource() != null) {
                IPath path = FACorePlugin.getRoot().getFile(FAAnalyticsView.this.database.getSource()).getProjectRelativePath();
                if (((IPDHost)event1.getEntity()).getHostName().equals(path.segment(0)) && ("" + ((IPDHost)event1.getEntity()).getPort()).equals(path.segment(1))) {
                    FAAnalyticsView.this.clearView();
                }
            }
        }
    };

    public FAAnalyticsView() {
        this.chartFunctionManager = new ChartFunctionManager();
        RemoveHistoryFile.addHistoryFileDeleteCallback((RemoveHistoryFile.HistoryFileDeletedCallback)new RemoveHistoryFile.HistoryFileDeletedCallback(){

            public void deleted(String address, String port, String dataSet, String member) {
                if (FAAnalyticsView.this.database != null && FAAnalyticsView.this.database.getSource() != null && FAAnalyticsView.this.database.getSource().equalsIgnoreCase(MessageFormat.format("{0}/{1}/{2}.hfml", address, port, dataSet))) {
                    FAAnalyticsView.this.logger.trace((Object)MessageFormat.format("db source={0}", FAAnalyticsView.this.database.getSource()));
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (PDDialogs.openConfirmThreadSafe((String)Messages.FAAnalyticsView_1, (String)Messages.FAAnalyticsView_2)) {
                                FAAnalyticsView.this.clearView();
                            }
                        }
                    });
                }
            }
        });
    }

    public void createPartControl(Composite parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Must specify a non-null parent Composite.");
        }
        parent.setLayout((Layout)GUI.grid.l.margins((int)1, (boolean)false));
        this.chartGroup = GUI.group((Composite)parent, (String)Messages.FAAnalyticsView_ChartFunctions, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.chartFunctionList = new AnalyticsChartFunctionList((Composite)this.chartGroup, GUI.grid.d.fillAll(), this, this.chartFunctionManager);
        this.statusText = GUI.text((Composite)parent, (Object)GUI.grid.d.horiz((int)4, (boolean)false, (int)2), (int)8);
        RegistryLocator.instance().getHostRegistry().addListener(this.listener);
    }

    private void clearView() {
        try {
            this.database.updateDatabase(new ArrayList<Map<String, String>>());
            this.database.setSource(null);
        }
        catch (NumberFormatException | SQLException | ParseException e) {
            this.logger.info((Object)"Error occurred clearing analtics database.");
        }
        this.disableDatasetWidgetsAndUpdateStatus(ANALYTICS_DATASET_FOLDER_NAME);
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                FAAnalyticsView.this.chartFunctionList.dataSetWidgetsEnabled(false);
                FAAnalyticsView.this.statusText.setText("");
            }
        });
    }

    @Override
    public void displayChart(ChartFunction chartFunction) {
        OpenChartDisplayFromView.openChartDisplayFromDialog(chartFunction);
    }

    public void loadDataFromReportsList(final String source) {
        try {
            this.database = new DatabaseManager(source);
            Job populate = new Job(Messages.FAAnalyticsView_PopulatingLocalDatabaseJob){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.FAAnalyticsView_LoadingFaultEntriesMonitor, 1000);
                    try {
                        FAAnalyticsView.this.database.populateTable(monitor);
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                (this).FAAnalyticsView.this.chartFunctionList.setDatabase((this).FAAnalyticsView.this.database);
                                (this).FAAnalyticsView.this.statusText.setText(MessageFormat.format(Messages.FAAnalyticsView_DatasetLoaded, (this).FAAnalyticsView.this.database.getSize(), (this).FAAnalyticsView.this.database.getColumnNames().size(), source.replace(".hfml", "")));
                            }
                        });
                        return Status.OK_STATUS;
                    }
                    catch (SQLException e) {
                        FAAnalyticsView.this.logger.error((Object)(Messages.FAAnalyticsView_SQLErrorOnLoadingData + ":" + e.getMessage()));
                        FAAnalyticsView.this.disableDatasetWidgetsAndUpdateStatus(source.replace(".hfml", ""));
                        PDDialogs.openErrorThreadSafe((String)Messages.FAAnalyticsView_ErrorPopulatingDatabase, (String)Messages.FAAnalyticsView_SQLErrorOnLoadingData);
                    }
                    catch (IOException e) {
                        FAAnalyticsView.this.logger.error((Object)Messages.FAAnalyticsView_IOExceptionOnLoadingData, (Throwable)e);
                        FAAnalyticsView.this.disableDatasetWidgetsAndUpdateStatus(source.replace(".hfml", ""));
                        PDDialogs.openErrorThreadSafe((String)Messages.FAAnalyticsView_ErrorPopulatingDatabase, (String)Messages.FAAnalyticsView_IOExceptionOnLoadingData);
                    }
                    catch (ParseException e) {
                        FAAnalyticsView.this.logger.error((Object)Messages.FAAnalyticsView_ParsingExceptionOnLoadingData, (Throwable)e);
                        FAAnalyticsView.this.disableDatasetWidgetsAndUpdateStatus(source.replace(".hfml", ""));
                        PDDialogs.openErrorThreadSafe((String)Messages.FAAnalyticsView_ErrorPopulatingDatabase, (String)Messages.FAAnalyticsView_ParsingExceptionOnLoadingData);
                    }
                    return Status.CANCEL_STATUS;
                }
            };
            populate.setPriority(10);
            populate.setUser(true);
            PDPlatformUIUtils.scheduleAndMarkPartBusy((Job)populate, (IWorkbenchPartSite)this.getSite());
        }
        catch (NumberFormatException e) {
            this.disableDatasetWidgetsAndUpdateStatus(source.replace(".hfml", ""));
            this.logger.error((Object)Messages.FAAnalyticsView_NumberFormatExceptionOnLoadingData, (Throwable)e);
        }
        catch (CoreException e) {
            this.disableDatasetWidgetsAndUpdateStatus(source.replace(".hfml", ""));
            this.logger.error((Object)Messages.FAAnalyticsView_CoreExceptionOnLoadingData, (Throwable)e);
        }
    }

    private void disableDatasetWidgetsAndUpdateStatus(final String name) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                FAAnalyticsView.this.chartFunctionList.dataSetWidgetsEnabled(false);
                FAAnalyticsView.this.statusText.setText(MessageFormat.format(Messages.FAAnalyticsView_DataLoadFailed, name));
            }
        });
    }

    public static FAAnalyticsView findView() {
        return (FAAnalyticsView)PDPlatformUIUtils.view.findView((String)ID, FAAnalyticsView.class);
    }

    public static FAAnalyticsView show() {
        return (FAAnalyticsView)PDPlatformUIUtils.view.showView((String)ID, FAAnalyticsView.class);
    }

    public static FAAnalyticsView activate() {
        return (FAAnalyticsView)PDPlatformUIUtils.view.activate((String)ID, FAAnalyticsView.class);
    }

    public static ChartFunction getFirstSelectedChart() {
        Object selectedObject;
        ISelection selection;
        FAAnalyticsView view2 = FAAnalyticsView.findView();
        if (view2 != null && (selection = view2.getSite().getSelectionProvider().getSelection()) != null && selection instanceof IStructuredSelection && (selectedObject = ((IStructuredSelection)selection).getFirstElement()) != null) {
            return (ChartFunction)selectedObject;
        }
        return null;
    }

    public DatabaseManager getDatabase() {
        return this.database;
    }

    public ChartFunctionManager getChartFunctionManager() {
        return this.chartFunctionManager;
    }

    public void setFocus() {
        this.chartFunctionList.setFocus();
    }

    public void dispose() {
        this.chartFunctionList.onDispose();
        RegistryLocator.instance().getHostRegistry().removeListener(this.listener);
    }

    @Override
    public void additionalButtons(Composite buttonParent) {
    }

    public void showBusy(boolean busy) {
        if (busy) {
            this.setPartName(Messages.FAAnalyticsView_Loading);
        } else {
            this.setPartName(Messages.FAAnalyticsView_FaultAnalytics);
        }
    }
}

