/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.analytics.sql;

import com.ibm.etools.fa.pdtclient.analytics.data.DatabaseManager;
import com.ibm.etools.fa.pdtclient.analytics.data.filter.AggregateType;
import com.ibm.etools.fa.pdtclient.analytics.data.filter.ConditionType;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.model.AggregateCondition;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.model.Condition;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.model.SeriesDef;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLQueryParser {
    private static final PDLogger logger = PDLogger.get(SQLQueryParser.class);
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String CONTENT_REGEX = "(\\s*.*?\\s*)";
    private static final String OPTIONAL_CLAUSE_REGEX = "(?=WHERE|GROUP BY|HAVING|ORDER BY|$)";
    private static final String SELECT_CLAUSE = "SELECT";
    private static final Pattern SELECT_REGEX = Pattern.compile("(?<=SELECT)(\\s*.*?\\s*)(?=FROM)", 2);
    private static final Pattern COLUMN_IN_AGGREGATE_REGEX = Pattern.compile("((?<=\\()\\s*.*\\s*(?=\\)))", 2);
    private static final Pattern PLUS_ONE_IN_AGGREGATE_COLUMN_REGEX = Pattern.compile(".*\\+[\\s]+1", 2);
    private static final Pattern DISTINCT_REGEX = Pattern.compile("DISTINCT (.*)$", 2);
    private static final Pattern AGGREGATE_REGEX = Pattern.compile("(?<=^)(\\s*.*?\\s*)(?=\\()", 2);
    private static final String ALIAS_REGEX = "\\s+AS\\s+";
    private static final String FROM_CLAUSE = "FROM";
    private static final Pattern FROM_REGEX = Pattern.compile("(?<=FROM)(\\s*.*?\\s*)(?=WHERE|GROUP BY|HAVING|ORDER BY|$)", 2);
    public static final String TABLE_REGEX_STRING = "\\s+History";
    private static final Pattern TABLE_REGEX = Pattern.compile("\\s*History", 2);
    private static final String WHERE_CLAUSE = "WHERE";
    private static final Pattern WHERE_REGEX = Pattern.compile("(?<=WHERE)(\\s*.*?\\s*)(?=WHERE|GROUP BY|HAVING|ORDER BY|$)", 2);
    private static final Pattern CONDITION_RECORD_BETWEEN_OR_REGEX = Pattern.compile("(['\"].*?['\"]|[^\\s\\(]*)\\s*([^\\s]+)\\s*(['\"].*?['\"]|[^\\s\\)]*)", 2);
    private static final Pattern CONDITION_AGGREGATE_BETWEEN_OR_REGEX = Pattern.compile("(['\"].*?['\"]|[^\\s]*)\\s+([^\\s]+)\\s+(['\"].*?['\"]|[^\\s\\)]*)", 2);
    private static final String GROUP_CLAUSE = "GROUP BY";
    private static final Pattern GROUP_REGEX = Pattern.compile("(?<=GROUP BY)(\\s*.*?\\s*)(?=WHERE|GROUP BY|HAVING|ORDER BY|$)", 2);
    private static final String HAVING_CLAUSE = "HAVING";
    private static final Pattern HAVING_REGEX = Pattern.compile("(?<=HAVING)(\\s*.*?\\s*)(?=WHERE|GROUP BY|HAVING|ORDER BY|$)", 2);
    private static final String ORDER_CLAUSE = "ORDER BY";
    private static final Pattern ORDER_REGEX = Pattern.compile("(?<=ORDER BY)(\\s*.*?\\s*)(?=WHERE|GROUP BY|HAVING|ORDER BY|$)", 2);
    private static final Pattern ORDER_SPLIT_REGEX = Pattern.compile("(\\w*?[\\(]?[\\w]*?[\\t ]*[\"]?[\\w\\s]+[\"]?(?:[\\t ]+\\+?[\\t ]+[\\d]+)?[\\)]?)[\\t ]+(\\w+)", 2);
    private DatabaseManager database;
    private Map<String, String> clauseMap;
    private boolean mappingSuccessful;
    private boolean whereExists;
    private boolean groupExists;
    private boolean havingExists;
    private boolean orderExists;

    public SQLQueryParser(DatabaseManager database, String query) {
        if (database == null) {
            throw new IllegalArgumentException("Must specify non-null database,");
        }
        if (query == null) {
            throw new IllegalArgumentException("Must specify non-null query,");
        }
        this.database = database;
        this.clauseMap = new HashMap<String, String>();
        this.mappingSuccessful = true;
        this.whereExists = false;
        this.groupExists = false;
        this.havingExists = false;
        this.orderExists = false;
        this.regexQuery(query);
    }

    public SeriesDef parseSeries(boolean xSeries) throws Exception {
        String baseColumn;
        String selectContents = this.clauseMap.get(SELECT_CLAUSE);
        String series = selectContents.split(",")[xSeries ? 0 : 1];
        SeriesDef seriesDef = new SeriesDef();
        String[] splitByAlias = series.split(ALIAS_REGEX);
        if (splitByAlias.length == 1) {
            seriesDef.setUseAlias(false);
            baseColumn = splitByAlias[0];
        } else {
            seriesDef.setUseAlias(true);
            seriesDef.setAliasColumn(splitByAlias[1].replace("\"", ""));
            baseColumn = splitByAlias[0];
        }
        Matcher columnMatcher = COLUMN_IN_AGGREGATE_REGEX.matcher(baseColumn);
        baseColumn = !columnMatcher.find() ? baseColumn.replace("\"", "") : columnMatcher.group(1).replace("\"", "").split("\\+")[0].trim();
        Matcher distinctMatcher = DISTINCT_REGEX.matcher(baseColumn);
        if (distinctMatcher.find()) {
            seriesDef.setDistinct(true);
            baseColumn = distinctMatcher.group(1);
        }
        if (!this.database.getColumnNames().contains(baseColumn)) {
            throw new Exception((String)(baseColumn == null ? "null" : baseColumn + " is not in columnNames list"));
        }
        seriesDef.setBaseColumn(baseColumn);
        Matcher aggregateMatcher = AGGREGATE_REGEX.matcher(series);
        AggregateType aggregateFunction = !aggregateMatcher.find() ? AggregateType.NONE : (aggregateMatcher.group(1).equals(AggregateType.SUM.getName().toUpperCase()) ? SQLQueryParser.checkAggregateSumPlus(columnMatcher) : AggregateType.stringToAggregate(aggregateMatcher.group(1)));
        seriesDef.setAggregateFunction(aggregateFunction);
        return seriesDef;
    }

    public boolean parseTable() {
        String fromContents = this.clauseMap.get(FROM_CLAUSE);
        Matcher matcher = TABLE_REGEX.matcher(fromContents);
        return matcher.find();
    }

    public List<Condition> parseRecordConditions() throws Exception {
        String[] andConditions;
        ArrayList<Condition> conditionList = new ArrayList<Condition>();
        String whereContents = this.clauseMap.get(WHERE_CLAUSE);
        String[] stringArray = andConditions = whereContents.split("\\s+AND\\s+");
        int n = andConditions.length;
        int n2 = 0;
        while (n2 < n) {
            String conditionString = stringArray[n2];
            String trimmedCondition = conditionString.trim();
            if (trimmedCondition.startsWith("(") && trimmedCondition.endsWith(")")) {
                StringBuilder conditionBuilder = new StringBuilder(trimmedCondition);
                conditionBuilder.replace(0, 1, "");
                conditionBuilder.replace(conditionBuilder.length() - 1, conditionBuilder.length(), "");
                trimmedCondition = conditionBuilder.toString();
            }
            Condition condition = new Condition();
            Matcher matcher = CONDITION_RECORD_BETWEEN_OR_REGEX.matcher(trimmedCondition);
            if (!matcher.find()) {
                throw new Exception("matcher did not find");
            }
            String conditionColumn = matcher.group(1).replace("\"", "");
            if (!this.database.getColumnNames().contains(conditionColumn)) {
                throw new Exception((String)(conditionColumn == null ? "null" : conditionColumn + " not in list of columnNames"));
            }
            ConditionType conditionComparator = ConditionType.stringToConditionType(matcher.group(2));
            if (conditionComparator == null) {
                throw new Exception("conditionComparator is null");
            }
            String conditionValue = matcher.group(3);
            condition.setColumn(conditionColumn);
            condition.setComparator(conditionComparator);
            condition.setValue(conditionValue);
            conditionList.add(condition);
            ++n2;
        }
        return conditionList;
    }

    public String parseGrouping() throws Exception {
        return this.clauseMap.get(GROUP_CLAUSE).trim();
    }

    public List<AggregateCondition> parseAggregateConditions() throws Exception {
        String[] andConditions;
        ArrayList<AggregateCondition> conditionList = new ArrayList<AggregateCondition>();
        String havingContents = this.clauseMap.get(HAVING_CLAUSE);
        String[] stringArray = andConditions = havingContents.split("AND");
        int n = andConditions.length;
        int n2 = 0;
        while (n2 < n) {
            Matcher sumPlusMatcher;
            String conditionString = stringArray[n2];
            String trimmedCondition = conditionString.trim();
            if (trimmedCondition.startsWith("(") && trimmedCondition.endsWith(")")) {
                StringBuilder conditionBuilder = new StringBuilder(trimmedCondition);
                conditionBuilder.replace(0, 1, "");
                conditionBuilder.replace(conditionBuilder.length() - 1, conditionBuilder.length(), "");
                trimmedCondition = conditionBuilder.toString();
            }
            AggregateCondition aggregateCondition = new AggregateCondition();
            Matcher matcher = CONDITION_AGGREGATE_BETWEEN_OR_REGEX.matcher(trimmedCondition);
            if (!matcher.find()) {
                throw new Exception("matcher did not find");
            }
            Matcher columnMatcher = COLUMN_IN_AGGREGATE_REGEX.matcher(matcher.group(1));
            if (!columnMatcher.find()) {
                throw new Exception("columnMatcher did not find");
            }
            String conditionColumn = columnMatcher.group(1).replace("\"", "").split("\\+")[0].trim();
            if (!this.database.getColumnNames().contains(conditionColumn)) {
                throw new Exception();
            }
            aggregateCondition.setColumn(conditionColumn);
            Matcher aggregateMatcher = AGGREGATE_REGEX.matcher(matcher.group(1));
            if (!aggregateMatcher.find()) {
                throw new Exception("columnMatcher did not find");
            }
            AggregateType conditionAggregate = aggregateMatcher.group(1).equals(AggregateType.SUM.getName().toUpperCase()) ? ((sumPlusMatcher = PLUS_ONE_IN_AGGREGATE_COLUMN_REGEX.matcher(columnMatcher.group(1))).find() ? AggregateType.SUMPLUS : AggregateType.SUM) : AggregateType.stringToAggregate(aggregateMatcher.group(1));
            if (conditionAggregate == null) {
                throw new Exception("conditionAggregate is null");
            }
            aggregateCondition.setAggregateFunction(conditionAggregate);
            ConditionType conditionComparator = ConditionType.stringToConditionType(matcher.group(2));
            if (conditionComparator == null) {
                throw new Exception("conditionComparator is null");
            }
            aggregateCondition.setComparator(conditionComparator);
            try {
                Integer.valueOf(matcher.group(3));
            }
            catch (NumberFormatException e) {
                throw new Exception(e);
            }
            aggregateCondition.setValue(matcher.group(3));
            conditionList.add(aggregateCondition);
            ++n2;
        }
        return conditionList;
    }

    public String parseOrdering() throws Exception {
        String orderContents = this.clauseMap.get(ORDER_CLAUSE).trim();
        Matcher matcher = ORDER_SPLIT_REGEX.matcher(orderContents);
        if (!matcher.find()) {
            throw new Exception();
        }
        String result = matcher.group(1);
        return result;
    }

    public int parseOrderingType() throws Exception {
        String orderType;
        String orderContents = this.clauseMap.get(ORDER_CLAUSE).trim();
        Matcher matcher = ORDER_SPLIT_REGEX.matcher(orderContents);
        if (!matcher.find()) {
            throw new Exception("Could not find...");
        }
        if (matcher.groupCount() == 1) {
            return 0;
        }
        switch (orderType = matcher.group(2)) {
            case "ASC": {
                return -1;
            }
            case "DESC": {
                return 1;
            }
        }
        throw new Exception("order not asc or desc: " + (orderContents == null ? "null" : orderContents));
    }

    public String rebuildString() {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("SELECT " + this.clauseMap.get(SELECT_CLAUSE));
        queryBuilder.append(" FROM " + this.clauseMap.get(FROM_CLAUSE));
        if (this.whereExists) {
            queryBuilder.append(" WHERE " + this.clauseMap.get(WHERE_CLAUSE));
        }
        if (this.groupExists) {
            queryBuilder.append(" GROUP BY " + this.clauseMap.get(GROUP_CLAUSE));
        }
        if (this.havingExists) {
            queryBuilder.append(" HAVING " + this.clauseMap.get(HAVING_CLAUSE));
        }
        if (this.orderExists) {
            queryBuilder.append(" ORDER BY " + this.clauseMap.get(ORDER_CLAUSE));
        }
        return queryBuilder.toString();
    }

    private void regexQuery(String query) {
        Matcher orderMatcher;
        Matcher havingMatcher;
        Matcher groupMatcher;
        Matcher selectMatcher = SELECT_REGEX.matcher(query);
        if (!selectMatcher.find()) {
            logger.trace((Object)("mapping not successful: selectMatcher did not find. query: " + (query == null ? "null" : query)));
            this.mappingSuccessful = false;
            return;
        }
        this.clauseMap.put(SELECT_CLAUSE, selectMatcher.group().trim());
        Matcher fromMatcher = FROM_REGEX.matcher(query);
        if (!fromMatcher.find()) {
            logger.trace((Object)("mapping not successful: fromMatcher did not find. query: " + (query == null ? "null" : query)));
            this.mappingSuccessful = false;
            return;
        }
        this.clauseMap.put(FROM_CLAUSE, fromMatcher.group().trim());
        Matcher whereMatcher = WHERE_REGEX.matcher(query);
        if (whereMatcher.find()) {
            this.clauseMap.put(WHERE_CLAUSE, whereMatcher.group().trim());
            this.whereExists = true;
        }
        if ((groupMatcher = GROUP_REGEX.matcher(query)).find()) {
            this.clauseMap.put(GROUP_CLAUSE, groupMatcher.group().trim());
            this.groupExists = true;
        }
        if ((havingMatcher = HAVING_REGEX.matcher(query)).find()) {
            this.clauseMap.put(HAVING_CLAUSE, havingMatcher.group().trim());
            this.havingExists = true;
        }
        if ((orderMatcher = ORDER_REGEX.matcher(query)).find()) {
            this.clauseMap.put(ORDER_CLAUSE, orderMatcher.group().trim());
            this.orderExists = true;
        }
    }

    private static AggregateType checkAggregateSumPlus(Matcher columnMatcher) {
        Matcher sumPlusMatcher = PLUS_ONE_IN_AGGREGATE_COLUMN_REGEX.matcher(columnMatcher.group(1));
        return sumPlusMatcher.find() ? AggregateType.SUMPLUS : AggregateType.SUM;
    }

    public Map<String, String> getClauseMap() {
        return this.clauseMap;
    }

    public void setClauseMap(Map<String, String> clauseMap) {
        this.clauseMap = clauseMap;
    }

    public boolean isMappingSuccessful() {
        return this.mappingSuccessful;
    }

    public boolean isWhereExists() {
        return this.whereExists;
    }

    public void setWhereExists(boolean whereExists) {
        this.whereExists = whereExists;
    }

    public boolean isGroupExists() {
        return this.groupExists;
    }

    public void setGroupExists(boolean groupExists) {
        this.groupExists = groupExists;
    }

    public boolean isHavingExists() {
        return this.havingExists;
    }

    public void setHavingExists(boolean havingExists) {
        this.havingExists = havingExists;
    }

    public boolean isOrderExists() {
        return this.orderExists;
    }

    public void setOrderExists(boolean orderExists) {
        this.orderExists = orderExists;
    }
}

