/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.analytics.sql;

import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.model.AggregateCondition;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.model.Condition;
import com.ibm.etools.fa.pdtclient.analytics.ui.wizard.model.SeriesDef;
import java.util.Collections;
import java.util.List;

public class SQLQueryBuilder {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String QUERY_FORMAT_STRING = "SELECT %s%s FROM %s %s %s %s";
    private static final String TABLE_FORMAT_STRING = "History";
    private static final String WHERE_FORMAT_STRING = "WHERE %s";
    private static final String GROUP_FORMAT_STRING = "GROUP BY %s%s";
    private static final String HAVING_FORMAT_STRING = " HAVING %s";
    private static final String ORDER_FORMAT_STRING = "ORDER BY %s";
    private static final String ORDER_DESCENDING = " DESC";
    private static final String ORDER_ASCENDING = " ASC";
    private static final String CONDITION_FORMAT_STRING = "(%s)";
    private List<SeriesDef> selectedXSeries = Collections.EMPTY_LIST;
    private List<SeriesDef> selectedYSeries = Collections.EMPTY_LIST;
    private List<Condition> whereClauseConditions;
    private SeriesDef groupBySeries = null;
    private List<AggregateCondition> havingClauseConditions;
    private SeriesDef orderBySeries = null;
    private boolean orderDescending = true;

    public String buildQueryString() {
        String xSeries = SQLQueryBuilder.buildSeriesString(this.selectedXSeries);
        String ySeries = "";
        if (this.selectedYSeries != null && !this.selectedYSeries.isEmpty()) {
            ySeries = SQLQueryBuilder.buildSeriesString(this.selectedYSeries);
            ySeries = SQLQueryBuilder.removeTailComma(new StringBuilder(ySeries)).toString();
        } else if (xSeries.contains(",")) {
            xSeries = SQLQueryBuilder.removeTailComma(new StringBuilder(xSeries)).toString();
        }
        String table = SQLQueryBuilder.buildTableString();
        String conditional = this.buildWhereClauseString();
        String grouping = this.buildGroupingClauseString();
        String ordering = this.buildOrderingClauseString();
        return String.format(QUERY_FORMAT_STRING, xSeries, ySeries, table, conditional, grouping, ordering);
    }

    private static String buildSeriesString(List<SeriesDef> seriesList) {
        StringBuilder result = new StringBuilder("");
        for (SeriesDef currentSeries : seriesList) {
            if (currentSeries == null) continue;
            result.append(currentSeries.toString());
            result.append(",");
        }
        return result.toString();
    }

    private static String buildTableString() {
        return TABLE_FORMAT_STRING;
    }

    private String buildWhereClauseString() {
        StringBuilder result = new StringBuilder("");
        if (this.whereClauseConditions != null && !this.whereClauseConditions.isEmpty()) {
            StringBuilder conditions = new StringBuilder("");
            int i = 0;
            while (i < this.whereClauseConditions.size()) {
                Condition currentCondition = this.whereClauseConditions.get(i);
                conditions.append(String.format(CONDITION_FORMAT_STRING, currentCondition.toString()));
                if (i != this.whereClauseConditions.size() - 1) {
                    conditions.append(" AND ");
                }
                ++i;
            }
            result.append(String.format(WHERE_FORMAT_STRING, conditions));
        }
        return result.toString();
    }

    private String buildGroupingClauseString() {
        StringBuilder result = new StringBuilder("");
        if (this.groupBySeries != null) {
            result.append(String.format(GROUP_FORMAT_STRING, this.groupBySeries.getSeriesReference(), this.buildHavingClauseString()));
        }
        return result.toString();
    }

    private String buildHavingClauseString() {
        StringBuilder result = new StringBuilder("");
        if (this.havingClauseConditions != null && !this.havingClauseConditions.isEmpty()) {
            StringBuilder conditions = new StringBuilder("");
            int i = 0;
            while (i < this.havingClauseConditions.size()) {
                AggregateCondition currentCondition = this.havingClauseConditions.get(i);
                conditions.append(String.format(CONDITION_FORMAT_STRING, currentCondition.toString()));
                if (i != this.havingClauseConditions.size() - 1) {
                    conditions.append(" AND ");
                }
                ++i;
            }
            result.append(String.format(HAVING_FORMAT_STRING, conditions));
        }
        return result.toString();
    }

    private String buildOrderingClauseString() {
        StringBuilder result = new StringBuilder("");
        if (this.orderBySeries != null) {
            result.append(String.format(ORDER_FORMAT_STRING, this.orderBySeries.getSeriesReference() + (this.orderDescending ? ORDER_DESCENDING : ORDER_ASCENDING)));
        }
        return result.toString();
    }

    private static StringBuilder removeTailComma(StringBuilder stringBuilder) {
        if (stringBuilder.length() >= 1) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder;
    }

    public List<SeriesDef> getSelectedXSeries() {
        return this.selectedXSeries;
    }

    public void setSelectedXSeries(List<SeriesDef> selectedXSeries) {
        this.selectedXSeries = selectedXSeries;
    }

    public List<SeriesDef> getSelectedYSeries() {
        return this.selectedYSeries;
    }

    public void setSelectedYSeries(List<SeriesDef> selectedYSeries) {
        this.selectedYSeries = selectedYSeries;
    }

    public List<Condition> getWhereClauseConditions() {
        return this.whereClauseConditions;
    }

    public void setWhereClauseConditions(List<Condition> whereClauseConditions) {
        this.whereClauseConditions = whereClauseConditions;
    }

    public SeriesDef getGroupBySeries() {
        return this.groupBySeries;
    }

    public void setGroupBySeries(SeriesDef groupBySeries) {
        this.groupBySeries = groupBySeries;
    }

    public List<AggregateCondition> getHavingClauseConditions() {
        return this.havingClauseConditions;
    }

    public void setHavingClauseConditions(List<AggregateCondition> havingClauseConditions) {
        this.havingClauseConditions = havingClauseConditions;
    }

    public SeriesDef getOrderBySeries() {
        return this.orderBySeries;
    }

    public void setOrderBySeries(SeriesDef orderBySeries) {
        this.orderBySeries = orderBySeries;
    }

    public boolean isOrderDescending() {
        return this.orderDescending;
    }

    public void setOrderDescending(boolean orderDescending) {
        this.orderDescending = orderDescending;
    }
}

