/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.analytics.handler;

import com.ibm.etools.fa.pdtclient.analytics.Messages;
import com.ibm.etools.fa.pdtclient.analytics.chart.ChartType;
import com.ibm.etools.fa.pdtclient.analytics.data.DatabaseManager;
import com.ibm.etools.fa.pdtclient.analytics.editor.ChartEditorInput;
import com.ibm.etools.fa.pdtclient.analytics.ui.view.FAAnalyticsView;
import com.ibm.etools.fa.pdtclient.analytics.ui.view.model.ChartFunction;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.SQLException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;

public class OpenChartDisplayFromView
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) {
        OpenChartDisplayFromView.openChartDisplayFromDialog(FAAnalyticsView.getFirstSelectedChart());
    }

    public static void openChartDisplayFromDialog(ChartFunction chartFunction) {
        if (chartFunction != null) {
            FAAnalyticsView view2 = FAAnalyticsView.findView();
            ChartEditorInput displayInput = new ChartEditorInput(chartFunction, view2.getDatabase(), view2.getChartFunctionManager());
            IEditorReference[] iEditorReferenceArray = PDPlatformUIUtils.editor.getActiveEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                ChartEditorInput c;
                IEditorReference iEditorReference = iEditorReferenceArray[n2];
                IEditorInput input = PDPlatformUIUtils.editor.getInputFromEditorReference((IEditorReference)iEditorReference);
                if (input instanceof ChartEditorInput && (c = (ChartEditorInput)input).getChartFunction().equals(displayInput.getChartFunction())) {
                    PDPlatformUIUtils.getActiveIWorkbenchPage().activate((IWorkbenchPart)iEditorReference.getEditor(true));
                    return;
                }
                ++n2;
            }
            if (chartFunction.getChartBuilder().getChartType().equals((Object)ChartType.TEXT)) {
                DatabaseManager database = displayInput.getDatabase();
                boolean useResultsLimit = chartFunction.isLimitResults();
                int resultsLimit = chartFunction.getResultsLimit();
                try {
                    chartFunction.prepareChart(database, useResultsLimit, resultsLimit);
                    String text = chartFunction.getChartBuilder().getTextVersion();
                    File file = File.createTempFile(chartFunction.getName(), ".html");
                    Files.write(file.toPath(), text.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser(chartFunction.getName());
                    browser.openURL(file.toURI().toURL());
                }
                catch (IOException | IllegalArgumentException | SQLException | PartInitException e) {
                    PDLogger.get(OpenChartDisplayFromView.class).error(e);
                }
            } else if (PDPlatformUIUtils.editor.openEditor((IEditorInput)displayInput, (String)"com.ibm.etools.fa.pdtclient.analytics.editor.ChartEditorDisplay") == null) {
                PDLogger.get(OpenChartDisplayFromView.class).error((Object)Messages.OpenChartDisplayFromView_ErrorInitialisingChartDisplay);
                throw new RuntimeException();
            }
        }
    }
}

