/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.analytics.editor;

import com.ibm.etools.fa.pdtclient.analytics.Messages;
import com.ibm.etools.fa.pdtclient.analytics.action.ChangeResultsLimitAction;
import com.ibm.etools.fa.pdtclient.analytics.action.DisplayFaultEntryTableAction;
import com.ibm.etools.fa.pdtclient.analytics.action.SaveCurrentChartAction;
import com.ibm.etools.fa.pdtclient.analytics.action.SaveImageAction;
import com.ibm.etools.fa.pdtclient.analytics.data.DatabaseManager;
import com.ibm.etools.fa.pdtclient.analytics.editor.ChartEditorInput;
import com.ibm.etools.fa.pdtclient.analytics.sql.SQLQueryParser;
import com.ibm.etools.fa.pdtclient.analytics.ui.view.model.ChartFunction;
import com.ibm.etools.fa.pdtclient.analytics.ui.view.model.ChartFunctionManager;
import com.ibm.etools.fa.pdtclient.analytics.widget.ChartRenderer;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.sql.SQLException;
import java.text.MessageFormat;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class ChartEditorDisplay
extends EditorPart {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String ID = "com.ibm.etools.fa.pdtclient.analytics.editor.ChartEditorDisplay";
    private final PDLogger logger = PDLogger.get(ChartEditorDisplay.class);
    private Composite editorComposite;
    private ChartFunction chartFunction;
    private DatabaseManager database;
    private ChartFunctionManager chartManager;
    private Label dataSourceLabel;
    private Label wResultsLimitLabel;
    private ChartRenderer chartRenderer;
    private boolean useResultsLimit;
    private int resultsLimit;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof ChartEditorInput)) {
            this.logger.error((Object)Messages.ChartEditorDisplay_ErrorChartUnexpectedObjectChartDisplayInput);
            throw new RuntimeException();
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.chartFunction = ((ChartEditorInput)input).getChartFunction();
        this.useResultsLimit = this.chartFunction.isLimitResults();
        this.resultsLimit = this.chartFunction.getResultsLimit();
        this.database = ((ChartEditorInput)input).getDatabase();
        this.chartManager = ((ChartEditorInput)input).getChartManager();
        this.setPartName(this.chartFunction.getName());
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        block7: {
            this.editorComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)1, (boolean)true), (Object)GUI.grid.d.fillAll());
            this.editorComposite.setBackground(new Color(null, 255, 255, 255));
            this.chartRenderer = new ChartRenderer(this.editorComposite, 0, this.database, this.chartFunction);
            this.chartRenderer.setSize(this.editorComposite.getSize());
            this.chartRenderer.setLayoutData(GUI.grid.d.fillAll());
            try {
                this.chartFunction.prepareChart(this.database, this.useResultsLimit, this.resultsLimit);
                Chart chart = this.chartFunction.getChartBuilder().getChart();
                if (chart == null) break block7;
                this.chartRenderer.setChart(chart);
                this.chartRenderer.drawChart();
                this.chartRenderer.redraw();
                this.chartRenderer.update();
                MenuManager menuManager = new MenuManager();
                DisplayFaultEntryTableAction displayFaultEntryTableAction = new DisplayFaultEntryTableAction(this.database, this.chartFunction);
                ChangeResultsLimitAction changeResultsLimitAction = new ChangeResultsLimitAction(this);
                SaveCurrentChartAction saveCurrentChartAction = new SaveCurrentChartAction(this.getSite().getShell(), this);
                final SaveImageAction saveImageAction = new SaveImageAction(this.getSite().getShell(), chart, this.chartFunction.getName(), this.chartRenderer.getSize());
                menuManager.add((IAction)displayFaultEntryTableAction);
                menuManager.add((IAction)changeResultsLimitAction);
                menuManager.add((IAction)saveCurrentChartAction);
                menuManager.add((IAction)saveImageAction);
                SQLQueryParser parser = new SQLQueryParser(this.database, this.chartFunction.getQuery());
                try {
                    if (parser.parseSeries(true).getBaseColumn().equals("MONTH") || parser.parseSeries(true).getBaseColumn().equals("WEEKDAY")) {
                        changeResultsLimitAction.setEnabled(false);
                    }
                }
                catch (Exception e1) {
                    changeResultsLimitAction.setEnabled(false);
                }
                this.chartRenderer.addControlListener(new ControlListener(){

                    public void controlMoved(ControlEvent e) {
                    }

                    public void controlResized(ControlEvent e) {
                        saveImageAction.setSize(((Control)e.getSource()).getSize());
                    }
                });
                Menu editorMenu = menuManager.createContextMenu((Control)this.chartRenderer);
                this.chartRenderer.setMenu(editorMenu);
                Composite inputComposite = GUI.composite((Composite)this.editorComposite, (Layout)GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).create(), (Object)GridDataFactory.swtDefaults().span(2, 1).grab(true, false).create());
                this.dataSourceLabel = GUI.label((Composite)inputComposite, (String)MessageFormat.format(Messages.ChartEditorDisplay_ChartDataSource, this.database.getSource().replace(".hfml", "")), (Object)GUI.grid.d.left1(), (int)0);
                this.wResultsLimitLabel = GUI.label((Composite)inputComposite, (String)this.getResultsLimitLabel(), (Object)GridDataFactory.swtDefaults().span(1, 1).grab(true, false).create(), (int)16384);
            }
            catch (SQLException e) {
                this.renderSQLException(e);
            }
            catch (NumberFormatException e) {
                this.renderNumberFormatException(e);
            }
            catch (IllegalArgumentException e) {
                this.renderIllegalArgumentException(e);
            }
        }
    }

    private String getResultsLimitLabel() {
        return MessageFormat.format(Messages.ChartEditorDisplay_0, this.getResultsLimit());
    }

    public void refreshChart(boolean setTemporaryResultsLimit, int temporaryResultsLimit) {
        try {
            this.chartFunction.prepareChart(this.database, this.useResultsLimit, this.resultsLimit);
            this.chartRenderer.setChart(this.chartFunction.getChartBuilder().getChart());
            this.chartRenderer.drawChart();
            this.chartRenderer.redraw();
            this.chartRenderer.update();
        }
        catch (NumberFormatException e) {
            this.renderNumberFormatException(e);
        }
        catch (IllegalArgumentException e) {
            this.renderIllegalArgumentException(e);
        }
        catch (SQLException e) {
            this.renderSQLException(e);
        }
    }

    private void renderSQLException(SQLException e) {
        if (e == null) {
            throw new IllegalArgumentException("Must provide a non-null SQLException.");
        }
        this.chartRenderer.dispose();
        if (this.editorComposite == null) {
            throw new IllegalStateException("Must call createPartControl first.");
        }
        Composite errorComposite = GUI.composite((Composite)this.editorComposite, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)GUI.grid.d.fillAll());
        GUI.label((Composite)errorComposite, (String)MessageFormat.format(Messages.ChartEditorDisplay_SQLExceptionOnRenderChart, this.chartFunction.getName()), (Object)GUI.grid.d.left1(), (int)0);
        Text errorText = GUI.text((Composite)errorComposite, (Object)GUI.grid.d.fillAll(), (int)74);
        errorText.setBackground(new Color(null, 255, 255, 255));
        errorText.setText(e.getMessage());
        this.logger.error((Object)Messages.ChartEditorDisplay_SQLExceptionWhileRetrievingData, (Throwable)e);
    }

    private void renderNumberFormatException(NumberFormatException e) {
        this.chartRenderer.dispose();
        Composite errorComposite = GUI.composite((Composite)this.editorComposite, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)GUI.grid.d.fillAll());
        GUI.label((Composite)errorComposite, (String)MessageFormat.format(Messages.ChartEditorDisplay_DataFormatExceptionOnRenderChart, this.chartFunction.getName()), (Object)GUI.grid.d.left1(), (int)0);
        GUI.label((Composite)errorComposite, (String)Messages.ChartEditorDisplay_DataFormatExceptionExplanation, (Object)GUI.grid.d.left1(), (int)0);
        Text errorText = GUI.text((Composite)errorComposite, (Object)GUI.grid.d.fillAll(), (int)74);
        errorText.setText(e.getMessage());
        this.logger.error((Object)Messages.ChartEditorDisplay_DataFormatExceptionLog, (Throwable)e);
    }

    private void renderIllegalArgumentException(IllegalArgumentException e) {
        this.chartRenderer.dispose();
        Composite errorComposite = GUI.composite((Composite)this.editorComposite, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)GUI.grid.d.fillAll());
        GUI.label((Composite)errorComposite, (String)MessageFormat.format(Messages.ChartEditorDisplay_NoDataRetrieved, this.chartFunction.getName()), (Object)GUI.grid.d.left1(), (int)0);
        GUI.label((Composite)errorComposite, (String)Messages.ChartEditorDisplay_DataEmpty, (Object)GUI.grid.d.left1(), (int)0);
        this.logger.warn((Object)Messages.ChartEditorDisplay_DateEmptyExplanation, (Throwable)e);
    }

    public ChartFunction getChartFunction() {
        return this.chartFunction;
    }

    public void setChartFunction(ChartFunction chartFunction) {
        if (chartFunction == null) {
            throw new IllegalArgumentException("Must specify a non-null chartFunction.");
        }
        this.chartFunction = chartFunction;
    }

    public DatabaseManager getDatabase() {
        return this.database;
    }

    public void setDatabase(DatabaseManager database) {
        if (database == null) {
            throw new IllegalArgumentException("Must specify a non-null databaseManager.");
        }
        this.database = database;
    }

    public ChartFunctionManager getChartManager() {
        return this.chartManager;
    }

    public void setChartManager(ChartFunctionManager chartManager) {
        this.chartManager = chartManager;
    }

    public ChartRenderer getChartRenderer() {
        return this.chartRenderer;
    }

    public void setChartRenderer(ChartRenderer chartRenderer) {
        if (chartRenderer == null) {
            throw new IllegalArgumentException("Must provide a non-null ChartRenderer.");
        }
        this.chartRenderer = chartRenderer;
    }

    public boolean isUseResultsLimit() {
        return this.useResultsLimit;
    }

    public void setUseResultsLimit(boolean useResultsLimit) {
        this.useResultsLimit = useResultsLimit;
    }

    public int getResultsLimit() {
        return this.resultsLimit;
    }

    public void setResultsLimit(int resultsLimit) {
        this.resultsLimit = resultsLimit;
        if (this.wResultsLimitLabel != null) {
            this.wResultsLimitLabel.setText(this.getResultsLimitLabel());
            this.wResultsLimitLabel.getParent().pack();
        }
    }

    public void setFocus() {
        if (this.chartRenderer != null && !this.chartRenderer.isDisposed()) {
            this.chartRenderer.setFocus();
        }
    }

    public void dispose() {
        this.chartRenderer.dispose();
        super.dispose();
    }
}

