/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.analytics.data.filter;

import com.ibm.etools.fa.pdtclient.analytics.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum AggregateType {
    NONE(Messages.AggregateType_None, "%s"),
    COUNT(Messages.AggregateType_Count, "COUNT(%s)"),
    AVERAGE(Messages.AggregateType_Average, "AVG(%s)"),
    MAX(Messages.AggregateType_Maximum, "MAX(%s)"),
    MIN(Messages.AggregateType_Minimum, "MIN(%s)"),
    SUM(Messages.AggregateType_Sum, "SUM(%s)"),
    SUMPLUS(Messages.AggregateType_SumPlus0, "SUM(%s + 1)");

    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private String name;
    private String queryFormat;

    private AggregateType(String name, String queryFormat) {
        this.name = name;
        this.queryFormat = queryFormat;
    }

    public String getName() {
        return this.name;
    }

    public String getFormat() {
        return this.queryFormat;
    }

    public static List<AggregateType> allAggregateFunctions() {
        ArrayList<AggregateType> types = new ArrayList<AggregateType>(Arrays.asList(AggregateType.values()));
        types.remove((Object)NONE);
        return types;
    }

    public static AggregateType stringToAggregate(String input) {
        if (input == null) {
            throw new IllegalArgumentException("Must specify a non-null input String.");
        }
        AggregateType[] aggregateTypeArray = AggregateType.values();
        int n = aggregateTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AggregateType aggregateType = aggregateTypeArray[n2];
            if (aggregateType.getFormat().toLowerCase().replace("(%s)", "").equals(input.toLowerCase())) {
                return aggregateType;
            }
            ++n2;
        }
        return null;
    }
}

